/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.signup;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.feature.customer.user.ServiceDeskUserManager;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.NewSignupUser;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.ServiceDeskSignupValidator;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.SignupManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskJiraRoleManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskProjectRole;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SignupManagerImpl
implements SignupManager {
    private static final Logger log = LoggerFactory.getLogger(SignupManagerImpl.class);
    private final ServiceDeskSignupValidator signupValidator;
    private final ServiceDeskUserManager serviceDeskUserManager;
    private final ServiceDeskJiraRoleManager serviceDeskJIRARoleManager;
    private final CrowdService crowdService;
    private final ErrorResultHelper errorResultHelper;
    private static final Option<Project> NO_PROJECT = Option.none();
    private static final boolean VALIDATE_CAPTCHA = true;
    private static final boolean DONT_VALIDATE_CAPTCHA = false;
    private static final String EMPTY_CAPTCHA = "";
    private static final Option<String> NO_PASSWORD = Option.none();

    @Autowired
    public SignupManagerImpl(ServiceDeskSignupValidator signupValidator, ServiceDeskUserManager serviceDeskUserManager, @Qualifier(value="crowdService") CrowdService crowdService, ServiceDeskJiraRoleManager serviceDeskJIRARoleManager, ErrorResultHelper errorResultHelper) {
        this.signupValidator = signupValidator;
        this.serviceDeskUserManager = serviceDeskUserManager;
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskJIRARoleManager = serviceDeskJIRARoleManager;
        this.crowdService = crowdService;
    }

    @Override
    public Either<AnError, Either<ValidationErrors, JSDSuccess>> validateSignUpCustomerThroughInvite(Project project, String email, Option<String> password) {
        NewSignupUser newSignupUser = this.createNewSignupUser(email, password, email, EMPTY_CAPTCHA);
        return this.doBaseSignupValidationForCustomerThroughInvite(project, newSignupUser).map(resultEither -> resultEither.map(result -> JSDSuccess.success()));
    }

    @Override
    public Either<AnError, Either<ValidationErrors, CheckedUser>> signUpCustomerThroughInvite(Project project, String email, Option<String> password, boolean invitingToOrganisation) {
        NewSignupUser newSignupUser = this.createNewSignupUser(email, password, email, EMPTY_CAPTCHA);
        Either signedUpUser = Steps.begin(this.doBaseSignupValidationForCustomerThroughInvite(project, newSignupUser)).then(userValidationResultEither -> this.createSignUpCustomerInOptionalRoleThroughInvite(newSignupUser, (Either<ValidationErrors, UserService.CreateUserValidationResult>)userValidationResultEither, (Option<Project>)(invitingToOrganisation ? Option.none() : Option.some((Object)project)))).yield((userValidationResult, user) -> user);
        signedUpUser.foreach(either -> either.foreach(this.serviceDeskUserManager::addExternalInviteProperty));
        return signedUpUser;
    }

    @Override
    public Either<AnError, Either<ValidationErrors, CheckedUser>> signUpCustomer(String email, Option<String> password, String fullName, String captcha) {
        NewSignupUser newSignupUser = this.createNewSignupUser(email, password, fullName, captcha);
        if (!this.signupValidator.isSignupSupportedFromHelpCenter()) {
            return Either.left((Object)this.errorResultHelper.badRequest400("cv.signup.error.not.allowed", new Object[0]).build());
        }
        Either<AnError, Either<ValidationErrors, CheckedUser>> signedUpUser = this.validateAndCreateCustomer(newSignupUser, NO_PROJECT, true);
        signedUpUser.foreach(either -> either.foreach(this.serviceDeskUserManager::addExternalSignUpProperty));
        return signedUpUser;
    }

    @Override
    public Either<AnError, Either<ValidationErrors, CheckedUser>> signUpCustomerToServiceDesk(ServiceDesk serviceDesk, Project project, String email, Option<String> password, String fullName, String captcha) {
        NewSignupUser newSignupUser = this.createNewSignupUser(email, password, fullName, captcha);
        if (!this.signupValidator.isSignUpSupportedFromPortal(serviceDesk, project)) {
            return Either.left((Object)this.errorResultHelper.badRequest400("cv.signup.error.not.allowed", new Object[0]).build());
        }
        Either<AnError, Either<ValidationErrors, CheckedUser>> signedUpUser = this.validateAndCreateCustomer(newSignupUser, (Option<Project>)Option.some((Object)project), true);
        signedUpUser.foreach(either -> either.foreach(this.serviceDeskUserManager::addExternalSignUpProperty));
        return signedUpUser;
    }

    @Override
    public Either<AnError, Either<ValidationErrors, CheckedUser>> signUpCustomerThroughSupportEmail(ServiceDesk serviceDesk, Project project, String email) {
        NewSignupUser newSignupUser = this.createNewSignupUser(email, NO_PASSWORD, email, EMPTY_CAPTCHA);
        if (!this.signupValidator.isSignUpSupportedFromPortal(serviceDesk, project)) {
            return Either.left((Object)this.errorResultHelper.badRequest400("cv.signup.error.not.allowed", new Object[0]).build());
        }
        Either<AnError, Either<ValidationErrors, CheckedUser>> signedUpUser = this.validateAndCreateCustomer(newSignupUser, (Option<Project>)Option.some((Object)project), false);
        signedUpUser.foreach(either -> either.foreach(this.serviceDeskUserManager::addExternalSupportEmailProperty));
        return signedUpUser;
    }

    @Override
    public Either<AnError, Either<ValidationErrors, CheckedUser>> signUpCustomerThroughAPI(String email, String fullName) {
        NewSignupUser newSignupUser = this.createNewSignupUser(email, (Option<String>)Option.none(), fullName, EMPTY_CAPTCHA);
        Either<AnError, Either<ValidationErrors, CheckedUser>> signedUpUser = this.validateAndCreateCustomer(newSignupUser, NO_PROJECT, false);
        signedUpUser.foreach(either -> either.foreach(this.serviceDeskUserManager::addExternalSignUpProperty));
        return signedUpUser;
    }

    private NewSignupUser createNewSignupUser(String email, Option<String> password, String fullName, String captcha) {
        return new NewSignupUser(email, password, password, email, fullName, captcha);
    }

    private Either<AnError, Either<ValidationErrors, CheckedUser>> validateAndCreateCustomer(NewSignupUser newSignupUser, Option<Project> project, boolean validateCaptcha) {
        Either<AnError, Either<ValidationErrors, UserService.CreateUserValidationResult>> validationResult = validateCaptcha ? this.signupValidator.validateInputForCustomerSignUp(newSignupUser.getEmail(), newSignupUser.getPassword(), newSignupUser.getFullName(), newSignupUser.getCaptcha()) : this.signupValidator.validateInputForCustomerCreationWithoutCaptcha(newSignupUser.getEmail(), newSignupUser.getPassword(), newSignupUser.getFullName());
        return Steps.begin(validationResult).then(userValidationResult -> this.createSignUpCustomerInOptionalRole(newSignupUser, (Either<ValidationErrors, UserService.CreateUserValidationResult>)userValidationResult, project)).yield((userValidationResult, user) -> user);
    }

    private Either<AnError, Either<ValidationErrors, UserService.CreateUserValidationResult>> doBaseSignupValidationForCustomerThroughInvite(Project project, NewSignupUser newSignupUser) {
        if (!this.signupValidator.isSignUpThroughInviteSupported(project)) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.agent.people.customers.invite.error.sign.up.is.not.allowed", new Object[0]).build());
        }
        return this.signupValidator.validateInputForCustomerCreationWithoutCaptcha(newSignupUser.getEmail(), newSignupUser.getPassword(), newSignupUser.getFullName());
    }

    private Either<AnError, Either<ValidationErrors, CheckedUser>> createSignUpCustomerInOptionalRole(NewSignupUser newUser, Either<ValidationErrors, UserService.CreateUserValidationResult> userValidationResultEither, Option<Project> projectOption) {
        return this.doCreateSignUpCustomerInOptionalRole(newUser, userValidationResultEither, projectOption, false);
    }

    private Either<AnError, Either<ValidationErrors, CheckedUser>> createSignUpCustomerInOptionalRoleThroughInvite(NewSignupUser newUser, Either<ValidationErrors, UserService.CreateUserValidationResult> userValidationResultEither, Option<Project> projectOption) {
        return this.doCreateSignUpCustomerInOptionalRole(newUser, userValidationResultEither, projectOption, true);
    }

    private Either<AnError, Either<ValidationErrors, CheckedUser>> doCreateSignUpCustomerInOptionalRole(NewSignupUser newUser, Either<ValidationErrors, UserService.CreateUserValidationResult> userValidationResultEither, Option<Project> projectOption, boolean inInviteContext) {
        return Steps.begin(this.doSignup(userValidationResultEither, inInviteContext)).then(userEither -> this.optionalAddUserToCustomerRole((Either<ValidationErrors, CheckedUser>)userEither, newUser.getUsername(), projectOption, inInviteContext)).yield((user, roleUser) -> roleUser);
    }

    private Either<AnError, Either<ValidationErrors, CheckedUser>> doSignup(Either<ValidationErrors, UserService.CreateUserValidationResult> userValidationResultEither, boolean inInviteContext) {
        if (userValidationResultEither.isLeft()) {
            return Either.right((Object)Either.left((Object)userValidationResultEither.left().get()));
        }
        UserService.CreateUserValidationResult createUsernameValidationResult = (UserService.CreateUserValidationResult)userValidationResultEither.right().get();
        Either<AnError, CheckedUser> serviceDeskRequestorThroughInvite = inInviteContext ? this.serviceDeskUserManager.createServiceDeskRequestorThroughInvite(createUsernameValidationResult) : this.serviceDeskUserManager.createServiceDeskRequestor(createUsernameValidationResult);
        return serviceDeskRequestorThroughInvite.map(Either::right);
    }

    private Either<AnError, Either<ValidationErrors, CheckedUser>> optionalAddUserToCustomerRole(Either<ValidationErrors, CheckedUser> userEither, String username, Option<Project> projectOption, boolean inInviteContext) {
        if (userEither.isLeft()) {
            return Either.right((Object)Either.left((Object)userEither.left().get()));
        }
        CheckedUser user = (CheckedUser)userEither.right().get();
        if (projectOption.isDefined()) {
            Either<AnError, CheckedUser> customerRoleResult = inInviteContext ? this.serviceDeskJIRARoleManager.addUserToRoleThroughInvite(user, (Project)projectOption.get(), ServiceDeskProjectRole.CUSTOMER) : this.serviceDeskJIRARoleManager.addUserToRole(user, (Project)projectOption.get(), ServiceDeskProjectRole.CUSTOMER);
            customerRoleResult.left().foreach(error -> this.deletePartiallyCreatedUser(username));
            return customerRoleResult.map(Either::right);
        }
        return Either.right((Object)Either.right((Object)user));
    }

    private Either<AnError, String> deletePartiallyCreatedUser(String username) {
        User user = this.crowdService.getUser(username);
        try {
            this.crowdService.removeUser(user);
            return Either.right((Object)username);
        }
        catch (OperationNotPermittedException | OperationFailedException e) {
            log.error("Could not delete partially created user: " + username, e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("cv.signup.error.failed.to.remove.user", new Object[0]).build());
        }
    }
}

