/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.signup;

import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.feature.customer.user.ServiceDeskUserManager;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.ServiceDeskSignupValidator;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailUtil;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.permission.restore.PermissionSchemeMisconfigurationService;
import com.atlassian.servicedesk.internal.util.SignUpJIRAHelper;
import com.atlassian.servicedesk.squalor.service.CaptchaService;
import com.atlassian.servicedesk.squalor.service.CaptchaServiceException;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskSignupValidatorImpl
implements ServiceDeskSignupValidator {
    private static final Logger log = Logger.getLogger(ServiceDeskSignupValidatorImpl.class);
    private static final String EMAIL_FIELD = "email";
    private static final String USERNAME_FIELD = "username";
    private static final String PASSWORD_FIELD = "password";
    private static final String CAPTCHA_FIELD = "captcha";
    private static final String SIGNUP_VALIDATION_ERROR_KEY = "signup.validation.errors";
    private static final String SIGNUP_ERROR_EMAIL_VALID_KEY = "signup.error.email.valid";
    private static final String SIGNUP_ERROR_USERNAME_EXISTS_KEY = "signup.error.username.exists";
    private static final String SIGNUP_ERROR_PASSWORD_REQUIRED_KEY = "signup.error.password.required";
    private static final String CV_SIGNUP_ERROR_JIRA_PASSWORD_REQUIRED_KEY = "cv.signup.error.jira.password.required";
    private static final String CV_SIGNUP_ERROR_EMAIL_USED_KEY = "cv.signup.error.email.used";
    private static final String CV_SIGNUP_ERROR_BLANK_PASSWORD_KEY = "cv.signup.error.blank.password";
    private static final String CV_SIGNUP_ERROR_CAPTCHA_DOESNT_MATCH_KEY = "cv.signup.error.captcha.doesnt.match";
    private final ApplicationProperties applicationProperties;
    private final UserFactory userFactory;
    private final UserManager userManager;
    private final CaptchaService captchaService;
    private final InternalServiceDeskAccessService internalServiceDeskAccessService;
    private final PermissionSchemeMisconfigurationService permissionSchemeMisconfigurationService;
    private final SignUpJIRAHelper signUpJIRAHelper;
    private final FeatureManager featureManager;
    private final ServiceDeskUserManager serviceDeskUserManager;

    @Autowired
    public ServiceDeskSignupValidatorImpl(ApplicationProperties applicationProperties, UserFactory userFactory, UserManager userManager, CaptchaService captchaService, InternalServiceDeskAccessService internalServiceDeskAccessService, PermissionSchemeMisconfigurationService permissionSchemeMisconfigurationService, SignUpJIRAHelper signUpJIRAHelper, FeatureManager featureManager, ServiceDeskUserManager serviceDeskUserManager) {
        this.applicationProperties = applicationProperties;
        this.userFactory = userFactory;
        this.userManager = userManager;
        this.captchaService = captchaService;
        this.internalServiceDeskAccessService = internalServiceDeskAccessService;
        this.permissionSchemeMisconfigurationService = permissionSchemeMisconfigurationService;
        this.signUpJIRAHelper = signUpJIRAHelper;
        this.featureManager = featureManager;
        this.serviceDeskUserManager = serviceDeskUserManager;
    }

    @Override
    public boolean isCaptchaSupported() {
        return !this.featureManager.isEnabled(SDFeatureFlags.HELP_CENTER_CUSTOMER_SIGNUP_HONEYPOT) && this.applicationProperties.getOption("jira.option.captcha.on.signup");
    }

    @Override
    public boolean isSignupSupportedFromHelpCenter() {
        return this.featureManager.isEnabled(SDFeatureFlags.HELP_CENTER_CUSTOMER_SIGNUP) && this.isBaseSignupRequirementsSupported((Option<Project>)Option.none()) != false && this.internalServiceDeskAccessService.hasAnyServiceDesksWithPublicSignup();
    }

    @Override
    public boolean isSignUpSupportedFromPortal(ServiceDesk serviceDesk, Project project) {
        return serviceDesk.getProjectId() == project.getId().longValue() && this.internalServiceDeskAccessService.isPublicSignupEnabled(serviceDesk) && this.isBaseSignupRequirementsSupported((Option<Project>)Option.some((Object)project)) != false;
    }

    @Override
    public boolean isSignUpThroughInviteSupported(Project project) {
        return this.isBaseSignupRequirementsSupported((Option<Project>)Option.some((Object)project));
    }

    @Override
    public Either<AnError, Either<ValidationErrors, UserService.CreateUserValidationResult>> validateInputForCustomerSignUp(String email, Option<String> password, String fullName, String captcha) {
        UserService.CreateUserValidationResult validationResult = this.getDefaultJIRASignUpValidationResult(email, password, email, fullName);
        if (this.isCaptchaSupported()) {
            this.validateCaptcha(captcha, validationResult);
        }
        if (!validationResult.getErrorCollection().getErrors().containsKey(EMAIL_FIELD)) {
            String usernameErrorI18nedMessage;
            String usernameErrorMessage = (String)validationResult.getErrorCollection().getErrors().get(USERNAME_FIELD);
            if (Objects.equals(usernameErrorMessage, usernameErrorI18nedMessage = this.i18nHelper().getText(SIGNUP_ERROR_USERNAME_EXISTS_KEY))) {
                this.addI18nedError(validationResult, EMAIL_FIELD, CV_SIGNUP_ERROR_EMAIL_USED_KEY);
            } else if (usernameErrorMessage != null) {
                this.addI18nedError(validationResult, EMAIL_FIELD, SIGNUP_ERROR_EMAIL_VALID_KEY);
            } else {
                this.validateEmail(email, validationResult);
            }
        }
        this.validateBlankPassword((String)password.getOrElse((Object)""), validationResult);
        String passwordErrorMessage = (String)validationResult.getErrorCollection().getErrors().get(PASSWORD_FIELD);
        String passwordErrorI18nedMessage = this.i18nHelper().getText(SIGNUP_ERROR_PASSWORD_REQUIRED_KEY);
        if (Objects.equals(passwordErrorMessage, passwordErrorI18nedMessage)) {
            this.addI18nedError(validationResult, PASSWORD_FIELD, CV_SIGNUP_ERROR_JIRA_PASSWORD_REQUIRED_KEY);
        }
        return this.processSignupResult(validationResult);
    }

    @Override
    public Either<AnError, Either<ValidationErrors, UserService.CreateUserValidationResult>> validateInputForCustomerCreationWithoutCaptcha(String email, Option<String> password, String fullName) {
        return this.processSignupResult(this.getDefaultJIRASignUpValidationResult(email, password, email, fullName));
    }

    private Boolean isBaseSignupRequirementsSupported(Option<Project> project) {
        return this.userManager.hasWritableDirectory() && project.forall(p -> !this.permissionSchemeMisconfigurationService.isCustomerRoleCriticallyMisconfigured((Project)p));
    }

    private void validateEmail(String email, UserService.CreateUserValidationResult validationResult) {
        if (StringUtils.isBlank((String)email) || !EmailUtil.isEmailAddressValidForNewSignup(email)) {
            this.addI18nedError(validationResult, EMAIL_FIELD, SIGNUP_ERROR_EMAIL_VALID_KEY);
        } else if (!this.serviceDeskUserManager.isEmailValidForNewCustomer(email)) {
            this.addI18nedError(validationResult, EMAIL_FIELD, CV_SIGNUP_ERROR_EMAIL_USED_KEY);
        }
    }

    private void validateBlankPassword(String password, UserService.CreateUserValidationResult validationResult) {
        if (StringUtils.isBlank((String)password)) {
            this.addI18nedError(validationResult, PASSWORD_FIELD, CV_SIGNUP_ERROR_BLANK_PASSWORD_KEY);
        }
    }

    private void validateCaptcha(String captchaResponse, UserService.CreateUserValidationResult validationResult) {
        try {
            String id = ExecutingHttpRequest.get().getSession().getId();
            Option isValidResponse = Option.option((Object)this.captchaService.validateResponseForID(id, (Object)captchaResponse));
            if (!((Boolean)isValidResponse.getOrElse((Object)false)).booleanValue()) {
                this.addI18nedError(validationResult, CAPTCHA_FIELD, CV_SIGNUP_ERROR_CAPTCHA_DOESNT_MATCH_KEY);
            }
        }
        catch (CaptchaServiceException e) {
            log.error((Object)"Problem with Captcha service", (Throwable)e);
            this.addI18nedError(validationResult, CAPTCHA_FIELD, CV_SIGNUP_ERROR_CAPTCHA_DOESNT_MATCH_KEY);
        }
    }

    private void addI18nedError(UserService.CreateUserValidationResult validationResult, String fieldName, String i18nKey) {
        String i18nedErrorMessage = this.i18nHelper().getText(i18nKey);
        validationResult.getErrorCollection().addError(fieldName, i18nedErrorMessage);
    }

    private UserService.CreateUserValidationResult getDefaultJIRASignUpValidationResult(String username, Option<String> password, String email, String fullName) {
        return this.signUpJIRAHelper.getSignUpResultAfterValidation(username, password, password, email, fullName);
    }

    private Either<AnError, Either<ValidationErrors, UserService.CreateUserValidationResult>> processSignupResult(UserService.CreateUserValidationResult result) {
        if (result.isValid()) {
            return Either.right((Object)Either.right((Object)result));
        }
        ValidationErrors validationErrors = ValidationErrors.newBuilder((ErrorCollection)result.getErrorCollection()).reasonKey(SIGNUP_VALIDATION_ERROR_KEY).build();
        return Either.right((Object)Either.left((Object)validationErrors));
    }

    private I18nHelper i18nHelper() {
        return this.userFactory.getUncheckedUser().i18NHelper();
    }
}

