/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.search;

import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.bridge.api.usersearch.UserSearchServiceFilterUsersSortingBridge;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
public class UserSearchManagerImpl
implements UserSearchManager {
    private final UserSearchService userSearchService;
    private final UserSearchServiceFilterUsersSortingBridge userSearchServiceFilterUsersSortingBridge;

    @Autowired
    public UserSearchManagerImpl(UserSearchService userSearchService, UserSearchServiceFilterUsersSortingBridge userSearchServiceFilterUsersSortingBridge) {
        this.userSearchService = userSearchService;
        this.userSearchServiceFilterUsersSortingBridge = userSearchServiceFilterUsersSortingBridge;
    }

    public Stream<ApplicationUser> search(String query, UserSearchParams userSearchParams) {
        Assertions.stateTrue((String)"max results must not be null and >= 0", (userSearchParams.getMaxResults() != null && userSearchParams.getMaxResults() >= 0 ? 1 : 0) != 0);
        return this.userSearchService.findUsers(query, userSearchParams).stream();
    }

    public Stream<ApplicationUser> searchUnlimited(String query, UserSearchParams userSearchParams) {
        List users;
        Assertions.stateTrue((String)"max results must be null or < 0", (userSearchParams.getMaxResults() == null || userSearchParams.getMaxResults() < 0 ? 1 : 0) != 0);
        int queryLimit = (Integer)Option.option((Object)userSearchParams.getMaxResults()).filter(max -> max >= 0).getOrElse((Object)0);
        while ((users = this.userSearchService.findUsers(query, UserSearchParams.builder((UserSearchParams)userSearchParams).maxResults(Integer.valueOf(queryLimit += 1000)).build())).size() >= queryLimit) {
        }
        return users.stream();
    }

    public Option<ApplicationUser> searchFirstUser(String query, UserSearchParams userSearchParams) {
        return Iterables.first((Iterable)this.userSearchService.findUsers(query, UserSearchParams.builder((UserSearchParams)userSearchParams).maxResults(Integer.valueOf(1)).build()));
    }

    public Stream<ApplicationUser> filterUsers(List<ApplicationUser> applicationUsers, String query, UserSearchParams userSearchParams, boolean performSorting) {
        return this.userSearchServiceFilterUsersSortingBridge.filterUsers(applicationUsers, query, userSearchParams, performSorting);
    }
}

