/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.invite.validation;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteUser;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteValidationStatus;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class CustomerInviteValidation
implements Comparable<CustomerInviteValidation> {
    private final CustomerInviteUser customerInviteUser;
    private final CustomerInviteValidationStatus customerInviteValidationStatus;
    private final Option<String> newUserErrorMessage;

    public CustomerInviteValidation(CustomerInviteUser customerInviteUser, CustomerInviteValidationStatus customerInviteValidationStatus, Option<String> newUserErrorMessage) {
        this.customerInviteUser = (CustomerInviteUser)Assertions.notNull((String)"customerInviteUser", (Object)customerInviteUser);
        this.customerInviteValidationStatus = (CustomerInviteValidationStatus)((Object)Assertions.notNull((String)"customerInviteValidationStatus", (Object)((Object)customerInviteValidationStatus)));
        this.newUserErrorMessage = newUserErrorMessage;
    }

    public CustomerInviteUser getCustomerInviteUser() {
        return this.customerInviteUser;
    }

    public CustomerInviteValidationStatus getCustomerInviteValidationStatus() {
        return this.customerInviteValidationStatus;
    }

    public Option<String> getNewUserErrorMessage() {
        return this.newUserErrorMessage;
    }

    public static String extractKey(CustomerInviteValidation customerInviteValidation) {
        return (String)Option.option((Object)customerInviteValidation.getCustomerInviteUser().getApplicationUser()).map(ApplicationUser::getKey).getOrElse((Object)customerInviteValidation.getCustomerInviteUser().getEmailAddress());
    }

    public static String extractUsernameOrEmailAddress(CustomerInviteValidation customerInviteValidation) {
        return (String)Option.option((Object)customerInviteValidation.getCustomerInviteUser().getApplicationUser()).map(ApplicationUser::getUsername).getOrElse((Object)customerInviteValidation.getCustomerInviteUser().getEmailAddress());
    }

    public static String extractDisplayValue(CustomerInviteValidation customerInviteValidation) {
        return (String)Option.option((Object)customerInviteValidation.getCustomerInviteUser().getApplicationUser()).map(ApplicationUser::getDisplayName).getOrElse((Object)customerInviteValidation.getCustomerInviteUser().getEmailAddress());
    }

    @Override
    public int compareTo(CustomerInviteValidation o) {
        int initialCompare = Boolean.compare(this.getCustomerInviteValidationStatus().isValid(), o.getCustomerInviteValidationStatus().isValid());
        if (initialCompare == 0) {
            initialCompare = this.getCustomerInviteUser().compareTo(o.getCustomerInviteUser());
        }
        if (initialCompare == 0) {
            initialCompare = ((String)this.getNewUserErrorMessage().getOrElse((Object)"")).compareTo((String)o.getNewUserErrorMessage().getOrElse((Object)""));
        }
        return initialCompare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomerInviteValidation)) {
            return false;
        }
        CustomerInviteValidation that = (CustomerInviteValidation)o;
        return Objects.equals(this.customerInviteUser, that.customerInviteUser) && this.customerInviteValidationStatus == that.customerInviteValidationStatus && Objects.equals(this.newUserErrorMessage, that.newUserErrorMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customerInviteUser, this.customerInviteValidationStatus, this.newUserErrorMessage});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("customerInviteUser", (Object)this.customerInviteUser).add("customerInviteValidationStatus", (Object)this.customerInviteValidationStatus).add("newUserErrorMessage", this.newUserErrorMessage).toString();
    }
}

