/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.invite.validation;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CustomerInviteUser
implements Comparable<CustomerInviteUser> {
    private final String emailAddress;
    private final Option<CheckedUser> checkedUser;

    public CustomerInviteUser(String emailAddress) {
        this.emailAddress = Assertions.notBlank((String)"emailAddress", (String)emailAddress);
        this.checkedUser = Option.none();
    }

    public CustomerInviteUser(CheckedUser checkedUser) {
        this.checkedUser = Option.some((Object)checkedUser);
        this.emailAddress = checkedUser.getEmailAddress();
    }

    @Nullable
    public ApplicationUser getApplicationUser() {
        return (ApplicationUser)this.checkedUser.map(CheckedUser::forJIRA).getOrNull();
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public int compareTo(CustomerInviteUser o) {
        int initialCompare = this.getEmailAddress().compareTo(o.getEmailAddress());
        if (initialCompare == 0) {
            initialCompare = ((String)Option.option((Object)this.getApplicationUser()).map(ApplicationUser::getKey).getOrElse((Object)"")).compareTo((String)Option.option((Object)o.getApplicationUser()).map(ApplicationUser::getKey).getOrElse((Object)""));
        }
        return initialCompare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomerInviteUser)) {
            return false;
        }
        CustomerInviteUser that = (CustomerInviteUser)o;
        return Objects.equals(this.emailAddress, that.emailAddress) && Objects.equals(this.checkedUser, that.checkedUser);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress, this.checkedUser);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("checkedUser", this.checkedUser).add("emailAddress", (Object)this.emailAddress).toString();
    }
}

