/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.invite;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.feature.customer.user.ServiceDeskUserManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.CustomerInviteManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.PublicAccessCustomerInviteService;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.FailedInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteCustomerResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.SuccessInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.ServiceDeskSignupValidator;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailUtil;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublicAccessCustomerInviteServiceImpl
implements PublicAccessCustomerInviteService {
    private static final Logger log = LoggerFactory.getLogger(PublicAccessCustomerInviteServiceImpl.class);
    private final ServiceDeskNotificationInternalSender userNotificationSender;
    private final CustomerInviteManager customerInviteManager;
    private final ServiceDeskSignupValidator serviceDeskSignupValidator;
    private final ServiceDeskUserManager serviceDeskUserManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerContextService customerContextService;
    private final ErrorResultHelper errorResultHelper;
    private final UserFactory userFactory;
    private final AnalyticsService analyticsService;

    @Autowired
    public PublicAccessCustomerInviteServiceImpl(CustomerInviteManager customerInviteManager, ServiceDeskNotificationInternalSender userNotificationSender, ServiceDeskSignupValidator serviceDeskSignupValidator, ServiceDeskUserManager serviceDeskUserManager, ServiceDeskPermissions serviceDeskPermissions, CustomerContextService customerContextService, ErrorResultHelper errorResultHelper, UserFactory userFactory, AnalyticsService analyticsService) {
        this.customerInviteManager = customerInviteManager;
        this.userNotificationSender = userNotificationSender;
        this.serviceDeskSignupValidator = serviceDeskSignupValidator;
        this.serviceDeskUserManager = serviceDeskUserManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.customerContextService = customerContextService;
        this.errorResultHelper = errorResultHelper;
        this.userFactory = userFactory;
        this.analyticsService = analyticsService;
    }

    @Override
    public boolean isSignupAndInviteSupported(CheckedUser checkedUser, ServiceDesk serviceDesk, Project project) {
        return this.isSignupSupportedBaseChecks(checkedUser, serviceDesk, project);
    }

    @Override
    public boolean isNewCustomerAndSignupPossible(CheckedUser checkedUser, String customerEmail, ServiceDesk serviceDesk, Project project) {
        return this.isAgent(checkedUser, project) && this.isNewCustomerAndSignupBaseChecks(checkedUser, customerEmail, serviceDesk, project);
    }

    @Override
    public boolean isNewCustomerAndSignupPossibleForParticipantsInPortalContext(CheckedUser checkedUser, String customerEmail, ServiceDesk serviceDesk, Project project) {
        return (this.isCustomer(checkedUser, project) || this.isAgent(checkedUser, project)) && this.isNewCustomerAndSignupPossibleForParticipantsInPortalContextBaseChecks(checkedUser, customerEmail, serviceDesk, project);
    }

    @Override
    public Either<AnError, CheckedUser> signupCustomerAndSendInvite(CheckedUser checkedUser, ServiceDesk serviceDesk, Project project, String email) {
        if (!this.isAgent(checkedUser, project)) {
            return Either.left((Object)this.errorResultHelper.forbidden403("sd.error.servicedesk.customer.invite.permissions", new Object[0]).build());
        }
        Either yield = Steps.begin((Either)Eithers.cond((boolean)this.isSignupAndInviteSupported(checkedUser, serviceDesk, project), (Object)this.SIGNUP_NOT_ALLOWED(), (Object)((Object)JSDSuccess.success()))).then(success -> this.customerInviteManager.validateInviteCustomersByEmail(checkedUser, serviceDesk, project, (Set<String>)ImmutableSet.of((Object)email))).then((success, inviteValidationResult) -> this.customerInviteManager.inviteCustomers((CustomerInviteManager.CustomerInviteValidationResult)inviteValidationResult)).then((success, inviteValidationResult, inviteCustomerResult) -> this.processSingleInvitationResult(serviceDesk, (InviteCustomerResult)inviteCustomerResult)).yield((success, inviteValidationResult, inviteCustomerResult, users) -> (CheckedUser)Iterables.getOnlyElement((Iterable)users));
        long projectId = project.getId();
        yield.foreach(invite -> {
            if (this.serviceDeskPermissions.canAdministerJIRA((SDUser)checkedUser)) {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AdminInviteCustomerFromReporterFieldInPortal(projectId));
            } else {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AgentInviteCustomerFromReporterFieldInPortal(projectId));
            }
        });
        yield.left().foreach(error -> {
            if (this.serviceDeskPermissions.canAdministerJIRA((SDUser)checkedUser)) {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AdminInviteCustomerFromReporterFieldInPortalError(projectId));
            } else {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AgentInviteCustomerFromReporterFieldInPortalError(projectId));
            }
        });
        return yield;
    }

    @Override
    public Either<AnError, InviteCustomerResult> signupCustomersAndSendInvitesForParticipantsInPortalContext(CheckedUser checkedUser, ServiceDesk serviceDesk, Project project, Set<String> emails) {
        if (!this.isCustomer(checkedUser, project)) {
            return Either.left((Object)this.errorResultHelper.forbidden403("sd.error.servicedesk.customer.signup.participant.permissions", new Object[0]).build());
        }
        Either yield = Steps.begin((Either)Eithers.cond((boolean)this.isSignupAndInviteSupported(checkedUser, serviceDesk, project), (Object)this.SIGNUP_NOT_ALLOWED(), (Object)((Object)JSDSuccess.success()))).then(success -> this.customerInviteManager.validateInviteCustomersByEmail(checkedUser, serviceDesk, project, emails)).then((success, inviteValidationResult) -> this.customerInviteManager.inviteCustomers((CustomerInviteManager.CustomerInviteValidationResult)inviteValidationResult)).yield((js1, inviteValidationResult, inviteCustomerResult) -> inviteCustomerResult);
        long projectId = project.getId();
        yield.foreach(result -> {
            int success = result.getSuccessInvites().size();
            int failed = result.getFailedInvites().size();
            AbstractAnalyticsEvent analyticsEvent = this.serviceDeskPermissions.canAdministerJIRA((SDUser)checkedUser) ? (failed <= 0 ? new AdminInviteCustomerFromParticipantsFieldInPortal(projectId, success) : new AdminInviteCustomerFromParticipantsFieldInPortalFailures(projectId, success, failed)) : (this.isAgent(checkedUser, project) ? (failed <= 0 ? new AgentInviteCustomerFromParticipantsFieldInPortal(projectId, success) : new AgentInviteCustomerFromParticipantsFieldInPortalFailures(projectId, success, failed)) : (failed <= 0 ? new CustomerInviteCustomerFromParticipantsFieldInPortal(projectId, success) : new CustomerInviteCustomerFromParticipantsFieldInPortalFailures(projectId, success, failed)));
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)analyticsEvent);
        });
        yield.left().foreach(error -> {
            AbstractAnalyticsEvent analyticsEvent = this.serviceDeskPermissions.canAdministerJIRA((SDUser)checkedUser) ? new AdminInviteCustomerFromParticipantsFieldInPortalError(projectId) : (this.isAgent(checkedUser, project) ? new AgentInviteCustomerFromParticipantsFieldInPortalError(projectId) : new CustomerInviteCustomerFromParticipantsFieldInPortalError(projectId));
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)analyticsEvent);
        });
        return yield;
    }

    private boolean isAdminOfServiceDesk(CheckedUser checkedUser, Project project) {
        return this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)checkedUser, project);
    }

    private boolean isAgent(CheckedUser checkedUser, Project project) {
        return (Boolean)this.customerContextService.runOutOfCustomerContext(() -> this.serviceDeskPermissions.canViewAgentView((SDUser)checkedUser, project));
    }

    private boolean isCustomer(CheckedUser checkedUser, Project project) {
        return ServiceDeskComponentAccessor.getCustomerServiceValidator().isCustomerForProject(checkedUser, project);
    }

    private boolean isNewCustomerAndSignupBaseChecks(CheckedUser checkedUser, String customerEmail, ServiceDesk serviceDesk, Project project) {
        return this.isNewCustomerSignupCommonBaseChecks(checkedUser, customerEmail, project) && this.isSignupAndInviteSupported(checkedUser, serviceDesk, project);
    }

    private boolean isNewCustomerAndSignupPossibleForParticipantsInPortalContextBaseChecks(CheckedUser checkedUser, String customerEmail, ServiceDesk serviceDesk, Project project) {
        return this.isNewCustomerSignupCommonBaseChecks(checkedUser, customerEmail, project) && this.isSignupAndInviteSupported(checkedUser, serviceDesk, project);
    }

    private boolean isNewCustomerSignupCommonBaseChecks(CheckedUser checkedUser, String customerEmail, Project project) {
        if (StringUtils.isNotBlank((String)customerEmail)) {
            boolean emailAddressValidForNewSignup = EmailUtil.isEmailAddressValidForNewSignup(customerEmail);
            if (this.isAgent(checkedUser, project)) {
                List<CheckedUser> usersForEmail = this.serviceDeskUserManager.findAllUsersForEmail(customerEmail);
                if (usersForEmail.isEmpty()) {
                    return emailAddressValidForNewSignup;
                }
                return usersForEmail.stream().noneMatch(user -> this.isCustomer((CheckedUser)user, project));
            }
            return emailAddressValidForNewSignup && this.serviceDeskUserManager.isEmailValidForNewCustomer(customerEmail);
        }
        return false;
    }

    private boolean isSignupSupportedBaseChecks(CheckedUser checkedUser, ServiceDesk serviceDesk, Project project) {
        if (!this.userNotificationSender.isOutgoingMailConfigured() && !this.isAdminOfServiceDesk(checkedUser, project)) {
            return false;
        }
        if (this.isAgent(checkedUser, project) && this.serviceDeskSignupValidator.isSignUpThroughInviteSupported(project)) {
            return true;
        }
        return this.serviceDeskSignupValidator.isSignUpSupportedFromPortal(serviceDesk, project);
    }

    private Either<AnError, Iterable<CheckedUser>> processSingleInvitationResult(ServiceDesk serviceDesk, InviteCustomerResult result) {
        if (!result.hasFailedInvite()) {
            List collect = result.getSuccessInvites().stream().map(SuccessInviteResult::getKey).map(arg_0 -> ((UserFactory)this.userFactory).wrapUserKey(arg_0)).map(StepsConverters::newerEither).collect(Collectors.toList());
            return Eithers.sequenceRight(collect);
        }
        List<FailedInviteResult> failedInvites = result.getFailedInvites();
        failedInvites.forEach(failed -> log.debug("Customer Invite to Service Desk '{}' failed for '{}', due to : {}", new Object[]{serviceDesk.getProjectName(), failed.getEmailAddressOrUsername(), failed.getMessage()}));
        String singleReason = ((FailedInviteResult)Iterables.getOnlyElement(failedInvites)).getMessage();
        return Either.left((Object)new AnError(ErrorMessage.builder().message(singleReason).build(), HttpStatusCode.BAD_REQUEST));
    }

    private AnError SIGNUP_NOT_ALLOWED() {
        return this.errorResultHelper.forbidden403("sd.error.servicedesk.agent.customer.signup.invalid", new Object[0]).build();
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.customer.error")
    static class CustomerInviteCustomerFromParticipantsFieldInPortalError
    extends AbstractAnalyticsEvent {
        CustomerInviteCustomerFromParticipantsFieldInPortalError(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.agent.error")
    static class AgentInviteCustomerFromParticipantsFieldInPortalError
    extends AbstractAnalyticsEvent {
        AgentInviteCustomerFromParticipantsFieldInPortalError(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.admin.error")
    static class AdminInviteCustomerFromParticipantsFieldInPortalError
    extends AbstractAnalyticsEvent {
        AdminInviteCustomerFromParticipantsFieldInPortalError(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.customer.failures")
    static class CustomerInviteCustomerFromParticipantsFieldInPortalFailures
    extends AbstractAnalyticsEvent {
        private final Integer success;
        private final Integer failed;

        CustomerInviteCustomerFromParticipantsFieldInPortalFailures(@Nonnull Long projectId, @Nonnull Integer success, @Nonnull Integer failed) {
            super(projectId);
            this.success = success;
            this.failed = failed;
        }

        public Integer getFailed() {
            return this.failed;
        }

        public Integer getSuccess() {
            return this.success;
        }
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.agent.failures")
    static class AgentInviteCustomerFromParticipantsFieldInPortalFailures
    extends AbstractAnalyticsEvent {
        private final Integer success;
        private final Integer failed;

        AgentInviteCustomerFromParticipantsFieldInPortalFailures(@Nonnull Long projectId, @Nonnull Integer success, @Nonnull Integer failed) {
            super(projectId);
            this.success = success;
            this.failed = failed;
        }

        public Integer getFailed() {
            return this.failed;
        }

        public Integer getSuccess() {
            return this.success;
        }
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.admin.failures")
    static class AdminInviteCustomerFromParticipantsFieldInPortalFailures
    extends AbstractAnalyticsEvent {
        private final Integer success;
        private final Integer failed;

        AdminInviteCustomerFromParticipantsFieldInPortalFailures(@Nonnull Long projectId, @Nonnull Integer success, @Nonnull Integer failed) {
            super(projectId);
            this.success = success;
            this.failed = failed;
        }

        public Integer getFailed() {
            return this.failed;
        }

        public Integer getSuccess() {
            return this.success;
        }
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.customer")
    static class CustomerInviteCustomerFromParticipantsFieldInPortal
    extends AbstractAnalyticsEvent {
        private final Integer success;

        CustomerInviteCustomerFromParticipantsFieldInPortal(@Nonnull Long projectId, @Nonnull Integer success) {
            super(projectId);
            this.success = success;
        }

        public Integer getSuccess() {
            return this.success;
        }
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.agent")
    static class AgentInviteCustomerFromParticipantsFieldInPortal
    extends AbstractAnalyticsEvent {
        private final Integer success;

        AgentInviteCustomerFromParticipantsFieldInPortal(@Nonnull Long projectId, @Nonnull Integer success) {
            super(projectId);
            this.success = success;
        }

        public Integer getSuccess() {
            return this.success;
        }
    }

    @EventName(value="servicedesk.customer.invite.participants.portal.admin")
    static class AdminInviteCustomerFromParticipantsFieldInPortal
    extends AbstractAnalyticsEvent {
        private final Integer success;

        AdminInviteCustomerFromParticipantsFieldInPortal(@Nonnull Long projectId, @Nonnull Integer success) {
            super(projectId);
            this.success = success;
        }

        public Integer getSuccess() {
            return this.success;
        }
    }

    @EventName(value="servicedesk.customer.invite.reporter.portal.agent.error")
    static class AgentInviteCustomerFromReporterFieldInPortalError
    extends AbstractAnalyticsEvent {
        AgentInviteCustomerFromReporterFieldInPortalError(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.customer.invite.reporter.portal.admin.error")
    static class AdminInviteCustomerFromReporterFieldInPortalError
    extends AbstractAnalyticsEvent {
        AdminInviteCustomerFromReporterFieldInPortalError(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.customer.invite.reporter.portal.agent")
    static class AgentInviteCustomerFromReporterFieldInPortal
    extends AbstractAnalyticsEvent {
        AgentInviteCustomerFromReporterFieldInPortal(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.customer.invite.reporter.portal.admin")
    static class AdminInviteCustomerFromReporterFieldInPortal
    extends AbstractAnalyticsEvent {
        AdminInviteCustomerFromReporterFieldInPortal(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    static class AbstractAnalyticsEvent
    extends AnalyticsEvent {
        private final Long projectId;

        AbstractAnalyticsEvent(@Nonnull Long projectId) {
            this.projectId = projectId;
        }

        public Long getProjectId() {
            return this.projectId;
        }
    }
}

