/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.invite;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteCustomerResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteValidation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedSet;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public interface CustomerInviteManager {
    public Either<AnError, CustomerInviteValidationResult> validateInviteCustomersByEmailOrUsername(CheckedUser var1, ServiceDesk var2, Project var3, Set<String> var4);

    public Either<AnError, CustomerInviteValidationResult> validateInviteCustomersByEmail(CheckedUser var1, ServiceDesk var2, Project var3, Set<String> var4);

    public Either<AnError, InviteCustomerResult> inviteCustomers(CustomerInviteValidationResult var1);

    public Either<AnError, InviteCustomerResult> inviteCustomersToOrganisationByName(CustomerInviteValidationResult var1, String var2);

    public Either<AnError, InviteCustomerResult> inviteCustomersToOrganisation(CustomerInviteValidationResult var1, CustomerOrganization var2);

    @ParametersAreNonnullByDefault
    public static final class CustomerInviteValidationResult {
        private final Collection<CustomerInviteValidation> customerInviteValidations;
        private final CheckedUser checkedUser;
        private final ServiceDesk serviceDesk;
        private final Project project;

        @VisibleForTesting
        public CustomerInviteValidationResult(CheckedUser checkedUser, ServiceDesk serviceDesk, Project project, Collection<CustomerInviteValidation> customerInviteValidations) {
            this.checkedUser = checkedUser;
            this.customerInviteValidations = ImmutableSortedSet.copyOf(customerInviteValidations);
            this.serviceDesk = serviceDesk;
            this.project = project;
        }

        public CheckedUser getCheckedUser() {
            return this.checkedUser;
        }

        public Project getProject() {
            return this.project;
        }

        public ServiceDesk getServiceDesk() {
            return this.serviceDesk;
        }

        public Collection<CustomerInviteValidation> getCustomerInviteValidations() {
            return this.customerInviteValidations;
        }
    }
}

