/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.I18nHelper;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserLanguageHelper {
    private final I18nHelper i18nHelper;
    private final ApplicationProperties applicationProperties;
    private final LocaleManager localeManager;

    @Autowired
    public UserLanguageHelper(I18nHelper i18nHelper, ApplicationProperties applicationProperties, LocaleManager localeManager) {
        this.i18nHelper = i18nHelper;
        this.applicationProperties = applicationProperties;
        this.localeManager = localeManager;
    }

    public Set<Locale> getInstalledLocales() {
        return this.localeManager.getInstalledLocales();
    }

    public String getLocaleDisplayName(@Nonnull Locale locale, @Nonnull Locale defaultLocale) {
        String displayName = locale.getDisplayName(locale);
        if (Objects.equals(locale, defaultLocale)) {
            displayName = String.format("%s [%s]", displayName, this.i18nHelper.getText("sd.common.words.default"));
        }
        return displayName;
    }
}

