/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherActiveState;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherUsernames;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.feature.customer.CustomerManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskJiraRoleManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskProjectRole;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerManagerImpl
implements CustomerManager {
    private final ServiceDeskJiraRoleManager sdRoleManager;
    private final InternalServiceDeskProjectManager projectManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final UserSearchManager userSearchManager;
    private final UserFactory userFactory;

    @Autowired
    public CustomerManagerImpl(ServiceDeskJiraRoleManager sdRoleManager, InternalServiceDeskProjectManager projectManager, UserSearchManagerHelper userSearchManagerHelper, UserSearchManager userSearchManager, UserFactory userFactory) {
        this.sdRoleManager = sdRoleManager;
        this.projectManager = projectManager;
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.userSearchManager = userSearchManager;
        this.userFactory = userFactory;
    }

    @Override
    public Either<AnError, Boolean> addCustomerToProject(ApplicationUser user, Project project, CheckedUser customer) {
        if (!this.sdRoleManager.isUserInRole(customer, project, ServiceDeskProjectRole.CUSTOMER)) {
            Either<AnError, CheckedUser> userInRoleEither = this.sdRoleManager.addUserToRoleThroughInvite(customer, project, ServiceDeskProjectRole.CUSTOMER);
            return userInRoleEither.map(addedUser -> true);
        }
        return Either.right((Object)false);
    }

    @Override
    public Either<AnError, Boolean> addCustomerToServiceDesk(ApplicationUser user, ServiceDesk serviceDesk, CheckedUser customer) {
        return Steps.begin((Either)this.projectManager.getProject(Long.valueOf(serviceDesk.getProjectId()))).then(project -> this.addCustomerToProject(user, (Project)project, customer)).yield((project, customerResult) -> customerResult);
    }

    @Override
    public Either<ValidationErrors, CheckedUser> validateExistingCustomerByEmailOrUsername(ApplicationUser user, String emailOrUsername) {
        UserSearchParams params = this.userSearchManagerHelper.buildEmailMatcherUserSearchParams(emailOrUsername, UserEmailMatcherActiveState.INCLUDE_INACTIVE_USERS, UserEmailMatcherUsernames.MATCH_USERNAMES);
        Option userOption = this.userSearchManager.searchFirstUser(emailOrUsername, params);
        Either userEither = userOption.toRight(() -> ValidationErrors.newBuilder().addFieldError(emailOrUsername, ErrorMessage.builder().message("User not found with provided username or email address").build()).build());
        return userEither.map(customer -> (CheckedUser)this.userFactory.wrap(customer).right().get());
    }
}

