/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.transitions;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.api.request.transition.CustomerTransition;
import com.atlassian.servicedesk.internal.feature.customer.transitions.CustomerTransitionInternalService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerTransitionWebItemProvider
implements WebItemProvider {
    private static final int WEIGHT = 20;
    private static final String TRANSITION_ICON_SVG = "transition-icon.svg";
    private final FeatureManager featureManager;
    private final CustomerTransitionInternalService customerTransitionInternalService;
    private final WebResourceUrlProvider webResourceUrlProvider;

    @Autowired
    public CustomerTransitionWebItemProvider(FeatureManager featureManager, CustomerTransitionInternalService customerTransitionInternalService, WebResourceUrlProvider webResourceUrlProvider) {
        this.featureManager = featureManager;
        this.customerTransitionInternalService = customerTransitionInternalService;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        List<Object> items = new ArrayList<WebItem>();
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_PORTAL_TRANSITIONS)) {
            return items;
        }
        if (context == null) {
            return items;
        }
        ApplicationUser user = (ApplicationUser)context.get("user");
        if (user == null) {
            return items;
        }
        Issue issue = (Issue)context.get("issue");
        if (issue == null) {
            return items;
        }
        List<CustomerTransition> availableCustomerTransitions = this.customerTransitionInternalService.getAvailableCustomerTransitions(user, issue);
        items = availableCustomerTransitions.stream().map(this::createTransitionItem).collect(Collectors.toList());
        return items;
    }

    private WebItem createTransitionItem(CustomerTransition transition) {
        WebFragmentBuilder webFragmentBuilder = new WebFragmentBuilder(this.getTransitionModuleKey(transition), 20);
        webFragmentBuilder.label(transition.getTransitionName()).addParam("transitionId", String.valueOf(transition.getTransitionId())).addParam("submitName", transition.getTransitionSubmitName()).styleClass("js-trigger-customer-transition");
        webFragmentBuilder.addParam("iconUrl", this.getStaticPluginResourceUrl());
        return webFragmentBuilder.webItem("").url("#").build();
    }

    private String getTransitionModuleKey(CustomerTransition transition) {
        return "com.atlassian.servicedesk:workflow-transition-" + transition.getTransitionId();
    }

    private String getImgModuleKey() {
        return "com.atlassian.servicedesk:img";
    }

    private String getStaticPluginResourceUrl() {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(this.getImgModuleKey(), TRANSITION_ICON_SVG, UrlMode.RELATIVE);
    }
}

