/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.transitions;

import com.atlassian.servicedesk.api.request.transition.CustomerTransitionQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import javax.annotation.Nonnull;

public class CustomerTransitionQueryImpl
implements CustomerTransitionQuery {
    private Long issue;
    private LimitedPagedRequest pagedRequest;

    private CustomerTransitionQueryImpl(Long issue, LimitedPagedRequest pagedRequest) {
        this.issue = issue;
        this.pagedRequest = pagedRequest;
    }

    public Long issue() {
        return this.issue;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    public static CustomerTransitionQuery.Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements CustomerTransitionQuery.Builder {
        private Long issue;
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)100);

        private Builder() {
        }

        public Builder issue(@Nonnull Long issue) {
            this.issue = issue;
            return this;
        }

        public Builder pagedRequest(@Nonnull PagedRequest pagedRequest) {
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)100);
            return this;
        }

        public CustomerTransitionQuery build() {
            return new CustomerTransitionQueryImpl(this.issue, this.pagedRequest);
        }
    }
}

