/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.transitions;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.WorkflowIssueOperationImpl;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.TransitionOptions;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.request.transition.CustomerTransition;
import com.atlassian.servicedesk.api.request.transition.CustomerTransitionExecutionParameters;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.api.util.WorkflowHelper;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentManager;
import com.atlassian.servicedesk.internal.feature.customer.transitions.CustomerTransitionExecutionParametersImpl;
import com.atlassian.servicedesk.internal.feature.customer.transitions.CustomerTransitionImpl;
import com.atlassian.servicedesk.internal.feature.customer.transitions.CustomerTransitionInternalService;
import com.atlassian.servicedesk.internal.feature.customer.transitions.error.CustomerTransitionError;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerTransitionInternalServiceImpl
implements CustomerTransitionInternalService {
    private final IssueService issueService;
    private final CustomerTransitionError customerTransitionError;
    private final IssueWorkflowManager issueWorkflowManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final UserFactory userFactory;
    private final InternalSDCommentManager internalSDCommentManager;
    private final FieldManager fieldManager;
    private final ResolutionManager resolutionManager;
    private final WorkflowManager workflowManager;
    private final I18nHelper i18nHelper;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final WorkflowHelper workflowHelper;

    @Autowired
    public CustomerTransitionInternalServiceImpl(IssueService issueService, CustomerTransitionError customerTransitionError, IssueWorkflowManager issueWorkflowManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, UserFactory userFactory, InternalSDCommentManager internalSDCommentManager, I18nHelper i18nHelper, FieldManager fieldManager, ResolutionManager resolutionManager, WorkflowManager workflowManager, FieldScreenRendererFactory fieldScreenRendererFactory, WorkflowHelper workflowHelper) {
        this.issueService = issueService;
        this.customerTransitionError = customerTransitionError;
        this.issueWorkflowManager = issueWorkflowManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.userFactory = userFactory;
        this.internalSDCommentManager = internalSDCommentManager;
        this.i18nHelper = i18nHelper;
        this.fieldManager = fieldManager;
        this.resolutionManager = resolutionManager;
        this.workflowManager = workflowManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.workflowHelper = workflowHelper;
    }

    @Override
    public CustomerTransitionExecutionParameters.Builder customerTransitionExecutionParameterBuilder() {
        return new CustomerTransitionExecutionParametersImpl.Builder();
    }

    @Override
    public List<CustomerTransition> getAvailableCustomerTransitions(ApplicationUser user, Issue issue) {
        if (!this.canViewIssueInPortal(user, issue)) {
            return Collections.emptyList();
        }
        return this.getAvailableCustomerTransitionActions(user, issue).stream().map(this::toCustomerTransition).collect(Collectors.toList());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, Issue>> executeCustomerTransition(ApplicationUser user, CustomerTransitionExecutionParameters params) {
        Issue issue = params.request().getIssue();
        int transitionId = params.transitionId();
        io.atlassian.fugue.Option<String> comment = this.getComment(params);
        return Steps.begin(this.fetchCustomerTransition(user, issue, transitionId)).then(transition -> this.executeTransition(user, issue, (CustomerTransition)transition, comment)).yield((transition, res) -> res);
    }

    private List<ActionDescriptor> getAvailableCustomerTransitionActions(ApplicationUser user, Issue issue) {
        List<ActionDescriptor> sortedAvailableActions = this.getAllAvailableActionsForIssue(user, issue);
        return sortedAvailableActions.stream().filter(this::isCustomerTransitionEnabled).collect(Collectors.toList());
    }

    private boolean isCustomerTransitionEnabled(ActionDescriptor actionDescriptor) {
        return Boolean.valueOf((String)actionDescriptor.getMetaAttributes().get("servicedesk.customer.transition.active"));
    }

    private CustomerTransition toCustomerTransition(ActionDescriptor actionDescriptor) {
        Map metaAttributes = actionDescriptor.getMetaAttributes();
        int transitionId = actionDescriptor.getId();
        String originalName = actionDescriptor.getName();
        io.atlassian.fugue.Option<String> overrideName = this.findWorkflowCustomerTransitionName(metaAttributes);
        io.atlassian.fugue.Option<String> overrideSubmitName = this.findWorkflowCustomerTransitionSubmit(metaAttributes);
        String resolutionId = metaAttributes.getOrDefault("servicedesk.customer.transition.resolution", "").trim();
        io.atlassian.fugue.Option resolutionIdOpt = resolutionId.isEmpty() ? io.atlassian.fugue.Option.none() : io.atlassian.fugue.Option.some((Object)resolutionId);
        return new CustomerTransitionImpl(transitionId, (Option<String>)StepsConverters.olderOption((io.atlassian.fugue.Option)resolutionIdOpt), originalName, (Option<String>)StepsConverters.olderOption(overrideName), (Option<String>)StepsConverters.olderOption(overrideSubmitName));
    }

    private io.atlassian.fugue.Option<String> findWorkflowCustomerTransitionName(Map<String, String> metaAttributes) {
        return this.findTextFromMetadata(metaAttributes, "servicedesk.customer.transition.i18n.name", true).orElse(this.findTextFromMetadata(metaAttributes, "servicedesk.customer.transition.name", false)).orElse(this.findTextFromMetadata(metaAttributes, "jira.i18n.title", true));
    }

    private io.atlassian.fugue.Option<String> findWorkflowCustomerTransitionSubmit(Map<String, String> metaAttributes) {
        return this.findTextFromMetadata(metaAttributes, "servicedesk.customer.transition.i18n.submit", true).orElse(this.findTextFromMetadata(metaAttributes, "servicedesk.customer.transition.submit", false)).orElse(this.findTextFromMetadata(metaAttributes, "jira.i18n.submit", true));
    }

    private io.atlassian.fugue.Option<String> findTextFromMetadata(Map<String, String> metaAttributes, String key, boolean isI18nKey) {
        if (!metaAttributes.containsKey(key)) {
            return io.atlassian.fugue.Option.none();
        }
        if (isI18nKey) {
            String i18nkey = metaAttributes.get(key);
            String value = this.i18nHelper.getText(i18nkey);
            if (StringUtils.isNotBlank((String)value) && !value.trim().equals(i18nkey.trim())) {
                return io.atlassian.fugue.Option.some((Object)value.trim());
            }
        } else {
            String value = metaAttributes.get(key);
            if (StringUtils.isNotBlank((String)value)) {
                return io.atlassian.fugue.Option.some((Object)value.trim());
            }
        }
        return io.atlassian.fugue.Option.none();
    }

    private List<ActionDescriptor> getAllAvailableActionsForIssue(ApplicationUser user, Issue issue) {
        TransitionOptions transitionOptions = new TransitionOptions.Builder().skipValidators().build();
        return this.issueWorkflowManager.getSortedAvailableActions(issue, transitionOptions, user);
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, CustomerTransition> fetchCustomerTransition(ApplicationUser user, Issue issue, int transitionId) {
        return this.getAvailableCustomerTransitions(user, issue).stream().filter(a -> a.getTransitionId() == transitionId).findFirst().map(io.atlassian.fugue.Either::right).orElse(io.atlassian.fugue.Either.left((Object)this.customerTransitionError.CUSTOMER_TRANSITION_UNAVAILABLE()));
    }

    private io.atlassian.fugue.Option<String> getComment(CustomerTransitionExecutionParameters params) {
        String comment = params.comment();
        if (StringUtils.isNotBlank((String)comment)) {
            return io.atlassian.fugue.Option.some((Object)comment);
        }
        return io.atlassian.fugue.Option.none();
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, IssueInputParameters> getIssueInputParameters(ApplicationUser user, Issue issue, io.atlassian.fugue.Option<String> comment) {
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters();
        issueInputParameters.setSkipScreenCheck(true);
        if (!comment.isDefined()) {
            return io.atlassian.fugue.Either.right((Object)issueInputParameters);
        }
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.serviceDeskLicenseAndPermissionService.canCreateComment((SDUser)checkedUser, issue) ? io.atlassian.fugue.Either.right((Object)issueInputParameters) : io.atlassian.fugue.Either.left((Object)this.customerTransitionError.NO_COMMENT_PERMISSION())).yield((checkedUser, issueInputParameters1) -> issueInputParameters);
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, Issue>> executeTransition(ApplicationUser user, Issue issue, CustomerTransition customerTransition, io.atlassian.fugue.Option<String> comment) {
        io.atlassian.fugue.Either<AnError, IssueInputParameters> issueInputParameters = this.getIssueInputParameters(user, issue, comment);
        if (issueInputParameters.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)issueInputParameters.left().get());
        }
        IssueService.TransitionValidationResult transitionValidationResult = this.validateTransition(user, issue, customerTransition, (IssueInputParameters)issueInputParameters.right().get(), comment);
        if (!transitionValidationResult.isValid()) {
            return io.atlassian.fugue.Either.right((Object)io.atlassian.fugue.Either.left((Object)ValidationErrors.newBuilder((ErrorCollection)transitionValidationResult.getErrorCollection()).httpStatusCode(HttpStatusCode.BAD_REQUEST).reasonKey("transition failed validation").build()));
        }
        return this.transition(user, transitionValidationResult).map(issueResult -> io.atlassian.fugue.Either.right((Object)issueResult));
    }

    @VisibleForTesting
    IssueService.TransitionValidationResult validateTransition(ApplicationUser user, Issue issue, CustomerTransition customerTransition, IssueInputParameters issueInputParameters, io.atlassian.fugue.Option<String> comment) {
        io.atlassian.fugue.Option resolutionId;
        int transitionId = customerTransition.getTransitionId();
        TransitionOptions options = new TransitionOptions.Builder().skipValidators().build();
        IssueService.TransitionValidationResult transitionValidationResult = this.issueService.validateTransition(user, issue.getId(), transitionId, issueInputParameters, options);
        if (comment.isDefined()) {
            issueInputParameters.setComment((String)comment.get());
            this.validateAndIncludeComment(transitionValidationResult, customerTransition, issueInputParameters);
        }
        if ((resolutionId = StepsConverters.newerOption((Option)customerTransition.getResolutionId())).isDefined() && !this.workflowHelper.hasAPostFunctionWhichAffectsResolution(io.atlassian.fugue.Option.some((Object)this.workflowManager.getWorkflow(issue)), transitionId)) {
            issueInputParameters.setResolutionId((String)resolutionId.get());
            this.validateAndUpdateResolution(transitionValidationResult, customerTransition, issueInputParameters);
        }
        return transitionValidationResult;
    }

    @VisibleForTesting
    void validateAndIncludeComment(IssueService.TransitionValidationResult transitionValidationResult, CustomerTransition customerTransition, IssueInputParameters issueInputParameters) {
        Map additionalInputs = transitionValidationResult.getAdditionInputs();
        Map fieldValuesHolder = transitionValidationResult.getFieldValuesHolder();
        MutableIssue issue = transitionValidationResult.getIssue();
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)new WorkflowIssueOperationImpl(this.workflowManager.getActionDescriptor((Issue)issue, customerTransition.getTransitionId().intValue())), fieldValuesHolder);
        CommentSystemField commentSystemField = (CommentSystemField)this.fieldManager.getOrderableField("comment");
        FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.getFieldScreenRendererLayoutItemForField((Issue)issue, (OrderableField)commentSystemField);
        commentSystemField.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
        commentSystemField.validateParams((OperationContext)operationContext, transitionValidationResult.getErrorCollection(), this.i18nHelper, (Issue)issue, fieldScreenRenderLayoutItem);
        commentSystemField.populateAdditionalInputs(fieldValuesHolder, additionalInputs);
        additionalInputs.put("commentProperty", this.internalSDCommentManager.retrieveAllowPublicCommentPropertyForTransitions());
    }

    @VisibleForTesting
    void validateAndUpdateResolution(IssueService.TransitionValidationResult transitionValidationResult, CustomerTransition customerTransition, IssueInputParameters issueInputParameters) {
        MutableIssue issue = transitionValidationResult.getIssue();
        Map fieldValuesHolder = transitionValidationResult.getFieldValuesHolder();
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)new WorkflowIssueOperationImpl(this.workflowManager.getActionDescriptor((Issue)issue, customerTransition.getTransitionId().intValue())), fieldValuesHolder);
        ResolutionSystemField resolutionSystemField = (ResolutionSystemField)this.fieldManager.getOrderableField("resolution");
        FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.getFieldScreenRendererLayoutItemForField((Issue)issue, (OrderableField)resolutionSystemField);
        resolutionSystemField.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
        String resolutionId = issueInputParameters.getResolutionId();
        if (resolutionId == null) {
            return;
        }
        Resolution resolution = this.resolutionManager.getResolution(resolutionId);
        if (resolution != null) {
            resolutionSystemField.validateParams((OperationContext)operationContext, transitionValidationResult.getErrorCollection(), this.i18nHelper, (Issue)issue, fieldScreenRenderLayoutItem);
        }
        if (Objects.equals(issue.getResolution(), resolution)) {
            return;
        }
        if (resolutionId.equals(ResolutionSystemField.UNRESOLVED_VALUE.toString()) || resolution != null) {
            resolutionSystemField.updateIssue(null, issue, fieldValuesHolder);
        }
    }

    private FieldScreenRenderLayoutItem getFieldScreenRendererLayoutItemForField(Issue issue, OrderableField field) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue).getFieldScreenRenderLayoutItem(field);
    }

    io.atlassian.fugue.Either<AnError, Issue> transition(ApplicationUser user, IssueService.TransitionValidationResult validationResult) {
        IssueService.IssueResult issueResult = this.issueService.transition(user, validationResult);
        if (!issueResult.isValid()) {
            return io.atlassian.fugue.Either.left((Object)this.customerTransitionError.TRANSITION_FAILED(issueResult.getErrorCollection()));
        }
        return io.atlassian.fugue.Either.right((Object)issueResult.getIssue());
    }

    private boolean canViewIssueInPortal(ApplicationUser user, Issue issue) {
        io.atlassian.fugue.Either checkedUser = StepsConverters.newerEither((Either)this.userFactory.wrap(user));
        return !checkedUser.isLeft() && this.serviceDeskLicenseAndPermissionService.canViewRequestInPortal((SDUser)checkedUser.right().get(), issue);
    }
}

