/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.transitions;

import com.atlassian.fugue.Option;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.servicedesk.api.request.transition.CustomerTransition;
import javax.annotation.Nonnull;

public class CustomerTransitionImpl
implements CustomerTransition {
    private int transitionId;
    private Option<String> resolutionId;
    private String originalName;
    private Option<String> overrideName;
    private Option<String> overrideSubmitName;

    public CustomerTransitionImpl(int transitionId, Option<String> resolutionId, @Nonnull String originalName, Option<String> overrideName, Option<String> overrideSubmitName) {
        Assertions.notBlank((String)"Original Name should not be blank", (String)originalName);
        if (overrideName.isDefined()) {
            Assertions.notBlank((String)"Override Name should not be blank", (String)((String)overrideName.get()));
        }
        if (overrideSubmitName.isDefined()) {
            Assertions.notBlank((String)"Override Name should not be blank", (String)((String)overrideSubmitName.get()));
        }
        if (resolutionId.isDefined()) {
            Assertions.notBlank((String)"Resolution ID should not be blank", (String)((String)resolutionId.get()));
        }
        this.resolutionId = resolutionId;
        this.transitionId = transitionId;
        this.originalName = originalName;
        this.overrideName = overrideName;
        this.overrideSubmitName = overrideSubmitName;
    }

    public Integer getTransitionId() {
        return this.transitionId;
    }

    public Option<String> getResolutionId() {
        return this.resolutionId;
    }

    public String getOriginalTransitionName() {
        return this.originalName;
    }

    public Option<String> getOverrideTransitionName() {
        return this.overrideName;
    }

    public String getTransitionName() {
        return (String)this.getOverrideTransitionName().getOrElse((Object)this.getOriginalTransitionName());
    }

    public Option<String> getOverrideTransitionSubmitName() {
        return this.overrideSubmitName;
    }

    public String getTransitionSubmitName() {
        return (String)this.getOverrideTransitionSubmitName().getOrElse((Object)this.getOriginalTransitionName());
    }
}

