/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.search.user;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskManager;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.featureflag.ServiceDeskFeatureFlags;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.api.util.permission.PermissionSchemeHelper;
import com.atlassian.servicedesk.internal.feature.customer.search.permission.CustomerShareSearchCapabilityChecker;
import com.atlassian.servicedesk.internal.feature.customer.search.user.CustomerSearchManager;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class CustomerSearchManagerImpl
implements CustomerSearchManager {
    private final CustomerShareSearchCapabilityChecker shareSearchCapabilityChecker;
    private final ServiceDeskManager serviceDeskManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final UserSearchManager userSearchManager;
    private final UserFactory userFactory;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;
    private final PermissionSchemeHelper permissionSchemeHelper;
    private final UserManager userManager;
    private final ErrorResultHelper errorResultHelper;
    private final FeatureManager featureManager;

    @Autowired
    public CustomerSearchManagerImpl(CustomerShareSearchCapabilityChecker shareSearchCapabilityChecker, ServiceDeskManager serviceDeskManager, UserSearchManagerHelper userSearchManagerHelper, UserSearchManager userSearchManager, UserFactory userFactory, CustomerOrganizationMemberManager customerOrganizationMemberManager, UserManager userManager, PermissionSchemeHelper permissionSchemeHelper, ErrorResultHelper errorResultHelper, FeatureManager featureManager) {
        this.shareSearchCapabilityChecker = shareSearchCapabilityChecker;
        this.serviceDeskManager = serviceDeskManager;
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.userSearchManager = userSearchManager;
        this.userFactory = userFactory;
        this.customerOrganizationMemberManager = customerOrganizationMemberManager;
        this.userManager = userManager;
        this.permissionSchemeHelper = permissionSchemeHelper;
        this.errorResultHelper = errorResultHelper;
        this.featureManager = featureManager;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> searchForCustomers(CheckedUser searcher, Project project, ServiceDesk serviceDesk, String queryString, int limit, String fieldId, Option<String> fieldConfigId) {
        Option customerUserSearchDataOption = this.userSearchManagerHelper.buildPortalCustomerUserSearchParams(fieldId, fieldConfigId, project, serviceDesk, Option.some((Object)limit));
        return (io.atlassian.fugue.Either)customerUserSearchDataOption.fold(() -> io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.user.picker.error.fieldconfig", new Object[0]).build()), data -> this.doSearchForCustomersExcludedUsers(searcher, project, queryString, Collections.emptySet(), limit, (Option<ServiceDesk>)Option.some((Object)serviceDesk), (Option<UserSearchManagerHelper.CustomerUserSearchData>)Option.some((Object)data)));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> searchForCustomers(CheckedUser searcher, Project project, String queryString, int limit) {
        return this.searchForCustomersExcludedUsers(searcher, project, queryString, Collections.emptySet(), limit);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> searchForCustomersExcludedUsers(CheckedUser searcher, Project project, String queryString, Set<String> excludedUserKeys, int limit) {
        return this.doSearchForCustomersExcludedUsers(searcher, project, queryString, excludedUserKeys, limit, (Option<ServiceDesk>)Option.none(), (Option<UserSearchManagerHelper.CustomerUserSearchData>)Option.none());
    }

    private io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> doSearchForCustomersExcludedUsers(CheckedUser searcher, Project project, String queryString, Set<String> excludedUserKeys, int limit, Option<ServiceDesk> serviceDeskOption, Option<UserSearchManagerHelper.CustomerUserSearchData> customerUserSearchDataOption) {
        ServiceDesk serviceDesk;
        if (serviceDeskOption.isEmpty()) {
            io.atlassian.fugue.Either serviceDeskForProject = StepsConverters.newerEither((Either)this.serviceDeskManager.getServiceDeskForProject(project));
            if (serviceDeskForProject.isLeft()) {
                return io.atlassian.fugue.Either.left((Object)serviceDeskForProject.left().get());
            }
            serviceDesk = (ServiceDesk)serviceDeskForProject.right().get();
        } else {
            serviceDesk = (ServiceDesk)serviceDeskOption.get();
        }
        if (this.shareSearchCapabilityChecker.canSearchAllCustomersInProject(searcher, serviceDesk, project)) {
            return this.searchAllCustomersInServiceDesk(project, serviceDesk, queryString, excludedUserKeys, limit, customerUserSearchDataOption);
        }
        return this.searchCustomersOfSameOrganisations(searcher, project, queryString, excludedUserKeys, limit, customerUserSearchDataOption);
    }

    private io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> searchAllCustomersInServiceDesk(Project project, ServiceDesk serviceDesk, String queryString, Set<String> excludedUserKeys, int limit, Option<UserSearchManagerHelper.CustomerUserSearchData> customerUserSearchDataOption) {
        UserSearchManagerHelper.CustomerUserSearchData data = (UserSearchManagerHelper.CustomerUserSearchData)customerUserSearchDataOption.getOr(() -> this.userSearchManagerHelper.buildCustomerUserSearchParams(project, serviceDesk, Option.some((Object)limit), excludedUserKeys));
        if (data.isOpenAccess() || !this.featureManager.isEnabled(ServiceDeskFeatureFlags.USE_SEARCH_BY_PERMISSIONS)) {
            return io.atlassian.fugue.Either.right(this.streamApplicationUsersToListCheckedUsers(this.userSearchManager.search(queryString, data.getUserSearchParams())));
        }
        ImmutableList permissionUsers = ImmutableList.copyOf((Collection)this.permissionSchemeHelper.getCustomerUsersByPermissions(project));
        return io.atlassian.fugue.Either.right(this.streamApplicationUsersToListCheckedUsers(this.userSearchManager.filterUsers((List)permissionUsers, queryString, data.getUserSearchParams(), true)));
    }

    private io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> searchCustomersOfSameOrganisations(CheckedUser searcher, Project project, String queryString, Set<String> excludedUserKeys, int limit, Option<UserSearchManagerHelper.CustomerUserSearchData> customerUserSearchDataOption) {
        UserSearchParams userSearchParams = (UserSearchParams)customerUserSearchDataOption.map(UserSearchManagerHelper.CustomerUserSearchData::getUserSearchParams).getOr(() -> this.userSearchManagerHelper.buildNotExcludedActiveOnlyUserSearchParams(Option.some((Object)limit), excludedUserKeys));
        List membersOfSameOrganisations = this.customerOrganizationMemberManager.getMembersOfSameOrganizations(searcher, project, false).stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        return io.atlassian.fugue.Either.right(this.streamApplicationUsersToListCheckedUsers(this.userSearchManager.filterUsers(membersOfSameOrganisations, queryString, userSearchParams, true)));
    }

    private List<CheckedUser> streamApplicationUsersToListCheckedUsers(Stream<ApplicationUser> applicationUserStream) {
        return applicationUserStream.flatMap(user -> StreamSupport.stream(this.userFactory.wrap(user).toOption().spliterator(), false)).collect(Collectors.toList());
    }
}

