/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.search;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.search.CustomerSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.OrganizationSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.UserSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.UsersAndOrganizationsSearchService;
import com.atlassian.servicedesk.internal.feature.customer.search.organization.OrganizationSearchManager;
import com.atlassian.servicedesk.internal.feature.customer.search.user.CustomerSearchManager;
import com.atlassian.servicedesk.internal.feature.customer.search.util.SearchCollectionUtil;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.OrganizationMemberSearchManager;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationComparator;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.organization.CustomerOrganizationParticipantManager;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponse;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponseImpl;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UsersAndOrganizationsSearchServiceImpl
implements UsersAndOrganizationsSearchService {
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final OrganizationSearchManager organizationSearchManager;
    private final CustomerSearchManager customerSearchManager;
    private final CustomerOrganizationManager customerOrganizationManager;
    private final OrganizationMemberSearchManager organizationMemberSearchManager;
    private final RequestParticipantsInternalManager requestParticipantsManager;
    private final CustomerOrganizationParticipantManager organizationParticipantManager;
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;

    @Autowired
    public UsersAndOrganizationsSearchServiceImpl(ServiceDeskPermissions serviceDeskPermissions, OrganizationSearchManager organizationSearchManager, CustomerSearchManager customerSearchManager, CustomerOrganizationManager customerOrganizationManager, OrganizationMemberSearchManager organizationMemberSearchManager, RequestParticipantsInternalManager requestParticipantsManager, CustomerOrganizationParticipantManager organizationParticipantManager, FeatureManager featureManager, CommonErrors commonErrors) {
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.organizationSearchManager = organizationSearchManager;
        this.customerSearchManager = customerSearchManager;
        this.customerOrganizationManager = customerOrganizationManager;
        this.organizationMemberSearchManager = organizationMemberSearchManager;
        this.requestParticipantsManager = requestParticipantsManager;
        this.organizationParticipantManager = organizationParticipantManager;
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
    }

    @Override
    public Either<AnError, List<CustomerSearchItemResult>> searchForUsersAndOrganizations(@Nonnull CheckedUser searcher, @Nonnull Project project, @Nonnull String queryString, int limit) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewServiceDesk((SDUser)searcher, project)) {
            return Either.left((Object)this.commonErrors.PORTAL_NOT_AUTHORISED());
        }
        return this.search(searcher, project, queryString, Collections.emptySet(), Collections.emptySet(), limit);
    }

    @Override
    public Either<AnError, List<CustomerSearchItemResult>> searchForUsersAndOrganizations(@Nonnull CheckedUser searcher, @Nonnull Issue issue, @Nonnull String queryString, int limit) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewRequestInPortal((SDUser)searcher, issue)) {
            return Either.left((Object)this.commonErrors.NO_PERMISSION_TO_VIEW_REQUEST());
        }
        return Steps.begin(this.requestParticipantsManager.getValidParticipants(issue)).then(() -> this.organizationParticipantManager.getOrganizationsForIssue(issue)).then((excludedUsers, excludedOrgs) -> {
            Set<String> excludedUserKeys = excludedUsers.stream().map(CheckedUser::getKey).collect(Collectors.toSet());
            Option reporter = Option.option((Object)issue.getReporter());
            reporter.forEach(user -> excludedUserKeys.add(user.getKey()));
            return this.search(searcher, issue.getProjectObject(), queryString, excludedUserKeys, new HashSet<CustomerOrganization>((Collection<CustomerOrganization>)excludedOrgs), limit);
        }).yield((excludedUsers, excludedOrgs, result) -> result);
    }

    @Override
    public Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> searchForUsersInOrganization(@Nonnull CheckedUser searcher, @Nonnull Project project, @Nonnull CustomerOrganization organization, @Nonnull String nameOrEmailQuery, @Nonnull LimitedPagedRequest pagedRequest) {
        Objects.requireNonNull(searcher, "searcher");
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(organization, "organization");
        Objects.requireNonNull(nameOrEmailQuery, "nameOrEmailQuery");
        Objects.requireNonNull(pagedRequest, "pagedRequest");
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewAgentView((SDUser)searcher, project)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        Either<AnError, List<CheckedUser>> usersInOrganization = this.organizationMemberSearchManager.searchForUsersInOrganization(searcher, organization, nameOrEmailQuery, this.getSearchLimit(pagedRequest));
        return usersInOrganization.map(result -> this.buildPagedPageResponse(pagedRequest, this.toCustomerSearchItemResult((Collection<CheckedUser>)result)));
    }

    @Override
    public Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> searchForUsersAndOrganizationWithExcludedResult(@Nonnull CheckedUser searcher, @Nonnull Project project, @Nonnull String nameOrEmailQuery, @Nonnull Set<String> excludedUserKeys, @Nonnull LimitedPagedRequest pagedRequest) {
        Objects.requireNonNull(searcher, "searcher");
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(nameOrEmailQuery, "nameOrEmailQuery");
        Objects.requireNonNull(pagedRequest, "pagedRequest");
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewAgentView((SDUser)searcher, project)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        Either<AnError, List<CustomerSearchItemResult>> searchResult = this.search(searcher, project, nameOrEmailQuery, excludedUserKeys, Collections.emptySet(), this.getSearchLimit(pagedRequest));
        return searchResult.map(result -> this.buildPagedPageResponse(pagedRequest, (List)result));
    }

    @Override
    public Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> getAllUserAndOrganizationWithExcludedResult(@Nonnull CheckedUser searcher, @Nonnull Project project, @Nonnull Set<String> excludedUserKeys, @Nonnull LimitedPagedRequest pagedRequest) {
        Objects.requireNonNull(searcher, "searcher");
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(pagedRequest, "pagedRequest");
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewAgentView((SDUser)searcher, project)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        Either<AnError, List<CustomerSearchItemResult>> searchResult = this.getAllUsersAndOrganizations(searcher, project, excludedUserKeys, this.getSearchLimit(pagedRequest));
        return searchResult.map(result -> this.buildPagedPageResponse(pagedRequest, (List)result));
    }

    private Either<AnError, List<CustomerSearchItemResult>> search(CheckedUser searcher, Project project, String queryString, Set<String> excludedUserKeys, Set<CustomerOrganization> excludedOrganizations, int limit) {
        return Steps.begin(this.customerSearchManager.searchForCustomersExcludedUsers(searcher, project, queryString, excludedUserKeys, limit)).then(customers -> this.organizationSearchManager.searchForOrganizations(searcher, project, queryString, excludedOrganizations, limit)).yield((customers, organizations) -> this.mergeSearchResult((Collection<CustomerOrganization>)organizations, (Collection<CheckedUser>)customers, limit));
    }

    private Either<AnError, List<CustomerSearchItemResult>> getAllUsersAndOrganizations(@Nonnull CheckedUser searcher, @Nonnull Project project, @Nonnull Set<String> excludedUserKeys, int limit) {
        return Steps.begin(this.customerSearchManager.searchForCustomersExcludedUsers(searcher, project, "", excludedUserKeys, limit)).then(customers -> this.getOrganizationsAndSort(project)).yield((customers, organizations) -> this.mergeSearchResult((Collection<CustomerOrganization>)organizations, (Collection<CheckedUser>)customers, limit));
    }

    @VisibleForTesting
    List<CustomerSearchItemResult> mergeSearchResult(Collection<CustomerOrganization> organizations, Collection<CheckedUser> users, int limit) {
        ArrayList<CustomerSearchItemResult> searchItemResults = new ArrayList<CustomerSearchItemResult>(limit);
        if (organizations.size() > limit) {
            Collection<CustomerOrganization> organizationLimitResult = SearchCollectionUtil.limitReturnResult(organizations, limit);
            organizationLimitResult.forEach(organization -> searchItemResults.add(new OrganizationSearchItemResult((CustomerOrganization)organization)));
        } else {
            organizations.forEach(organization -> searchItemResults.add(new OrganizationSearchItemResult((CustomerOrganization)organization)));
            int usersLimit = limit - organizations.size();
            Collection<CheckedUser> usersResult = SearchCollectionUtil.limitReturnResult(users, usersLimit);
            usersResult.forEach(user -> searchItemResults.add(new UserSearchItemResult((CheckedUser)user)));
        }
        return searchItemResults;
    }

    private Either<AnError, List<CustomerOrganization>> getOrganizationsAndSort(Project project) {
        Either<AnError, Collection<CustomerOrganization>> organizationsForProjects = this.customerOrganizationManager.getOrganizationsForProject(project);
        return organizationsForProjects.map(orgs -> {
            ArrayList result = new ArrayList(orgs);
            Collections.sort(result, new CustomerOrganizationComparator());
            return result;
        });
    }

    private List<CustomerSearchItemResult> toCustomerSearchItemResult(Collection<CheckedUser> users) {
        return users.stream().map(UserSearchItemResult::new).collect(Collectors.toList());
    }

    private int getSearchLimit(LimitedPagedRequest pagedRequest) {
        return (int)this.maxInt((long)pagedRequest.getStart() + this.plusOne(this.getActualRequestLimit(pagedRequest)));
    }

    private int getActualRequestLimit(LimitedPagedRequest pagedRequest) {
        return Math.min(pagedRequest.getLimit(), pagedRequest.getMaxLimit());
    }

    private long plusOne(int number) {
        return (long)number + 1L;
    }

    private long maxInt(long number) {
        return Math.min(Integer.MAX_VALUE, number);
    }

    @VisibleForTesting
    <T> LazyPagedResponse<T> buildPagedPageResponse(LimitedPagedRequest pagedRequest, List<T> elems) {
        boolean hasMore;
        int actualLimit = this.getActualRequestLimit(pagedRequest);
        int total = elems.size();
        List reducedElems = elems.stream().limit((long)pagedRequest.getStart() + this.maxInt(this.plusOne(actualLimit))).skip(pagedRequest.getStart()).collect(Collectors.toList());
        boolean bl = hasMore = reducedElems.size() > actualLimit;
        if (hasMore) {
            reducedElems.remove(actualLimit);
            --total;
        }
        return LazyPagedResponseImpl.from(PagedResponseImpl.from(reducedElems, (boolean)hasMore).pageRequest(pagedRequest).build(), total);
    }
}

