/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype.status;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.status.RequestStatusMapping;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeStatusQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public RequestTypeStatusQStore(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    public Map<String, String> getStoredStatusMappings(int requestTypeId) {
        List results = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.select(new Expression[]{Tables.STATUS_MAPPING.STATUS_ID, Tables.STATUS_MAPPING.STATUS_NAME}).from((Expression)Tables.STATUS_MAPPING)).where((Predicate)Tables.STATUS_MAPPING.FORM_ID.eq((Object)requestTypeId))).orderBy(Tables.STATUS_MAPPING.STATUS_ID.asc())).fetch());
        return this.mapValues(results);
    }

    public void storeStatusMappings(int requestTypeId, List<RequestStatusMapping> mappings) {
        this.databaseAccessor.runInTransaction(conn -> {
            this.deleteMappingsForRequestType(requestTypeId, (DatabaseConnection)conn);
            return this.createMappings(requestTypeId, mappings, (DatabaseConnection)conn);
        });
    }

    private long createMappings(int requestTypeId, List<RequestStatusMapping> mappings, DatabaseConnection conn) {
        SQLInsertClause insert = conn.insert((RelationalPath)Tables.STATUS_MAPPING);
        for (RequestStatusMapping mapping : mappings) {
            insert.set(Tables.STATUS_MAPPING.FORM_ID, (Object)requestTypeId).set((Path)Tables.STATUS_MAPPING.STATUS_ID, (Object)mapping.getStatusId()).set((Path)Tables.STATUS_MAPPING.STATUS_NAME, mapping.getCustom().getOrNull()).addBatch();
        }
        long amountAdded = insert.execute();
        if (amountAdded != (long)mappings.size()) {
            throw new RuntimeException("did not add all mappings correctly");
        }
        return amountAdded;
    }

    private long deleteMappingsForRequestType(int requestTypeId, DatabaseConnection conn) {
        return conn.delete((RelationalPath)Tables.STATUS_MAPPING).where((Predicate)Tables.STATUS_MAPPING.FORM_ID.eq((Object)requestTypeId)).execute();
    }

    private HashMap<String, String> mapValues(List<Tuple> results) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Tuple tuple : results) {
            result.put((String)tuple.get((Expression)Tables.STATUS_MAPPING.STATUS_ID), (String)tuple.get((Expression)Tables.STATUS_MAPPING.STATUS_NAME));
        }
        return result;
    }
}

