/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.icon.IconType;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeSystemIcon;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon.RequestTypeIconDefinition;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeSystemIconsCreator {
    private static Logger LOG = Logger.getLogger(RequestTypeSystemIconsCreator.class);
    private final AvatarManager avatarManager;

    @Autowired
    public RequestTypeSystemIconsCreator(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    public void initialize() {
        List avatars = this.avatarManager.getAllSystemAvatars(RequestTypeIconDefinition.ICON_TYPE);
        Set avatarIconFilenames = avatars.stream().map(Avatar::getFileName).collect(Collectors.toSet());
        for (RequestTypeSystemIcon icon : RequestTypeSystemIcon.values()) {
            if (avatarIconFilenames.contains(icon.getFilename())) continue;
            this.createAvatarForRequestTypeSystemIcon(icon);
        }
    }

    private void createAvatarForRequestTypeSystemIcon(RequestTypeSystemIcon icon) {
        try {
            InternalIcon systemIconAvatar = new InternalIcon(icon.getFilename());
            Avatar created = this.avatarManager.create((Avatar)systemIconAvatar);
            LOG.info((Object)("Icon with filename " + icon.getFilename() + " did not exist. Created with ID=" + created.getIconType()));
        }
        catch (DataAccessException e) {
            LOG.error((Object)("Couldn't create avatar for RequestTypeSystemIcon " + icon.getFilename()), (Throwable)e);
        }
    }

    private class InternalIcon
    implements Avatar {
        private String filename;

        public InternalIcon(String filename) {
            this.filename = filename;
        }

        @Nonnull
        public Avatar.Type getAvatarType() {
            return Avatar.Type.OTHER;
        }

        @Nonnull
        public IconType getIconType() {
            return IconType.of((String)"SD_REQTYPE");
        }

        @Nonnull
        public String getFileName() {
            return this.filename;
        }

        @Nonnull
        public String getContentType() {
            return "image/svg+xml";
        }

        public Long getId() {
            return null;
        }

        public String getOwner() {
            return null;
        }

        public boolean isSystemAvatar() {
            return true;
        }
    }
}

