/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.plugin.icon.IconTypePolicy;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import io.atlassian.fugue.Suppliers;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeIconPolicy
implements IconTypePolicy {
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final InternalServiceDeskService serviceDeskService;
    private final ProjectManager projectManager;
    private final UserFactory userFactory;
    private final InternalPortalService internalPortalService;
    private final RequestTypeInternalService requestTypeInternalService;

    @Autowired
    public RequestTypeIconPolicy(ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, InternalServiceDeskService serviceDeskService, ProjectManager projectManager, UserFactory userFactory, InternalPortalService internalPortalService, RequestTypeInternalService requestTypeInternalService) {
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.serviceDeskService = serviceDeskService;
        this.projectManager = projectManager;
        this.userFactory = userFactory;
        this.internalPortalService = internalPortalService;
        this.requestTypeInternalService = requestTypeInternalService;
    }

    public boolean userCanView(@Nullable ApplicationUser remoteUser, @Nonnull Avatar icon) {
        return icon.isSystemAvatar() || this.isAgent(remoteUser, icon.getOwner()) || this.isCustomer(remoteUser, icon.getOwner());
    }

    public boolean userCanDelete(@Nullable ApplicationUser remoteUser, @Nonnull Avatar icon) {
        boolean canDelete;
        boolean bl = canDelete = !icon.isSystemAvatar() && this.isAdminAgent(remoteUser, icon.getOwner());
        if (canDelete) {
            io.atlassian.fugue.Either requestTypesEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(remoteUser))).then(checkedUser -> io.atlassian.fugue.Either.right((Object)this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(icon.getOwner()))))).then(this.internalPortalService::getPortalByProject).then((arg_0, arg_1, arg_2) -> ((RequestTypeInternalService)this.requestTypeInternalService).getAllValidRequestTypes(arg_0, arg_1, arg_2)).yield((checkedUser, project, portal, requestTypes) -> requestTypes);
            if (requestTypesEither.isRight()) {
                for (RequestType requestType : (List)requestTypesEither.right().get()) {
                    if (requestType.getIconId() != icon.getId().longValue()) continue;
                    canDelete = false;
                }
            } else {
                canDelete = false;
            }
        }
        return canDelete;
    }

    public boolean userCanCreateFor(@Nullable ApplicationUser remoteUser, @Nonnull IconOwningObjectId owningObjectId) {
        return this.isAdminAgent(remoteUser, owningObjectId.getId());
    }

    private ServiceDesk getServiceDesk(ApplicationUser remoteUser, String projectId) {
        CheckedUser checkedUser = (CheckedUser)this.userFactory.wrap(remoteUser).getOrNull();
        if (checkedUser == null) {
            return null;
        }
        Project project = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(projectId)));
        return (ServiceDesk)this.serviceDeskService.getServiceDeskForProject(checkedUser, project, false).getOrNull();
    }

    private boolean isCustomer(ApplicationUser remoteUser, String projectId) {
        return (Boolean)Steps.begin((io.atlassian.fugue.Option)StepsConverters.newerOption((Option)this.userFactory.wrapUnchecked(remoteUser).toOption())).then(() -> io.atlassian.fugue.Option.option((Object)this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(projectId))))).yield((arg_0, arg_1) -> ((ServiceDeskLicenseAndPermissionService)this.serviceDeskLicenseAndPermissionService).canViewProject(arg_0, arg_1)).getOr(Suppliers.alwaysFalse());
    }

    private boolean isAgent(ApplicationUser remoteUser, String projectId) {
        ServiceDesk serviceDesk = this.getServiceDesk(remoteUser, projectId);
        if (serviceDesk == null) {
            return false;
        }
        io.atlassian.fugue.Either isAgentEither = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(remoteUser, serviceDesk));
        return isAgentEither.isRight() && (Boolean)isAgentEither.right().get() != false;
    }

    private boolean isAdminAgent(ApplicationUser remoteUser, String projectId) {
        ServiceDesk serviceDesk = this.getServiceDesk(remoteUser, projectId);
        if (serviceDesk == null) {
            return false;
        }
        io.atlassian.fugue.Either isAdminAgentEither = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(remoteUser, serviceDesk));
        return isAdminAgentEither.isRight() && (Boolean)isAdminAgentEither.right().get() != false;
    }
}

