/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeWithFields;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternalService;
import com.atlassian.servicedesk.internal.rest.responses.UserFieldView;
import io.atlassian.fugue.Either;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeFieldInternalManagerImpl
implements RequestTypeFieldInternalManager {
    private final RequestTypeFieldInternalService requestTypeFieldInternalService;
    private final CommonErrors commonErrors;

    @Autowired
    public RequestTypeFieldInternalManagerImpl(RequestTypeFieldInternalService requestTypeFieldInternalService, CommonErrors commonErrors) {
        this.requestTypeFieldInternalService = requestTypeFieldInternalService;
        this.commonErrors = commonErrors;
    }

    @Override
    public List<UserFieldView> getUserFieldViewForRequestType(CheckedUser checkedUser, Project project, RequestType requestType, IssueType issueType) {
        return this.requestTypeFieldInternalService.getUserFieldViewForRequestType(checkedUser, project, requestType, issueType);
    }

    @Override
    public Either<AnError, RequestTypeWithFields> getRequestTypeFields(CheckedUser checkedUser, Project project, RequestType requestType) {
        return this.requestTypeFieldInternalService.getRequestTypeFields(checkedUser, project, requestType).flatMap(fields -> RequestTypeWithFields.build(requestType, fields).toRight(() -> ((CommonErrors)this.commonErrors).REQUEST_TYPE_INTEGRITY_ERROR()));
    }
}

