/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field;

import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.PartialRequestTypeField;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.value.RequestTypeFieldValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RequestTypeFieldInternal {
    private final int id;
    private final String fieldId;
    private String serviceDeskFieldType;
    private String label;
    private String description;
    private boolean required;
    private boolean displayed;
    private int order;
    private List<RequestTypeFieldValue> values;
    private int formId;

    public RequestTypeFieldInternal(int id, String fieldId, String serviceDeskFieldType, String label, String description, boolean required2, boolean displayed, int order, List<RequestTypeFieldValue> values2, int formId) {
        this.id = id;
        this.fieldId = fieldId;
        this.serviceDeskFieldType = serviceDeskFieldType;
        this.label = label;
        this.description = description;
        this.required = required2;
        this.displayed = displayed;
        this.order = order;
        this.values = values2;
        this.formId = formId;
    }

    public RequestTypeFieldInternal(RequestType requestType, OrderableField<?> field) {
        this.id = 0;
        this.fieldId = field.getId();
        this.serviceDeskFieldType = "";
        this.label = field.getName();
        this.description = "";
        this.required = false;
        this.displayed = true;
        this.order = 0;
        this.values = new ArrayList<RequestTypeFieldValue>();
        this.formId = requestType.getId();
    }

    public RequestTypeFieldInternal(PartialRequestTypeField f) {
        this.id = 0;
        this.fieldId = f.getFieldId();
        this.serviceDeskFieldType = f.getServiceDeskFieldId();
        this.label = f.getLabel();
        this.description = f.getDescription();
        this.required = f.isRequired();
        this.displayed = f.isDisplayed();
        this.order = f.getOrder();
        this.values = f.getValues().stream().map(RequestTypeFieldValue::new).collect(Collectors.toList());
        this.formId = 0;
    }

    public RequestTypeFieldInternal(int id, String fieldId, String serviceDeskFieldType, String label, String description, boolean required2, boolean displayed, int order, int formId) {
        this.id = id;
        this.fieldId = fieldId;
        this.serviceDeskFieldType = serviceDeskFieldType;
        this.label = label;
        this.description = description;
        this.required = required2;
        this.displayed = displayed;
        this.order = order;
        this.formId = formId;
    }

    public int getId() {
        return this.id;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getServiceDeskFieldType() {
        return this.serviceDeskFieldType;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public int getOrder() {
        return this.order;
    }

    public List<RequestTypeFieldValue> getValues() {
        return this.values;
    }

    public int getFormId() {
        return this.formId;
    }

    public void setRequired(boolean required2) {
        this.required = required2;
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setValues(List<RequestTypeFieldValue> values2) {
        this.values = values2;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setServiceDeskFieldType(String serviceDeskFieldType) {
        this.serviceDeskFieldType = serviceDeskFieldType;
    }

    public void setFormId(int formId) {
        this.formId = formId;
    }

    public RequestTypeFieldInternal updateOrder(int order) {
        this.setOrder(order);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeFieldInternal that = (RequestTypeFieldInternal)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

