/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeCreateParameters;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQueryParameters;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RESTfulTableRequestType;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeSystemIconService;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupManager;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeSystemIcon;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeCreateParametersImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeQueryImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeQueryParametersImpl;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelService;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueManager;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.utils.ErrorConverterHelper;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RequestTypeServiceImpl
implements RequestTypeService {
    private final InternalServiceDeskService internalServiceDeskService;
    private final InternalPortalService internalPortalService;
    private final RequestTypeInternalService requestTypeInternalService;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final UserFactory userFactory;
    private final RequestTypeInternalManager requestTypeManager;
    private final VpOriginManager vpOriginManager;
    private final PortalInternalManager portalInternalManager;
    private final ServiceDeskIssueManager serviceDeskIssueManager;
    private final ErrorConverterHelper errorConverterHelper;
    private final RequestTypeGroupManager requestTypeGroupManager;
    private final EmailChannelService emailChannelService;
    private final ErrorResultHelper errorResultHelper;
    private final IssueTypeService issueTypeService;
    private final RequestTypeSystemIconService systemIconService;
    private final ServiceDeskPermissions sdPermissions;

    @Autowired
    public RequestTypeServiceImpl(InternalPortalService internalPortalService, RequestTypeInternalService requestTypeInternalService, InternalServiceDeskProjectManager internalServiceDeskProjectManager, UserFactory userFactory, RequestTypeInternalManager requestTypeManager, VpOriginManager vpOriginManager, PortalInternalManager portalInternalManager, InternalServiceDeskService internalServiceDeskService, ServiceDeskIssueManager serviceDeskIssueManager, ErrorConverterHelper errorConverterHelper, RequestTypeGroupManager requestTypeGroupManager, EmailChannelService emailChannelService, ErrorResultHelper errorResultHelper, IssueTypeService issueTypeService, RequestTypeSystemIconService systemIconService, ServiceDeskPermissions sdPermissions) {
        this.internalPortalService = internalPortalService;
        this.requestTypeInternalService = requestTypeInternalService;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.userFactory = userFactory;
        this.requestTypeManager = requestTypeManager;
        this.vpOriginManager = vpOriginManager;
        this.portalInternalManager = portalInternalManager;
        this.internalServiceDeskService = internalServiceDeskService;
        this.serviceDeskIssueManager = serviceDeskIssueManager;
        this.errorConverterHelper = errorConverterHelper;
        this.requestTypeGroupManager = requestTypeGroupManager;
        this.emailChannelService = emailChannelService;
        this.errorResultHelper = errorResultHelper;
        this.issueTypeService = issueTypeService;
        this.systemIconService = systemIconService;
        this.sdPermissions = sdPermissions;
    }

    public RequestTypeQuery.Builder newQueryBuilder() {
        return RequestTypeQueryImpl.builder();
    }

    @Nonnull
    public Either<AnError, PagedResponse<RequestType>> getRequestTypes(@Nullable ApplicationUser user, @Nonnull RequestTypeQuery requestTypeQuery) {
        Assertions.notNull((String)"requestTypeQuery", (Object)requestTypeQuery);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.dispatchRequestTypeQuery((CheckedUser)checkedUser, requestTypeQuery)).then((checkedUser, requestTypeList) -> this.filterRequestTypeList((List<RequestType>)requestTypeList, requestTypeQuery)).yield((checkedUser, ignored, filteredRequestTypeList) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)requestTypeQuery.pagedRequest(), (List)filteredRequestTypeList)));
    }

    private io.atlassian.fugue.Either<AnError, List<RequestType>> dispatchRequestTypeQuery(CheckedUser checkedUser, RequestTypeQuery requestTypeQuery) {
        if (requestTypeQuery.issue().isDefined()) {
            if (((Boolean)requestTypeQuery.requestOverrideSecurity().getOrElse((Object)false)).booleanValue()) {
                return this.getRequestTypeForIssueOverrideSecurity((Long)requestTypeQuery.issue().get()).map(xva$0 -> Arrays.asList(xva$0));
            }
            return this.getRequestTypeForIssue(checkedUser, (Long)requestTypeQuery.issue().get()).map(xva$0 -> Arrays.asList(xva$0));
        }
        if (requestTypeQuery.requestType().isDefined()) {
            return this.getRequestTypeById(checkedUser, requestTypeQuery).map(xva$0 -> Arrays.asList(xva$0));
        }
        if (requestTypeQuery.serviceDesk().isDefined()) {
            if (requestTypeQuery.group().isDefined()) {
                return StepsConverters.newerEither(this.getRequestTypesByGroup((Integer)requestTypeQuery.group().get(), (Integer)requestTypeQuery.serviceDesk().get()));
            }
            return this.getRequestTypesByServiceDesk(checkedUser, (Integer)requestTypeQuery.serviceDesk().get());
        }
        return this.getAllRequestTypes(checkedUser);
    }

    private io.atlassian.fugue.Either<AnError, List<RequestType>> filterRequestTypeList(List<RequestType> requestTypeList, RequestTypeQuery requestTypeQuery) {
        List partiallyFilteredRequestTypeList = requestTypeList.stream().filter(this.filterHidden(requestTypeQuery)).collect(Collectors.toList());
        if (requestTypeQuery.isValid().isEmpty()) {
            return StepsConverters.newerEither((Either)Either.right(partiallyFilteredRequestTypeList));
        }
        Boolean expectedValidity = (Boolean)requestTypeQuery.isValid().get();
        ArrayList<RequestType> filteredRequestTypeList = new ArrayList<RequestType>();
        for (RequestType requestType : partiallyFilteredRequestTypeList) {
            io.atlassian.fugue.Either isValidRequestTypeEither = Steps.begin(this.portalInternalManager.getPortalById(requestType.getPortalId())).then(portal -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(this.internalPortalService.toPortalInternal((Portal)portal).getProjectId()))).yield((portal, project) -> this.requestTypeManager.isValidRequestTypeForProject(requestType, (Project)project).isRight());
            if (isValidRequestTypeEither.isLeft()) {
                return StepsConverters.newerEither((Either)Either.left((Object)isValidRequestTypeEither.left().get()));
            }
            if (!((Boolean)isValidRequestTypeEither.right().get()).equals(expectedValidity)) continue;
            filteredRequestTypeList.add(requestType);
        }
        return StepsConverters.newerEither((Either)Either.right(filteredRequestTypeList));
    }

    private Predicate<RequestType> filterHidden(RequestTypeQuery requestTypeQuery) {
        return requestType -> {
            Boolean shouldFilterHidden = (Boolean)requestTypeQuery.getFilterHidden().getOrElse((Object)false);
            Boolean isHidden = requestType.getGroups().isEmpty();
            return shouldFilterHidden == false || isHidden == false;
        };
    }

    @Nonnull
    @Deprecated
    public Either<AnError, List<RequestType>> getRequestTypes(@Nonnull ApplicationUser user, @Nonnull RequestTypeQueryParameters requestTypeQueryParameters) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"requestTypeQueryParameters", (Object)requestTypeQueryParameters);
        Assertions.notNull((String)"portal", (Object)requestTypeQueryParameters.portal());
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalPortalService.getPortalById((CheckedUser)checkedUser, Long.valueOf(requestTypeQueryParameters.portal().getId()))).then((checkedUser, portal) -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(this.internalPortalService.toPortalInternal((Portal)portal).getProjectId()))).then((checkedUser, portal, project) -> this.getRequestTypesByPortalOrRequestTypeId((CheckedUser)checkedUser, (Portal)portal, (Project)project, requestTypeQueryParameters)).yield((checkedUser, portal, project, requestTypes) -> requestTypes));
    }

    private io.atlassian.fugue.Either<AnError, List<RequestType>> getRequestTypesByPortalOrRequestTypeId(CheckedUser checkedUser, Portal portal, Project project, RequestTypeQueryParameters requestTypeQueryParameters) {
        io.atlassian.fugue.Option requestTypeId = StepsConverters.newerOption((Option)requestTypeQueryParameters.requestTypeId());
        if (requestTypeId.isEmpty()) {
            return this.requestTypeInternalService.getAllValidRequestTypes(checkedUser, project, portal);
        }
        return this.requestTypeInternalService.getValidRequestTypeByPortal(checkedUser, project, portal, (Integer)requestTypeId.get()).map(xva$0 -> Arrays.asList(xva$0));
    }

    private io.atlassian.fugue.Either<AnError, List<RequestType>> getRequestTypesByServiceDesk(CheckedUser checkedUser, int serviceDeskId) {
        return Steps.begin((io.atlassian.fugue.Either)this.internalServiceDeskService.getServiceDeskById(checkedUser, (long)serviceDeskId)).then(sd -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(sd.getProjectId()))).then((sd, project) -> this.internalPortalService.getPortalByProject(checkedUser, (Project)project)).then((sd, project, portal) -> this.requestTypeInternalService.getAllValidRequestTypes(checkedUser, project, portal)).yield((sd, project, portal, rts) -> rts);
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeById(CheckedUser checkedUser, RequestTypeQuery requestTypeQuery) {
        io.atlassian.fugue.Either requestTypeEither = this.requestTypeManager.getAnyRequestType((Integer)requestTypeQuery.requestType().get()).leftMap(this.errorConverterHelper::toJavaError);
        if (requestTypeQuery.serviceDesk().isDefined()) {
            return Steps.begin((io.atlassian.fugue.Either)this.internalServiceDeskService.getServiceDeskById(checkedUser, (long)((Integer)requestTypeQuery.serviceDesk().get()).intValue())).then(sd -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(sd.getProjectId()))).then((sd, project) -> this.internalPortalService.getPortalByProject(checkedUser, (Project)project)).then((sd, project, portal) -> requestTypeEither).then((sd, project, portal, rt) -> this.requestTypeInternalService.getValidRequestTypeByPortal(checkedUser, project, portal, Integer.valueOf(rt.getId()))).yield((sd, project, portal, rt, validRt) -> validRt);
        }
        return Steps.begin((io.atlassian.fugue.Either)requestTypeEither).then(requestType -> this.internalPortalService.getPortalById(checkedUser, requestType.getPortalId())).then((requestType, portal) -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(this.portalInternalManager.toPortalInternal((Portal)portal).getProjectId()))).then((requestType, portal, project) -> this.requestTypeInternalService.getValidRequestTypeByPortal(checkedUser, project, portal, Integer.valueOf(requestType.getId()))).yield((requestType, portal, project, validRt) -> validRt);
    }

    @Deprecated
    public RequestTypeQueryParameters.Builder queryBuilder() {
        return new RequestTypeQueryParametersImpl.BuilderImpl();
    }

    @Nonnull
    @Deprecated
    public Either<AnError, RequestType> getRequestTypeForRequest(@Nonnull ApplicationUser user, @Nonnull CustomerRequest customerRequest) {
        Issue issue = customerRequest.getIssue();
        return this.getRequestTypeForIssue(user, issue);
    }

    @Nonnull
    @Deprecated
    public Either<AnError, RequestType> getRequestTypeForIssue(@Nonnull ApplicationUser user, @Nonnull Issue issue) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither(this.getRequestTypeForIssue((CheckedUser)checkedUser, issue))).yield((checkedUser1, requestType) -> requestType);
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeForIssue(CheckedUser checkedUser, Issue issue) {
        return Steps.begin(this.internalPortalService.getPortalByProject(checkedUser, issue.getProjectObject())).then(() -> this.vpOriginManager.lookupOrError(issue)).then(this::getRequestTypeByVpOrigin).yield((p, vp, rt) -> rt);
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeForIssue(CheckedUser checkedUser, Long issueId) {
        return Steps.begin(this.serviceDeskIssueManager.getIssueById(issueId)).then(issue -> this.getRequestTypeForIssue(checkedUser, (Issue)issue)).yield((issue, rt) -> rt);
    }

    @Nonnull
    @Deprecated
    public Either<AnError, List<RequestType>> getAllRequestTypes(ApplicationUser user) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(this::getAllRequestTypes).yield((checkedUser, requestTypes) -> requestTypes));
    }

    private io.atlassian.fugue.Either<AnError, List<RequestType>> getAllRequestTypes(CheckedUser checkedUser) {
        List visiblePortalIds = Lists.transform(this.internalPortalService.getCustomerVisiblePortals(checkedUser), Portal::getId);
        if (visiblePortalIds.isEmpty()) {
            return StepsConverters.newerEither((Either)Either.right(Collections.emptyList()));
        }
        List<RequestType> requestTypes = this.requestTypeManager.getRequestTypesByPortalIds(Sets.newHashSet((Iterable)visiblePortalIds));
        return StepsConverters.newerEither((Either)Either.right(requestTypes));
    }

    @Nonnull
    @Deprecated
    public Either<AnError, RequestType> getRequestTypeForRequestOverrideSecurity(@Nonnull CustomerRequest customerRequest) {
        return this.getRequestTypeForIssueOverrideSecurity(customerRequest.getIssue());
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeForIssueOverrideSecurity(Long issueId) {
        return StepsConverters.newerEither((Either)Steps.begin((Either)StepsConverters.olderEither(this.serviceDeskIssueManager.getIssueById(issueId))).then(this::getRequestTypeForIssueOverrideSecurity).yield((issue, rt) -> rt));
    }

    @Nonnull
    @Deprecated
    public Either<AnError, RequestType> getRequestTypeForIssueOverrideSecurity(@Nonnull Issue issue) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin(this.vpOriginManager.lookupOrError(issue)).then(() -> this.portalInternalManager.getPortalByProject(issue.getProjectObject())).then((vp, p) -> this.getRequestTypeByVpOrigin((Portal)p, (VpOrigin)vp)).yield((vp, p, rt) -> rt));
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeByVpOrigin(Portal portal, VpOrigin vpOrigin) {
        return this.requestTypeManager.getRequestTypeByKey(portal, vpOrigin.getRequestTypeKey());
    }

    public RequestTypeCreateParameters.Builder newCreateBuilder() {
        return new RequestTypeCreateParametersImpl.BuilderImpl();
    }

    public Either<AnError, RequestType> createRequestType(ApplicationUser user, RequestTypeCreateParameters params) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(() -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(params.serviceDesk().getProjectId()))).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.doCreateNewRequestType(params, (CheckedUser)checkedUser, (Project)project, (Portal)portal)).yield((checkedUser, project, portal, requestType) -> requestType));
    }

    public Either<AnError, List<RequestType>> getRequestTypesForGroup(Integer groupId, Long projectId) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskService.getServiceDeskForProjectId(user, projectId.longValue(), false)).then((user, sd) -> this.getRequestTypesForGroup(groupId, (ServiceDesk)sd)).yield((user, sd, list) -> list));
    }

    public Either<AnError, List<RequestType>> getRequestTypesByGroup(Integer groupId, Integer serviceDeskId) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskService.getServiceDeskById(user, (long)serviceDeskId.intValue())).then((user, sd) -> this.getRequestTypesForGroup(groupId, (ServiceDesk)sd)).yield((user, sd, list) -> list));
    }

    private io.atlassian.fugue.Either<AnError, List<RequestType>> getRequestTypesForGroup(Integer groupId, ServiceDesk serviceDesk) {
        ArrayList requestTypesInGroup = Lists.newArrayList(this.requestTypeGroupManager.getRequestTypesInGroupSorted(groupId, serviceDesk.getProjectId()));
        this.requestTypeManager.populateEmailUsage(serviceDesk, requestTypesInGroup);
        return io.atlassian.fugue.Either.right((Object)requestTypesInGroup);
    }

    public Either<AnError, RequestType> getRequestTypeByIdAndProjectId(Integer requestTypeId, Long projectId) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.internalServiceDeskProjectManager.getProject(projectId)).then((checkedUser, project) -> this.requestTypeInternalService.getRequestTypeById(checkedUser, requestTypeId, project)).yield((checkedUser, project, requestType) -> requestType));
    }

    private io.atlassian.fugue.Either<AnError, Boolean> validateUsedByEmail(RequestType requestType) {
        io.atlassian.fugue.Either result = this.requestTypeInternalService.isUsedByEmail(requestType);
        if (result.isLeft()) {
            return StepsConverters.newerEither((Either)Either.left((Object)result.left().get()));
        }
        if (((Boolean)result.right().get()).booleanValue()) {
            return StepsConverters.newerEither((Either)Either.left((Object)this.errorResultHelper.badRequest400("sd.admin.request.type.error.used.by.email.settings", new Object[0]).build()));
        }
        return StepsConverters.newerEither((Either)Either.right((Object)Boolean.FALSE));
    }

    public Either<AnError, RequestType> deleteRequestTypeByIdAndProjectId(Integer requestTypeId, Long projectId) {
        Project project;
        io.atlassian.fugue.Either requestTypeEither = StepsConverters.newerEither(this.getRequestTypeByIdAndProjectId(requestTypeId, projectId));
        io.atlassian.fugue.Either userEither = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        io.atlassian.fugue.Either projectEither = this.internalServiceDeskProjectManager.getProject(projectId);
        if (requestTypeEither.isLeft()) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)requestTypeEither);
        }
        if (userEither.isLeft()) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.left((Object)userEither.left().get()));
        }
        if (projectEither.isLeft()) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.left((Object)projectEither.left().get()));
        }
        RequestType requestType = (RequestType)requestTypeEither.right().get();
        CheckedUser checkedUser = (CheckedUser)userEither.right().get();
        if (!this.sdPermissions.canAdministerServiceDesk((SDUser)checkedUser, project = (Project)projectEither.right().get())) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.admin.servicedesk.project.permission", new Object[0]).build()));
        }
        io.atlassian.fugue.Either removed = Steps.begin(this.validateUsedByEmail(requestType)).then(used -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((used, sd) -> this.emailChannelService.removeBrokenEmailChannelsByRequestTypeAsProjectAdmin(checkedUser, (ServiceDesk)sd, project, requestType)).yield((used, sd, success) -> success);
        if (removed.isRight()) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin(this.internalPortalService.getPortalByProject(checkedUser, project)).then(portal -> this.requestTypeInternalService.deleteRequestType(checkedUser, requestType, project, portal)).yield((portal, rtDeleted) -> rtDeleted));
        }
        return Either.left((Object)removed.left().get());
    }

    public Either<AnError, RequestType> updateRequestTypeByIdAndProjectId(Integer requestTypeId, Long projectId, RequestType requestType) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.internalServiceDeskProjectManager.getProject(projectId)).then((checkedUser, project) -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((checkedUser, project, sd) -> this.internalPortalService.getPortalByProject((CheckedUser)checkedUser, (Project)project)).then((checkedUser, project, sd, portal) -> this.requestTypeInternalService.updateRequestType(checkedUser, requestTypeId.intValue(), project, portal, requestType)).yield((checkedUser, project, sd, portal, rtUpdated) -> rtUpdated));
    }

    private io.atlassian.fugue.Either<AnError, RequestType> doCreateNewRequestType(RequestTypeCreateParameters params, CheckedUser checkedUser, Project project, Portal portal) {
        return Steps.begin((io.atlassian.fugue.Either)this.requestTypeInternalService.addRequestType(checkedUser, project, portal, this.toRestfulTableRequestType(portal, params), params.issueType())).then(requestType -> this.requestTypeInternalService.updateHelpText(checkedUser, requestType, params.helpText().orElse(requestType.getDescription()), project)).yield((requestType, requestTypeWithHelpText) -> requestTypeWithHelpText);
    }

    private RESTfulTableRequestType toRestfulTableRequestType(Portal portal, RequestTypeCreateParameters createParameters) {
        Long iconId = this.systemIconService.getIconIdForSystemIcon(RequestTypeSystemIcon.ICON_QUESTION);
        return new RESTfulTableRequestType(this.internalPortalService.toPortalInternal(portal).getKey(), io.atlassian.fugue.Option.none(), io.atlassian.fugue.Option.option((Object)iconId), io.atlassian.fugue.Option.option((Object)Long.valueOf(createParameters.issueType().getId())), io.atlassian.fugue.Option.option((Object)createParameters.name()), io.atlassian.fugue.Option.fromOptional((Optional)createParameters.description()), io.atlassian.fugue.Option.option((Object)Lists.newArrayList()), io.atlassian.fugue.Option.none());
    }

    private io.atlassian.fugue.Either<AnError, IssueType> getIssueTypeById(ApplicationUser user, int issueTypeId) {
        return StepsConverters.newerEither((Either)this.issueTypeService.getIssueType(user, String.valueOf(issueTypeId)).toRight(Suppliers.ofInstance((Object)this.errorResultHelper.notFound404("sd.api.issue.type.not.found", new Object[0]).build())));
    }

    public Either<AnError, RequestType> createRequestType(long projectId, int issueTypeId, String name, String description, long iconId, List<Integer> groupIds) {
        io.atlassian.fugue.Either checkedUser = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        if (checkedUser.isLeft()) {
            return Either.left((Object)checkedUser.left().get());
        }
        io.atlassian.fugue.Either project = this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId));
        if (project.isLeft()) {
            return Either.left((Object)checkedUser.left().get());
        }
        io.atlassian.fugue.Either<AnError, Portal> portal = this.internalPortalService.getPortalByProject((CheckedUser)checkedUser.right().get(), (Project)project.right().get());
        if (portal.isLeft()) {
            return Either.left((Object)portal.left().get());
        }
        io.atlassian.fugue.Either<AnError, IssueType> issueType = this.getIssueTypeById(((CheckedUser)checkedUser.right().get()).forJIRA(), issueTypeId);
        if (issueType.isLeft()) {
            return Either.left((Object)issueType.left().get());
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        for (int groupId : groupIds) {
            io.atlassian.fugue.Either<AnError, RequestTypeGroup> group = this.requestTypeGroupManager.getGroup(groupId, (Portal)portal.right().get());
            if (group.isLeft()) {
                return Either.left((Object)group.left().get());
            }
            groupNames.add(((RequestTypeGroup)group.right().get()).getName());
        }
        RESTfulTableRequestType resTfulTableRequestType = new RESTfulTableRequestType(this.internalPortalService.toPortalInternal((Portal)portal.right().get()).getKey(), io.atlassian.fugue.Option.none(), io.atlassian.fugue.Option.option((Object)iconId), io.atlassian.fugue.Option.option((Object)Long.valueOf(((IssueType)issueType.right().get()).getId())), io.atlassian.fugue.Option.option((Object)name), io.atlassian.fugue.Option.option((Object)description), io.atlassian.fugue.Option.option(groupNames), io.atlassian.fugue.Option.none());
        return StepsConverters.olderEither((io.atlassian.fugue.Either)this.requestTypeInternalService.addRequestType((CheckedUser)checkedUser.right().get(), (Project)project.right().get(), (Portal)portal.right().get(), resTfulTableRequestType, (IssueType)issueType.right().get()));
    }
}

