/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupManager;
import com.atlassian.servicedesk.internal.api.requesttype.icons.ServiceDeskAvatarManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.CreateRequestTypeParams;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.CreateRequestTypeValidationResult;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeModificationService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.UpdateRequestTypeParams;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.UpdateRequestTypeValidationResult;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeModificationServiceImpl
implements RequestTypeModificationService {
    public static final int MAX_NAME_LENGTH = 255;
    private final ErrorResultHelper errorResultHelper;
    private final RequestTypeInternalManager requestTypeInternalManager;
    private final UserFactory userFactory;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskService serviceDeskService;
    private final ServiceDeskAvatarManager serviceDeskAvatarManager;
    private final PortalManager portalManager;
    private final RequestTypeGroupManager requestTypeGroupManager;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final InternalPortalService internalPortalService;

    @Autowired
    public RequestTypeModificationServiceImpl(ErrorResultHelper errorResultHelper, RequestTypeInternalManager requestTypeInternalManager, UserFactory userFactory, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskService serviceDeskService, ServiceDeskAvatarManager serviceDeskAvatarManager, PortalManager portalManager, RequestTypeGroupManager requestTypeGroupManager, ServiceDeskProjectService serviceDeskProjectService, InternalPortalService internalPortalService) {
        this.errorResultHelper = errorResultHelper;
        this.requestTypeInternalManager = requestTypeInternalManager;
        this.userFactory = userFactory;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskService = serviceDeskService;
        this.serviceDeskAvatarManager = serviceDeskAvatarManager;
        this.portalManager = portalManager;
        this.requestTypeGroupManager = requestTypeGroupManager;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.internalPortalService = internalPortalService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CreateRequestTypeValidationResult> validateCreateRequestType(CreateRequestTypeParams createRequestTypeParams, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(checkedUser.forJIRA(), project))).then(this::canModifyRequestType).yield((checkedUser, serviceDesk, valid) -> this.validateCreation(createRequestTypeParams, project, (CheckedUser)checkedUser));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, UpdateRequestTypeValidationResult> validateUpdateRequestType(UpdateRequestTypeParams updateRequestTypeParams, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(checkedUser.forJIRA(), project))).then(this::canModifyRequestType).yield((checkedUser, serviceDesk, valid) -> this.validateUpdate(updateRequestTypeParams, project, (CheckedUser)checkedUser));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RequestType> createRequestType(CreateRequestTypeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            AnError anError = this.errorResultHelper.internalServiceError500("sd.admin.request.create.error.validation.invalid", new Object[0]).build();
            return io.atlassian.fugue.Either.left((Object)anError);
        }
        return this.requestTypeInternalManager.createRequestType(validationResult.getParams(), validationResult.getProject(), validationResult.getIssueType());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RequestType> updateRequestType(int id, UpdateRequestTypeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            AnError anError = this.errorResultHelper.internalServiceError500("sd.admin.request.update.error.validation.invalid", new Object[0]).build();
            return io.atlassian.fugue.Either.left((Object)anError);
        }
        return this.requestTypeInternalManager.updateRequestType(id, validationResult.getParams(), validationResult.getProject());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RequestType> updateRequestTypeHelpText(int id, long projectId, @Nonnull String helpText) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, projectId)).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeInternalManager.updateRequestTypeHelpText(id, helpText, (Project)project)).yield((checkedUser, project, portal, requestType) -> requestType);
    }

    private io.atlassian.fugue.Either<AnError, Boolean> canModifyRequestType(CheckedUser checkedUser, ServiceDesk serviceDesk) {
        io.atlassian.fugue.Either either = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(checkedUser.forJIRA(), serviceDesk));
        if (either.isRight() && ((Boolean)either.right().get()).booleanValue()) {
            return either;
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.admin.details.tab.kb.agent.admin.permissions.error", new Object[0]).build());
    }

    private CreateRequestTypeValidationResult validateCreation(CreateRequestTypeParams params, Project project, CheckedUser checkedUser) {
        Optional<IssueType> issueType;
        CreateRequestTypeValidationResult.Builder validationResultBuilder = new CreateRequestTypeValidationResult.Builder(params);
        validationResultBuilder.project(project);
        if (StringUtils.isBlank((String)params.getName())) {
            validationResultBuilder.addNamedError("name", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.name.required"));
        } else if (StringUtils.length((String)params.getName()) > 255) {
            validationResultBuilder.addNamedError("name", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.name.too.long"));
        }
        if (!this.serviceDeskAvatarManager.isValidId(Long.valueOf(params.getIcon()))) {
            validationResultBuilder.addNamedError("requestTypeIcon", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.icon.invalid"));
        }
        if (!(issueType = this.getIssueType(params.getIssueTypeId(), project)).isPresent()) {
            validationResultBuilder.addNamedError("issueType", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.issuetype.required"));
        } else {
            validationResultBuilder.issueType(issueType.get());
        }
        if (params.hasGroup() && !this.isCorrectGroup(params.getGroupId(), project)) {
            validationResultBuilder.addNamedError("group", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.incorrect.group"));
        }
        return validationResultBuilder.build();
    }

    private boolean isCorrectGroup(Integer groupId, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)this.portalManager.getPortalByProject(project)).then(portal -> this.requestTypeGroupManager.getGroup(groupId, (Portal)portal)).yield((portal, group) -> group).isRight();
    }

    private ErrorMessage getErrorMessage(CheckedUser checkedUser, String i18nKey) {
        return new ErrorMessage.Builder().message(checkedUser.i18NHelper().getText(i18nKey), i18nKey).build();
    }

    private UpdateRequestTypeValidationResult validateUpdate(UpdateRequestTypeParams params, Project project, CheckedUser checkedUser) {
        UpdateRequestTypeValidationResult.Builder validationResultBuilder = new UpdateRequestTypeValidationResult.Builder(params);
        validationResultBuilder.project(project);
        if (StringUtils.isBlank((String)params.getName())) {
            validationResultBuilder.addNamedError("name", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.name.required"));
        } else if (StringUtils.length((String)params.getName()) > 255) {
            validationResultBuilder.addNamedError("name", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.name.too.long"));
        }
        if (!this.serviceDeskAvatarManager.isValidId(Long.valueOf(params.getIcon()))) {
            validationResultBuilder.addNamedError("requestTypeIcon", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.icon.invalid"));
        }
        if (!this.projectContainsGroups(project, params.getGroupIds())) {
            validationResultBuilder.addNamedError("group", this.getErrorMessage(checkedUser, "sd.admin.request.edit.error.incorrect.group"));
        }
        return validationResultBuilder.build();
    }

    private boolean projectContainsGroups(Project project, List<Integer> groupIds) {
        return (Boolean)this.portalManager.getPortalByProject(project).fold(anError -> false, portal -> this.checkValidIds(groupIds, (Portal)portal));
    }

    private Boolean checkValidIds(List<Integer> groupIds, Portal portal) {
        return this.requestTypeGroupManager.getGroups(portal).stream().map(group -> group.getId()).collect(Collectors.toList()).containsAll(groupIds);
    }

    private Optional<IssueType> getIssueType(long issueTypeId, Project project) {
        return project.getIssueTypes().stream().filter(issueType -> issueType.getId().equals(issueTypeId + "")).findFirst();
    }
}

