/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RESTfulTableRequestType;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupManager;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.errors.ServiceDeskHttpError;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalServiceScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailPlatformChannelManager;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.utils.ErrorConverterHelper;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestTypeInternalServiceImpl
implements RequestTypeInternalService {
    private final RequestTypeInternalServiceScala requestTypeInternalServiceScala;
    private final VpOriginManager vpOriginManager;
    private final ErrorConverterHelper errorConverterHelper;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ErrorResultHelper errorResultHelper;
    private final RequestTypeInternalManager requestTypeInternalManager;
    private final UserFactory userFactory;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final RequestTypeGroupManager requestTypeGroupManager;
    private final EmailPlatformChannelManager emailChannelManager;

    @Autowired
    public RequestTypeInternalServiceImpl(RequestTypeInternalServiceScala requestTypeInternalServiceScala, VpOriginManager vpOriginManager, ErrorConverterHelper errorConverterHelper, ServiceDeskPermissions serviceDeskPermissions, ErrorResultHelper errorResultHelper, RequestTypeInternalManager requestTypeInternalManager, UserFactory userFactory, InternalServiceDeskProjectManager internalServiceDeskProjectManager, RequestTypeGroupManager requestTypeGroupManager, EmailPlatformChannelManager emailChannelManager) {
        this.requestTypeInternalServiceScala = requestTypeInternalServiceScala;
        this.vpOriginManager = vpOriginManager;
        this.errorConverterHelper = errorConverterHelper;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.errorResultHelper = errorResultHelper;
        this.requestTypeInternalManager = requestTypeInternalManager;
        this.userFactory = userFactory;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.requestTypeGroupManager = requestTypeGroupManager;
        this.emailChannelManager = emailChannelManager;
    }

    public io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeForIssue(CheckedUser user, Issue issue) {
        return Steps.begin(this.vpOriginManager.lookupOrError(issue)).then(vp -> this.getRequestTypeForIssueWithVpOrigin(user, issue, (VpOrigin)vp)).yield((vp, rt) -> rt);
    }

    public io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeByKey(CheckedUser user, String key, Project project, Portal portal) {
        if (!this.serviceDeskPermissions.canViewPortal((SDUser)user, project)) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.admin.requestfield.edit.error.nopermission", new Object[0]).build());
        }
        return this.requestTypeInternalManager.getRequestTypeByKey(portal, key);
    }

    public io.atlassian.fugue.Either<AnError, RequestType> addRequestType(CheckedUser user, Project project, Portal portal, RESTfulTableRequestType rESTfulTableRequestType, IssueType issueType) {
        return this.errorConverterHelper.toJavaErrorEither(this.requestTypeInternalServiceScala.addRequestType(user, project, portal, rESTfulTableRequestType, issueType));
    }

    public io.atlassian.fugue.Either<AnError, List<RequestType>> getAllValidRequestTypes(CheckedUser user, Project project, Portal portal) {
        return this.requestTypeInternalServiceScala.getAllValidRequestTypesJava(user, project, portal);
    }

    public io.atlassian.fugue.Either<AnError, List<RequestType>> getAllValidNonHiddenRequestTypes(CheckedUser user, Project project, Portal portal) {
        return Steps.begin(this.getAllValidRequestTypes(user, project, portal)).yield(validRequestTypes -> validRequestTypes.stream().filter(validRequestType -> validRequestType.getGroups().size() > 0).collect(Collectors.toList()));
    }

    public io.atlassian.fugue.Either<AnError, RequestType> getValidRequestTypeByPortal(CheckedUser user, Project project, Portal portal, Integer requestTypeId) {
        io.atlassian.fugue.Either<ServiceDeskHttpError, RequestType> result = this.requestTypeInternalManager.getValidRequestType(requestTypeId, project);
        return Steps.begin((io.atlassian.fugue.Either)result.leftMap(this.errorConverterHelper::toJavaError)).then(requestType -> {
            PortalInternal portalInternal = (PortalInternal)portal;
            if ((long)portalInternal.getId() == requestType.getPortalId() && portalInternal.getProjectId() == project.getId().longValue()) {
                return io.atlassian.fugue.Either.right((Object)requestType);
            }
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.customerview.error.requestTypeNotFound", new Object[0]).build());
        }).yield((requestType, validatedRequestType) -> validatedRequestType);
    }

    public io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeById(CheckedUser user, Integer id, Project project) {
        if (this.serviceDeskPermissions.canViewPortal((SDUser)user, project)) {
            return this.requestTypeInternalManager.getRequestTypeByIdWithAdditionalProjectCheck(id, project);
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.internal.portal.not-permitted", new Object[0]).build());
    }

    public io.atlassian.fugue.Either<AnError, RequestType> getPreviewableRequestTypeById(CheckedUser user, Integer id, Project project) {
        return Steps.begin(this.getRequestTypeById(user, id, project)).then(requestType -> {
            Boolean hasGroup = requestType.getGroups().size() > 0;
            Boolean canViewRequestType = hasGroup != false || this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project);
            return Eithers.cond((boolean)canViewRequestType, (Object)this.errorResultHelper.notFound404("sd.customerview.error.requestTypeNotFound", new Object[]{id}).build(), (Object)canViewRequestType);
        }).yield((requestType, canViewRequestType) -> requestType);
    }

    public io.atlassian.fugue.Either<AnError, RequestType> getNonHiddenRequestTypeById(CheckedUser user, Integer id, Project project) {
        return Steps.begin(this.getRequestTypeById(user, id, project)).then(requestType -> {
            Boolean isRequestTypeNonHidden = requestType.getGroups().size() > 0;
            return Eithers.cond((boolean)isRequestTypeNonHidden, (Object)this.errorResultHelper.notFound404("sd.customerview.error.requestTypeNotFound", new Object[]{id}).build(), (Object)isRequestTypeNonHidden);
        }).yield((requestType, isRequestTypeNonHidden) -> requestType);
    }

    public io.atlassian.fugue.Either<AnError, RequestType> updateHelpText(CheckedUser user, RequestType requestType, String helpText, Project project) {
        return this.errorConverterHelper.toJavaErrorEither(this.requestTypeInternalServiceScala.updateHelpText(user, requestType, helpText, project));
    }

    public io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeForIssueWithVpOrigin(CheckedUser user, Issue issue, VpOrigin vpOrigin) {
        return this.requestTypeInternalServiceScala.getRequestTypeForIssueWithVpOrigin(user, issue, vpOrigin);
    }

    public io.atlassian.fugue.Either<AnError, RequestType> deleteRequestType(CheckedUser user, RequestType requestType, Project project, Portal portal) {
        if (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return this.requestTypeInternalManager.deleteRequestType(requestType);
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.internal.requesttype.delete.not-permitted", new Object[0]).build());
    }

    public io.atlassian.fugue.Either<AnError, RequestType> updateRequestType(CheckedUser user, int requestTypeId, Project project, Portal portal, RequestType requestType) {
        return this.errorConverterHelper.toJavaErrorEither(this.requestTypeInternalServiceScala.updateRequestTypeToNew(user, requestTypeId, project, portal, requestType));
    }

    public RequestTypeInternal toRequestTypeInternal(RequestType requestType) {
        return (RequestTypeInternal)requestType;
    }

    public List<RequestType> searchRequestTypes(Set<Integer> portalIds, CheckedUser user, String searchTerm, int maxNumResults) {
        return this.requestTypeInternalManager.searchRequestTypes(portalIds, searchTerm, maxNumResults);
    }

    public List<RequestType> loadValidRequestTypes(Set<Integer> portalIds, Map<Integer, Set<String>> portalRequestTypes, Set<String> requestTypeNames) {
        return this.requestTypeInternalManager.loadValidRequestTypes(portalIds, portalRequestTypes, requestTypeNames);
    }

    public io.atlassian.fugue.Either<AnError, List<RequestType>> getHiddenRequestTypes(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        if (this.serviceDeskPermissions.canViewServiceDesk((SDUser)user, project)) {
            return io.atlassian.fugue.Either.right(this.requestTypeInternalManager.getHiddenRequestTypes(serviceDesk, project));
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.internal.portal.not-permitted", new Object[0]).build());
    }

    public io.atlassian.fugue.Either<AnError, RequestTypeInternal> moveRequestType(Integer requestTypeId, Long projectId, Integer groupId, Option<Integer> aboveId) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProject(projectId)).then(this::canAdministerServiceDesk).then((user, project, permission) -> this.requestTypeGroupManager.moveRequestTypeInGroup(requestTypeId, projectId, groupId, aboveId)).yield((user, project, permission, movedRequestType) -> movedRequestType);
    }

    public io.atlassian.fugue.Either<AnError, Long> countHiddenRequestTypes(Project project) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> Eithers.cond((boolean)this.serviceDeskPermissions.canViewServiceDesk((SDUser)user, project), (Object)this.errorResultHelper.forbidden403("sd.admin.servicedesk.project.permission", new Object[0]).build(), (Object)true)).yield((user, permission) -> this.requestTypeInternalManager.countHiddenRequestTypes(project));
    }

    public io.atlassian.fugue.Either<AnError, List<RequestType>> getRequestTypesNotInGroup(long projectId, int groupId) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId))).then(this::canAdministerServiceDesk).yield((user, project, permission) -> this.requestTypeInternalManager.getRequestTypesNotInGroup(projectId, groupId));
    }

    public io.atlassian.fugue.Either<AnError, List<RequestType>> getRequestTypesOnlyInGroup(long projectId, int groupId) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId))).then(this::canAdministerServiceDesk).yield((user, project, permission) -> this.requestTypeInternalManager.getRequestTypesOnlyInGroup(projectId, groupId));
    }

    private io.atlassian.fugue.Either<AnError, Boolean> canAdministerServiceDesk(CheckedUser user, Project project) {
        return Eithers.cond((boolean)this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project), (Object)this.errorResultHelper.forbidden403("sd.admin.servicedesk.project.permission", new Object[0]).build(), (Object)true);
    }

    public io.atlassian.fugue.Either<AnError, Boolean> isUsedByEmail(RequestType requestType) {
        if (requestType instanceof RequestTypeImpl && ((RequestTypeImpl)requestType).isUsedByEmail().isDefined()) {
            return io.atlassian.fugue.Either.right((Object)((RequestTypeImpl)requestType).isUsedByEmail().get());
        }
        return io.atlassian.fugue.Either.right((Object)this.emailChannelManager.isRequestTypeUsedByEmailChannel(requestType));
    }

    public String getRequestTypeKey(RequestType requestType) {
        return this.toRequestTypeInternal(requestType).getKey();
    }

    public List<RequestType> getRequestTypesByIssueType(CheckedUser user, Project project, Portal portal, IssueType issueType) {
        return this.requestTypeInternalServiceScala.getRequestTypesByIssueTypeJava(user, project, portal, issueType);
    }
}

