/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeIconService;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestTypeIconServiceImpl
implements RequestTypeIconService {
    @TenantAware(value=TenancyScope.TENANTLESS)
    private Map<Integer, String> requestTypeIdToBase64EncodingMap = this.getRequestTypeIdsToBase64Encodings();

    private Map<Integer, String> getRequestTypeIdsToBase64Encodings() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACjUlEQVR42u1Xv0scQRQ+UlmYiLe7ZyTNESQkNzOKBBFJkS4ECUEOLFJIOrEQC3vhQvB2d04sxFZERAJXpEqbQiwkkCr/QQqRIFhIEJED877ZOTx1d29nXdO4Dx7DzLwf38578+ZtoZBTTjnl1EG1woNSgw/bkr+zfDGFEXOs/zcMthSvbZ83iU+JL0L4VO2T3J2BGHDFU3Kypx3+tj2xavm8WpLs1cP6cwsj5lhX+4HcnuNWhjIF4kj2lgyfEB+Sw5kkOpbPPkIeeo4UkxkBEZNksEW8+7g+6oTJ4GTC1iEPveCU2PtbASmusIrKASm+l2vlntATaFTGlTMKT9g+9KAPO/2NYZ4aDIXkF+Lf54r+aBm6SUF+fImSgT7swF5KICrmF8iXeLnuYNQpS/4GcrCb4grzn47P97uDTgZG5R/Zg10zIMsvBrWDuSzBwJ46ndWRJya5UoVSkoQzAQN7Qah41QCMmIdSZ2m3XfES1/w6W574rMHshu2rnGvboVHloc8XTGrLOimd3bi+qVksdYTqDPaT5wwpo9Bdu5p4j77dYEpI7fAgdJ+42BATHWBaOE2TnJmBg6jKmjZnYE/JSvYhORiXjQWJJqayBNO+GAi7Ua9CSkeWxzYzrTMe3yK5P+ZFz+eS+LxbTUgKRteuc+IVczCBMtqGZiZgggvwt7TMB9J1dbpi0ou82BWMZDsxz8BC0ooenxMe3wicidlQRzXWCxl0erFPAMlk1PeynbbBuHbiyiu9NvTo8kOiTy0dIAqVTsBj22Of0HhFNmS0r+TQIcaE+HYtKDXXVHG3dRva/hP4gSqr2oPLP4aWkquPPLvz3xWEit6Xaf2GNal+fFUjzbGeNJQ55ZTTvaB/s7FyfTrucy8AAAAASUVORK5CYII=");
        map.put(1, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABv0lEQVR42u1WsUoDQRANFlYiiFiIrdhYSnY3aCBx9wxBCxFSiFiInVjZWNhYpvI3BH9BxDIGYu5OjF0QsQgiWFlYCOebvQhnSA69W1F0Bx7L7byde7M3N0wmY82aNWu/zFqV2WGTvETWlCznOfzeUzwAnj0ljlqFwkiUc1Hmo7Qf+sED318S3LgYX4k7BD/2JC/iRVtAG8/XzXJ+QovF6it+A/+t9oOHMyf0bFTI1fLCmM5UspmevQZQCw4zQ7TSM+2/cy5LuWk6RzdmtE4Q9NV1WCW63yjNTWL/Cdl7el3MTUX9+GRrdM54/XiKVSkw8PgR7CWsI732+IjPqt9SxK7MZlEnm5+F8eJFZrvIsBNmnhS840q+k+4mHDEf/qJi35VstR98h60Tx1XiYBCHzmsO4iX/nSXbxnXXY4sbvYZeBG4+/oZ5jeKlEoPecWpCDMX5W2KokTWVUIOARrgSNkSxF8tDHBNiAlNIL0byM+qgg1CXbDy8GV6M41EcW8BWzP8V40qxQaNA73j5VTFdzgPFSywmnGkxXiKQzqwP4Dvvzrv1GA7NNu3UEx+NkZSR/mQJQeej46g1a9as/ZS9ATL1EVf6JO/QAAAAAElFTkSuQmCC");
        map.put(2, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABe0lEQVR42mNgGAWjYBSMgkEGXiVrx79M0QnCr0YrFKSOHo5Z/ipFeyFeNUD5Vyla64avY15lafO8TtbeAHTAJyT89FWS9ks0MVQMkX+KLAY2B2geRekDiP/DMdC3sJB5laxzEEUOjoHi0JCBqofLvU7SiibfMUk6yciGvUzWPgmkPV4n6toD6RvYHaN963WStuOrFE0voMOOo8gBzSPbMS+TNF3gPoTi1ylaXcDcMgFdHAWD5JO1O9DFQeZREE1aKi+TdWKphUHmUSOafiDhX1CMLEacGkqiCeqY1+hiIF+iJfQfqFlbJxzdYpA5o46hpWM+oSXCuS+TtGeiimn/QuEnaU8Bq0NV84kajvkBNhyKgQ7Z+zpFZzeyGFDNHxR+kvYOkDo0NT9G08yIccx/aA0Mw++gGFmMODWj0TT8HQNpXAELPc0AGIYWaBNQxMCFHoL/MkmnB1wmoar5RFEj/UOmriDQgDM4GlGk4jNP4jSER/tXo2AUjIKBBADnnrBgQSiHzQAAAABJRU5ErkJggg==");
        map.put(3, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAAB00lEQVR42u2WwSsEURzHN8nBwUVOkn/BzcHFQZIcNqXYN28lJSkK83vaHExJOUib5CZtkovkIDcHycFNDq7SlpLWzjyStDV+v/F2TGO1s0sO2/vWr9197zff99m3W99fLKalpaWlVUO6n7AaHQ79jiGY5Oa4wwV3DOj7tXE+AR1olEbjY2lAFusUP2ckgwHXsuqCvQ43O6kP9wtYbrhsBr1VQchkqhmN95VRAb/ppW3AoYJ5U+t3WCNut1WPr1tq7cHmsEaw+cR8O92SNESc9vDZA/KtCOQ1OdvqMLglCGmYq89jqZbgPt1InotB3LtSh2QVyDodHvazk2aPf0Pomxuea4sMQ6beIQy6yt4gwno/gSEWfurxYRgsK6h0dBgGm/RQpF7vj0q3I+JlYVQv+WsYDaNhNExNwOTYdJPNxSTlEK4/Yb2r+jsYCkN3yGr4ntRfMAiRwvcvfl4xOMLaweDcxrVdyriqYdBwBTPnLJDSxZKY6CeURzg2zKi1x1BPcIzA581z8qschsNG0VDBZLyQY2LKGxU47OE4cV1qZsG6odGDxgjqVwAZhLnwAdE/MgxFPE1n4dGhVJ/NzMXPg8ylcqMB+UkmRisaIbS0tLS0/kEfxKlum+Kr6fwAAAAASUVORK5CYII=");
        map.put(4, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACJ0lEQVR42u1WPWgUQRQ+ggQRsUkhEsRGJIS0IVikSxEsRAJWEkKalCGEFMnsHmyQdBIsRLhCd99sfuAKCRY2JszPEaIQRAKCCBYWIpJGLMQisHlvdj3uzO2et7eeIPPgFfOzb755873vbalkzZo1a9b+A1uRcNOVwbaj4IWjoeoKf/KfAHFUMIcgorPO7/cWyN7mNTz4pDUYiChjvQOj+UIakMSfFHx7GGQqeISBXyMfXjLFHU+Ic/ET8UoWGOJRYUCWRXgdg36NgWAWNKyZsYYaAXIkn87MDO4v8hkEBn3WOMd0eAXnjh0Ji95h5YKr4FMKgb9RVgsBYm6OQcvSH/19jWl4jGs7pqz1xjAe/LERCFPweUWG44VlxRP++Tj406tnMxaskqbU90Zen6uC28iRWVfxKe9dtf8vaAh8QB1ZagKJB+MTvWWSr5vxq41LpCm47x4CuUVgXAETxYOR/K7Jjgzm64TGisK5L2x367Lhj4T3PRG9hBvfSWUNP4Q/hOM3OF82z4gZyq4mvlCUzC9hwJ/lGh9r5lL1IgFBjjxoI3jkJ0zwke4aXw1uGJlPuVlcQW2B/PKDrsAgCQHf/Ch1Pe7QfwomokrLl5VdGEia30xGc4w69P28WZkirlAJt1ZlozGdgolyccfV4R38+AcRNYXYz/OAIZnoXHlJ1KgxtghIyopS/zAHmPxVRYDox4j6S6ObsjZrzfPtnMTS/pxbs2bNWmKnQQzYaVVlLa4AAAAASUVORK5CYII=");
        map.put(5, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABsklEQVR42mNgGAWjYBSMglEwCogHyZ5N1iBMSF2md7tgqmfTJ2QcGtrARlXHAA39AcKE1GU7twnTxDFpXo1dQMN2pHo17QbSf8AYxCYHA80BmUeWQ1I8GiOBBvwHGtQMZCdTikHmgMwDmUt6tHg0ZQE176dyVO9N82icQp5jvJq24A09z8ZwoAULgXgdiAbxGxoamHCaCTSP6o7J8GmRTvNsOgd0wLs0r6bFqZ6NHVBHvQTiSyB56jvGs+kpEC/Hgh+CEiQoG4PUwkIjy6GBB6hvA1Qem76nlDjmPw58LcGhgSPFvckWyL4FEgOG1A0gbd/g0MACpK/g0kt1xwANjE9zb5WEliPIcp9S/FrFQfJ0c0yyV4s8POujYZA4SJ5+IePWoAHNSdgsC012r1ehm2NSPJvScj0b+ID0czS5lyBxYK7JoJtjQLkFlJOSvBuUUr2aV4GzNJAGhQi0onxIT8eAcs+5dM8GLZS6DBh9wFC5gFcfWY7BE9Qo2KPxKJBeA6UJqk/zbK4l2TEgXwM1fyDKQcTjD+ihSXzNDSwzUjyavaiGgeaNNlNHwSgYBaNgMAIAV6V69GaFKoMAAAAASUVORK5CYII=");
        map.put(6, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACCklEQVR42u1WPUsDQRANYmEhgoiI2Fn4B8TdEwwc7p6ipgqI/0AsRMTGStRCsAgi6USCldiIiL0ECaKCJJeIkM5SJK0ECUKct3fBJHDqJas2O7BsdjPzeDc7X5GIESNGjBhplAfBB1zHWnclP3UFu3AdfkK/Fx9tu7teD2fcq/+hB32yu58eHdRCxJVsmdYbAVfqiGRoVWk9Z6UllZ7Dp3D27zN1hCqwz0m+2haRvGSbPvjB7QzvaSAp2Ajd39B6dwXfULvDrnFfrwe7nGCHwAFea0QEi3pE2G6QzpNtdykC0KMd5yDdnLB2FCHCDU0mJ/gVGRe/00vbdieeCPv3T86LtNKhiPiBWHWFtaYzEYAH3OYn/9orDp+FUS04dQnwgAv8MF+wAKPC3ESvTjLwiEeGzYcm01xH/oVM7ZkoTWN6Y4bFQj+TyhAqVpRR+1rJSGsPuD/JvKav4Edk+JqdifZraymEhwIY2rggx4bJuEzxc6aDTF7yc7QF4LboVmp6Knb4tpa24rCldhtlsp2+8tnfWFJTFvCE3zBT1a1IR4gkSPmeTUT0pqVXyjEeIBh/EKxqzGh7dAgk5M0sJVovlKbxgPSNe//zku52EvTVaS+OrOM7wfpwjx1n33tpd3J86M9G0bywVlA3lBe84QreKOP+X2ZjVYsEv6x5o+UaolN0N1QjRowY+S35AOy7P6FBJhMXAAAAAElFTkSuQmCC");
        map.put(7, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACNklEQVR42u1XPUgDMRQuIg4igoiDgwgODgoiFHGwveR0EyfBwcHdwUHcxMEWcXFyUKFN7kRUBCcHcRFxcChCEbm71oKDiLg7iEgR6nu5nIj41+SKg/fgEcjl5X15+d7Lu1gskkgiieRnOU3R+j9zXsjSfs8iGY+TG5eTF9CKGBlxQJeLfLiz5iDymXgjOGXSOWoOnG+JORgdTjw5X3aZsVAzIM5GokU4B2cQkX3HTnR9uo6Z8WAd6F5twFjkRACx6Oxv1sNaywdEV0MF4lp0WmVjjxsH4gBZMhAeGE5uQe8K+70N1dgVM8l2nz/kOJzMsc1ByZO0ij3YbWKmXe8MNocRlSkE4zBjVAkMI5M69h9PlsbNLuxkmxLxAYQAw8lEGJHZxjBXy5c3+ywdCwWMJOAzprVuJjq2SXSjcurftxnXrE/lSipWpw6EkRVRWzTKOtYXv1CSjHahc7ixpGqPhJcP6aNrGx3qpR/IVlinTcoHAecAoiiiAqmtyxXc6KxaQBgNsJsHffAziM5o8MQYh03OL7OJbhhLPwHCDIGr2AU9gmjev2stStrZI9uEPOp3gPwIGIdB74LcQEDipYa6opU5wSmxOZIgcl8BwrkgCo5F1/AA4beS4EzWlVLBTvZ8BUi8NYw84ZXWrq9FAJAFWKQw7J8Bgm9zuFb7Gn7TZPvES3Rh/yF6GJbsCwCpvk0arSVdw6ggIEnIu6utkVbXMhb/5DfE4+YQlnH8Fwrl2Y8kkkj+o7wCSuq8Q+udHiMAAAAASUVORK5CYII=");
        map.put(8, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABh0lEQVR42mNgGAWjYBSMglEwhMHH6GLT/w4NLAPqiE9xlcIfY0oXAvH/DzGll97FlegNiEM+RJeGAx3xEoj/fIgt7QHSd0Hsj7Gljf8bGpjo4ohvcYXSQEs3gULjU0zp/k+RxRog8WdpDVxAsQmwUHofVWpA29CILcsAWvYBGiKRWKMuutQaFkpAx7ZSPS19jKlQ+RBTdhDkayCe9iGqQhCfeuRQ+hhdeuVDVLExtUKjEmjoDyC+QWrQUy2UPseW6HyKKbkA9d2U/wkNHOSYgxJKMaXXSA4lYO4IBeeMmNLnH+JKXEBi5GZbmD5oKD2FmhtJQvlRYgkKDVA5AinUSncDc8hs8tJb2XKg5YtB7LfRuXyg6AKZT0ECLv1BoWN+UDE3YXfMq9AGHlAhBwpFIG4G+XzAHAO0KBqaMKG4LHrgHBNbFoviGCB/1DGjjoGWM1eABv4C4k/IGOjAb8iOgfI/oeFfIP3Uq62jKpSAhdVMaEOKVDztfVSx/Gh7eBSMglEwCgYzAAAqcqP7SzlELwAAAABJRU5ErkJggg==");
        map.put(9, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABoklEQVR42u2Wv0vDUBDHg4iIoEiTILhYRKTy3sPByU1BRESKi4h0dBEHEZfilinmvYpDcQmODt38H/qndBARoYMEERe9yy+CS3r5sb0vHO1wd/3kfqWGoaWlpaWlRVOjv7ZgSnFsK36aZ+iH/rWAWJLtWpKPwX4JNjZ7Yq9aEofNQOIPS4pXS7EzW4nDPEM/iHlDIIyvjMVW7ACf1Jb8nFZNfhHGQXwFFdmZbvTENrSojUlxDijh6B+1i7UxD+YrOiMI8JmdgeIwqQXQwhPy1kDgF9gIoK6jz1IwI2jxVZzne95tmZPDKL4f/3g3TtotAwPVeMzmIc3QsrM1hyXF7Vm831gxJbsMYTzeh0r58P0p35gf+UcwS3diNd6ugHx/TMlvQwC4EwlMUUMYzBMPs08e4LQaGRjb4y9Npzk7aXXR/z9M0rLSMJbiR6SNBP/aYPCy0o4lXOLaKiP5EGxAsGHlMJYnbiobYE880GHS6ccV5z+4loZjTFFfJxD3HscHycMVfCWITrgRij+brmgVyuFurmN8tFmio/8VamlpaWnl6A/lzGRDOrNSlAAAAABJRU5ErkJggg==");
        map.put(10, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACIElEQVR42u2Xv0sdQRDHRVKISEAkBGLy7s73CBIt0qYIMU3AX3e7ysNKoqSxShFsgsXNnk8jkkpEEBEREcEipBIhiFgGQv6DIBYWkk5ERATznb0fPvBH5XoGdmC4vb3H28/NfGd2r6bGmjVr1i7bk16q90T47l7AeEINljrpYb5ARLXNcrKpENALV6g5r6/iFLq/NOYWEUCcwE/h5/Aj+JkXRK/5+dOeSjNHzA3UQKk8+cgsTKBm3X5q9XzyAXHcVqYGV0YjgBnl5xh/dCT1eVKVXRFtGYXhaDhCzbiCFvVYRp9w3YDv83MnUNOI3i9Xqh38ZskwDC1isa+cFnZE4o0joh+OVGNVwOsa1FdvjcJwCrDQb1fScuZC7QLyZQYj1RTDmBE2Kog1ovUS0Jr2CwHvpXOOoHHcf4/nafXWOYqS2vHnm5wSaOUvL1T0wxILl93zJx6jcoYTMPYDgKmODnpgQrB/EPb3OkUJjK6gIarD2wsI+BVfE5B1Y/oo9FNL+rYtMnyewsQCjbbjyqKVdMypMt3g4vBDqFUwV7tJGNYK/LMnaUKnJE8Y7h0A+MC9RPcUrpy8YNJqyuDQxG6EMVHO1+9LOjrniXDH4/toK5k75grLBYbFrXUVN0CeO7zb44OF+R9geFu4NzA4PixUlXKYNMafaTUVg8qzu4uMoPnsCIGdOT35ZeUehF25fSjw5onUfcsch3D7RWnNmrXE/gH7gm7wvArdGAAAAABJRU5ErkJggg==");
        map.put(11, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAAAk0lEQVR42u2WOwqAMBBEPYA3EA9m7THWwpOIprQQEVvRPY8glmKjG9BaDJsiMA9emWES8osiAAAAIBBoqTPieiA2o56SJ7n/y3CzEVdpObexljQ1ic11KbN6WXGXXBl0iJcHD5RRLGP2gk2urc0NfgOjDMqEXMbhCPrKlRl04vlcflravN5pFpov9is+ZwAAAD64AX66+XwnHfl/AAAAAElFTkSuQmCC");
        map.put(12, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAADFklEQVR42u1XQWgTQRQtIiIigoiIiAgiIp68iIgIESHZ2dQShCJFRGuym6oovRYPnZlNqvQg4kHwWEQED0VEihcJIt4leBKkeBCRQpFSRIJQ/5uZxM1m1ibbBBT2w2eYnfn/v/n/z/+zQ0MppZRSSv8Ycc43eU4w4jE5R1wn/kHcMCPmcz4LCtg3UCCeKy6Rsc/EayUmv3pu8KzExEMyfhujntN3Wlf7aH/fQfjn+DYY0kbEWz8vzoTXr+b5wbb9tI59BtT89Qzf3hcgUOQ54p0KhSsnoutlR56EUd+VJ6Jr5CVfyZF8XwCRsgXin2U3cDqM5eRpMvjEgHkc9ZgCS3KQh54NASFDk8qQIy53JrF8bsIQ5VdXMnxr+4HERZNnk8nDw+R3GLV4S7SSlIkHCjCTj/4kr7hrkZmHvkThankly49Y1pRRhKXkBK46NUY3GDbAPnVcAtKT2DskWEPixaz9guKiWzkQBsMzfHPJEcW4K20uQq33wka3gE5YjQFTV+Fw5Utl3IBZt0SQPujtCcxNxndol4oL1hAab4SZDL2g4pf9a+gdMYa91/J3dnYNpsjkKW0gKMTt0fWlVdjC/NFz+TG7Z4KCOiSVhO7BUC4Y159fN7d0nwKI18SrzVtm603Qp8M7fbhrMKOjfIuuL/JWdG2czezGCeG9cMgwlhk/2kxu2+mhD2s9N1HlbiafxlRUnH4pCsbILWJuq9jQB71JOvQ9lHE0yfD3G2dndjXzo5ibPhQG4+eqe81zYq00Ut3T0WzVM0Pc771TmyJFhWwqpl8B0Bf0JL1Pga83O3Xn4YIp5TEKZdLehCa4Cg9E84au/ZuY3rQQvbqQp+8reIYkb5TkalLyjfiDrTZQ3zruu2JWd20xazs15CAPPdHQ9UzmvbKCEIxnK/vjCqAtYSeGK/uoSr9X3jW3b8NkAC0RL6P8t7UO3Y/GotfVtIllyEG+r09PeMUUNlXUVHio4CHR8SxQCY+5Dtui2VezebN/72G8b/XDqhGTwA2s2159A/1lQR6gxKOhYsR84L8oKaWU0v9GvwHhairwQ1LFVAAAAABJRU5ErkJggg==");
        map.put(13, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABnElEQVR42mNgGAWjYBSMAlRw0tlM+Lyrudd5Z7MAEA3i090RIIsvuJgfB+L/WPDxC85mPnRxCNCyuTgcgY7n/m9gYKKdQ1zNlxPpEAgGqqdN1DibZ2Gx8MtFF4tVwDQzG0gvBfI/oKsB6aOqQ66GarMBDX6NZtEO9AR7ydtG8KKL+QY0da9B+qkXPc4W4cgWAC28dt/BgQObWlA6ueBidg7FQUD91IsiF7NpaL5NJMXxQDyTao4BpQtUn5o74lN/xt1YkmYJGcMxruZu+NRfcrPUoJljgAY2o6YZs3oC0VSEmqMsWqnmmHOulvZoaeDTJRdTJTxR9JKUaCUndJ6jOeglqE5CKxTdgPgxmrqn1C99nc0bcZS0X4D4FpTGJt9MdcdAg/8XSdUBUP1lZ3NxGlWSFn2kOcaij6btF1DiJdIxn2jevrngalFOXI1tUU7z9gyo7gHVTfgcApKnaVuGQLmDgkHydG164mnxzaV7OxjUdgEVaOgFHEh8QHoH6NFF9+jBqNGdzSvBiRZID4r+E6iWHu1FjoJRMApwAADSgBVIhPZWogAAAABJRU5ErkJggg==");
        map.put(14, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABu0lEQVR42u1XsUoDQRANFiJib2VjJVpaiGh29tBC/AGxEAshiFjZWNgI9mKhRdjdE5Eg5AsEsUxn497FQpAgQfwBkRRC3NFkvZw5zd6tAWEfvCJzM7NvZ29nLrmcg4ODg8PvaO7nBqrlqcE40d53MZLDYcChGSfa+yNAwKzk5EAKeqwWvusmBu34HP1C7s39lZCdhMV/pBK1a1UIvgsq8UtrgcdA0M2AkZVE4nP0Q38GrxhvTUwgyIbeqU8Xe4kJBXi6QireohioYNKQQ80ojsPDpxio2DkiPz+pd8jInpEY5a8rWqQT2avC6VEr4Vvgk7FuvSWJ6P8Rl/XKV31vRpfZEvGYsT0Yd1e1kyebQiJ8NqvKCR2J7KaMN0gyKKjfDcOFGxiH8Zinbcf8qcTUTulQ5HacG4lhcNaOxTyZxUh/fvzrdsCVkRhBLnUHV3kyi1G8l5xuqzKXUr60JcUtzGNDjHX+XzGIWwZ5nLgdE1jANdp7JfrHJzjaU32ASUaW4+dvOJsuOirC6VLqLnxTnB5WSepaDINVQzFrETF14+P5PuwWRkNO1qXvQaqPMhWH8ZjH/XNwcHBwiOAdWl0ypWJSc1wAAAAASUVORK5CYII=");
        map.put(15, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAAB/klEQVR42mNgGAWjYBSMgmECxLq0rYU7dQMG3CEiXTrTRDp1/oNxh27RwDmkU3sm3CFgx+iUUG5qAwMTupBUgzGXaIfOOuEOnUnYtIDEkR0i3Kl9n7dNQ5hsN4h26YQDDfoAxH+A+JZIl/ZSYNznAH3sKNKluxdq0WEsDpmA7hCRVk1J8hNdt44e1BH/8eIu7Q2iXbqhQr06suCo6dDtQ1NziyKHgIBEm6Eo0KAbBB2Dij+h8W+IteqIUycFAtOKSKduNNDQayQ6CoSvgTxEoyyqaw+KEqKiDoQpjRpigECPpjzQsi4gfo3PMcB05EW/QqRBmw1/9OnW0rFAA4cOzpABZu81op06eaKd2h20LlkL0Cx/h8dhLxkaHFhoVdf4oEXHFVBixVEMfBDu1jKnSRUg1KOthVaWHORv1xXEEVrAAlE3jWJ3CHXpuAEN+wHE34CWbAOlD+FOnSAgfRdhkc5iUCKGVx0N2jxA8S9oDppNsWMEu/V0gJbtx5kOcDQFMOsknaNUSx+gaIFagBQ12jNxqRdu09VAc/gvbNFNaTZeBcoVUAtWESip96KEDlUSMLolwIYR1ILnBLK9I4pj2rVNqe4YaC3+C2QBoQoQlMtgzQuaFXbAlt1CSL2jZ4s3rQHbNsDSt5rq6QUZiLfrKgErwCmj/Z1RMApGwVAEAPVhgCKvix/xAAAAAElFTkSuQmCC");
        map.put(16, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACtElEQVR42u1XPWgVQRB+iIiFjYiIhSgS5N3tXiEiFiJaWIiI2AQR8edu7z3QIkgQRESM2IhVijQWFkEkIGIRgo2IpQhWIpImpNDn8+6SIJJCwsFzvnlzyVXRd7si6C0Mw97OzH17+83MXqNRj3rU438fvWG1KWvpU2msb6WxmkyNmiZ5kcX6JTTP8ZzWYdcbO7bROYgsDI7Ki1dIeiQ5yTzJTBr7z0k/Ez0jz3OxW+HnsX/EGsT85T2bU6OfSuBPJPcSow73xhob1v2CtA472Isf/KcQrzKY1PjjHIg++68ArAeM4tzkOJGasACjfoADLo46idRDxLMBY7ebMu9i/wHi2YEhEmaxOmcDhI5pmL+yAzBL0ETIt2mkTTfcv/13fD9fbG6jTbQpAd6U41gekzYsRs1KUEinn7JqkrlAR8maawyneKdkO1uKYQ9m7dyDA5RZI0hTKXTY7bIcAfQSgXrF65G6BvvVWC7AZJF/p7J/rM/SV0s4m4y+7oIz3cVQ76qUQW1vJ9oC/IviZwWGiWvUd9J3vxhv9yD+sIcf/EneOeHMQksdFC5QNVbvpRmOIGX7jdM7yRopjOe0nhn1gTdDfl9D/5BzAiex3oGaI9UUjfOj7LoQZNw01tmO7Is28tcJTL7nwTmnBE6iYK8NgcEdJwRmjvRryH3ixNCAbWBIrhHLBYfsKzBdjlYJTLzIjP+YjmAUdYSK22kmMGvM/VGsC59g/xr+/xyBcwcEziTWDcSzAMMdtzsoV8oEJv8TQuAO4lUGsxgqH70FjRCXo4V20BwITKu5r098ToAM8exuaLQ74Uhx45+jEv+EOHGbeWG8M4VgjvuuEHhu7U/Cf4Q4zn5Xvl0JtlLhugAg8qK8dGcpSy7rUySX4Pfnf+hw67+qtvT7lnccGvOqfxH1qEc9XI6fbDyAhqkoZ3AAAAAASUVORK5CYII=");
        map.put(17, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAAB90lEQVR42mNgGAWjYBSMglEwREGqZ5N9ikfT7ETPNtEBdUiaR1Me0DH/QTjNszkARQ7IB4r/SvVsnJTt3CZMW4d4NlfDHILVMd6NjkDxl1D5l8meTdY0iprmcmSHYHMMCGQ5NPCAQgaq5luqR5MpdR3i1VyJ7hBkx6T5NnAB+WeAjuhIcGjgAOvxaMqCqrsPciDJljY4NLCEhjawIWOgBROwOQTZMUneDUpA/ieo+BlYwk71apoPFvNqaiYxYTaG4rKUkGNAINO7XRAotg4qtwMklujWIgtk/wHidw0NDUykOGYKJY4BhyzQQqD4FZBcukeTJbQYADuQpMRMDcdAzYmHRE1jHyQHNuWA+ClejYl0d0yqe7MLVH45iJ/i0RgJVgs0n/4hAyn4QIl2PnJIpXg2FdA/ZLyatiDLwXOUR7MfKaVrLaWOQSqPriGVP6As/wtUTBDtGJBiUPZO8WwMh2NIfN8i5BhQPQQp9MDin1K8m4wh6aW5Hiq2kCqlL7j88Gg8ircEdm+VBBf9QAelezZogcRAWRtSaTZ9SXavV6FadQCtbw7jiyZQ6Q1jA0MkCFEiN0ZTvaLE5iD0NJPs1SIPFN8LVwOsn2jWhIA4CGEZRgJGVI7XaNZ8QE/o0Oz6C715AIoqoAPdSKqHRsEoGAWjYBQMEAAA6BMmyGoSrl4AAAAASUVORK5CYII=");
        map.put(18, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAAAtklEQVR42mNgGAWjYLgD4T59aeEOnVbRLt0ppGKQPpB+qjlGtFPnuEinzn8K8EmqOQZo2CeRTt1zol064aRikD6Qfio7RmcLmXq3jDpm1DGjjhl1zKhjRh0z6phRx4w6ZtQxo46h3DF/gPgHGfgPLRyDtU8E6qhJNRhzgWg8/Sb6OEa4TVcDpEa8XVeJXo55jDNkOnTWAUPFC0TjdozuU+o5pks7EuqgT6Rj3acg/aMjFqNg2AMAqK1ekZZv90YAAAAASUVORK5CYII=");
        map.put(19, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABuUlEQVR42u1WQSsFURR+SZJkI0kWSpL0FspCklCSJNm89ObeGV5KEsKbO71nNXaysJBsrCyk/AC/QpYW9ijFm7mD7TjfzFhYvLz3XEXdr0537p1zTt893znTpFIaGhoaGhoa1eE1u9vum861z4VUb84N8ldMRnInR4Ghx8WpakNe5K+cjGkvI+g3qh6Rofw1kQldt46ez974VgethyXDmfBMZzXxmZbc3pfZfB98wiW3kWS4eLe2O2l/4hn5Qd+0N+mMKSUT5IptHrcPpGUP471kzqLHxJRvij1p7fRCgjDjNtD+PO45cVQyxAARWSe/BSVk/pRMUXWi8gsZ31TcUgPO+0wco1I+c9bo9leSiRF6d5/4vvi80EPrHaqnlEwyYXPhuFsPmSBZwPL9nlHohiToDZDwLHsy8mViNo4Ro89so0UZGWkVW0tGvgtEAtNO4ywwxRj1xExZo8aO/ew04hCPPD8mg0akG15G0nDxmJQ//M5QJciGiiIek6hkmnC76PlzJUmeMm5zOXtYcZu++NOKPD8iA81VW9Vk6EM1VIkUtRqGoKrvAaYFfaLakFf/imhoaGho/Bd8AAeeccpmxO2NAAAAAElFTkSuQmCC");
        map.put(20, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABEUlEQVR42mNgGAWjYBSMglEwCkbBKBgFDCedzYQvupnoDIjF513Mpp1zsXCBiV10Mau/4Gw+BcQ+72rudcHFbBJIHc0c8b+BgemCq0X5BRfzDxdczR9fcrPUgMkBLT8HdIwj2GHAEAKqeQrE7y46W+SB9FHdMeddzBcCLfgPCoGrodpsMPFLLqZKQPHXyGrP+BpzAcVmgtW7mM+lvmNcTQ3AIeBi/ueCi0XfCU9zPqgjC847m82GqQOJA9V1ANX9AobglXPOZpY0i66LzmbJQIueg9IGJIrM9wMtdYPJg9ISKKSADsqhSRShg6sODjxn3I0lQZaBEjOypSDxS942gqNlzCgYBaNgFIyCUTAKRiIAAGixaIfFhqBpAAAAAElFTkSuQmCC");
        map.put(21, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACSElEQVR42u1WMUtcQRC+wkpECJJKxCaEIJImhc3d28U0IiI2wcrCNv8gBIkgQkghFhrw3t7BgXJNEDmCraQINhIu73kmkMJC5JB0IUgQQeebnbvcex53eZcTEXZg2bc7s7OzM9/MvFTKkSNHjhw5uie0t6h7AuMthUZVQ1+dh8b7EOa9oUaZMKuniF+m8YdnWjfyy4XxQT7H51nPMvQmNubQqC1ScBXm1GdS+JG+LwOjTr8Vng+AX8l508I/4wtxGa2xD37wPv0A8jhHo0RjH3zoTWRIsKGf8EVGr9b3jHrBe773mr1iPVL9ks88xBqzGFQW/ivIB0bP1HXk9BobnM+M/LsxpIAV+d5kJCxsjCrIN0JTjPGL2OdvkoN8RC/pixvYlr4aPSoXv4sravDMEY2Tyrruw/rH5lg/1nQmsPJqIf6gQ6PfJvaMvYxxQDH2dviVBMJGzJBRszaU6jsNX2YYOws+5Cye1G/xUkkeuN1RNsEzrMwCb/fIjA/HwjJH+8fCxzwXyaZs+jHt7YkR58Dgwcaz3o5TXHDwqy2+WuCgGb66boxkkC/h8muZ1UTHReKUbv5ytcI1hupGtA7pR4IJCYGtOQhNxBAqlNZzauX/PeNnntYwg4z5awwBm4ysGD3BRZBmrLEf89ynjjKoRTV+KaFANf0p40ZmYC1yNZlLm95qvqu9ynpIrwqGilxtqVXEsLEvVZhlEBrUrFtvpGHOe1MDrvQpC2Tav5OuXm+mMrDuqCt3iwBM1Bg0V/fj5ciRI0eOukDX3+rq7vaJjlAAAAAASUVORK5CYII=");
        map.put(22, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACLklEQVR42u1XzysFURSWJAspSZKdJEnyDyjKQlZS0ntz70RKEuXHvdd7bEY2koUsbCQLC2VlIdlYSkqSJNlJEuWZGT+S1DhnDF6aMTPPxMI9dZqaOffc75z7fec2WVnSpEmTJi283cZ5nUF5i0F4s9Wg5fwJCJ2KJAC4ArfAn8BfwJ8NhS/dx8ZKfgWE1a7lGkRs2EAU0XfdruXb7zUt+zYuGg3CtvHbHWU1kW9+15Us1imfMRS2CVWvmYRvwWan+N67a3wRYs5ulIGCyIA8kMFSSHphEnagK2wcnlN21cpI9bfdgy7phB8ClyYiAwNdWMWOYPKPquOJwiBrDSoorD+PhqDxRLlNSFDKD9Zb+PwRECBovw2EiH0zNlKVSQ4kNuTYQZXpRIxmBgTai1LVFd4RzVGLVuDPIyovA9nyFMyQHt9N1OFKW96Uz/nGUtYNsabVqeUFn6ZUtCGYwEDeBh76rJ+6EAx2KXhL7QrEekAgxw7Bdx1A8z48XAcwXeH4ovAjr++P6lCZA+QEhx5yCwsACTNbOYRNe6oL5w7hseCdeava8hpqDoDl9+n7Dsa5q3rRXddBPsyL+cPKegUnrqkmi/xjP8F4F5gswnyYN7QU8T6B49rDawDnja6yJjiG+nR3A2OQREV6DK5z5tUF8irjewoliPcKJLpMU8yHu4EBTiy4xF4CBydDSdoPGE7TdHcD8zUuMgDB+eXPmf8JBudKSmW18k9AmjRp0kLYK8j0rdnnshLHAAAAAElFTkSuQmCC");
        map.put(23, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACQUlEQVR42mNgGAWjYBQMIiDcrm06KBwi2qmTJ9Kp8x9ED7xjunSngB0DpEe2Y8RadcSFO3UqRTp0+7A5RrhDt1mkU7cWpI52rmjQZoNYpPMLZDkIKzQocKA4psGBBcj+A5X/AXIUQwMDE1XdIdKqKQk0+BzMEaIdOguFu7XMsYYMUFykS3spTC0QH5ZoMxSlikNABgl3at+HGnxXpF3XmJg0I9itpwMUvwaSA0brJf52XUHKQ6VLZz/EIbrneNs0hElJwKIN2jxAhxwF6+/S3kChQ3TToCHyEleCBCVksO87dCZgkwd5ACj/EOqgSDITLAMT0IDH0GAOwqVMqFdHVqRTeyaIxhO6PlBPPSQrQSMZcIEqmaBL5wzIPKEuHTfSNXfqzAY7pkO3iCqO6dQugHhOeybZCVe0S8+WGo4R6ta1hKQb3b3khMw7WMFGDceAzIFG+ztyHPMJpBlU8lKrBIc65hM5jrkBzkl9+tJUafMAzYE65gbpmjt01hDK1iSZBzQHWh6tIbvRJNyhPZ8qjunQmUt2IwxSOYJr4F8gNuUVLbi2/0N2tMPKGrKCFluUA0OHohobVC9BK8paMtvI1YTqN1JKTkdYgwros1YSQ6QV6pA/IHOo07jq1PaDtNzABp+ENaxwOgLUwAKqg6r/JtypG0D1vhG4cQVtwYEaTMAqYxqQjhXt0gkH0VD+JaRW3l3a9alA7eBO3XJY0wIPfgxqtFOt9CYYUsCoACbOZFAtDGoTg2kgn1AUjoJRMAroAQCETzL2HAkL1QAAAABJRU5ErkJggg==");
        map.put(24, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABw0lEQVR42mNgGAWjYBSMgkEOPmTqCr5K0bIF0QPigJfJ2tavknVWvUrR/vYqWfs/Ev4BdNi6l0maLvQJBZAjIBb/AeJNQNz8KkknGeiI1tfJ2huA/F9Q+U3PEw1FaeIQkMFAC65BLZr/Ok1TEpe6l0naM6Hq7uNSRzb438DABAyR4yALXqdopxGjB6guEuqgC/8bHFiomEZ0SqAGN5Oi73WSVhHUA7XUC5Uk7ZdAQ2+B2KTqBybyS0C9r8nRiwJeJGvqAKPnINh3SdoFZOa8LGioHn6domtMlkPepGqbAg34As+2KTrh5JgD0oeU9X8BPeVIRoLVvotShlDHMeAcRlKUvU7UtUczgJqO+U9S6GAzgJqOIcmsl8maATQOGT/i00yoNhtQ0ycaOeY1yHzSDEnWjqeFY0AlM1nZG1wBwkKITMfAqwVgwUm2Q2DgWZoxFygNPUvWlCer0EvS3vsqWSuH4hKYUvA6VccHVPIOeAvwdaqGGrAqeAgMFRW6WvwmTVfjZYpOEKypAKqDwJUrmemM/BAANp6Qmp9rgOyFoOwLDJHQAYkOpKx7AVRLD1jjHFomeQBxB83avKNgFIyCUUAlAACIKYVf7c4ZBAAAAABJRU5ErkJggg==");
        map.put(25, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACmElEQVR42u1WTWjUQBQuIuJBBBERT4KIB+lNRESEFcVNJlKKUEREtO5m139EhB47M3ErSCki4tWDSG9FRHqR4lEKRTwsIgUPIiJSkFJKKUuhfm/yJg7L6iG7jQjz4JFkEub9fN/7Jn193rx58+btP7FqqM7FoZ6rDjR24348DtW7W6Hc/o+S0XeQzHot1O9xXSOXUm6SJbm5sCTiQB9G4KlY6DeUDHwRvgxvIbFPuC5dL8ltRXWkxkmsI6FntEYdwfNbXvtQKzf2FAeRUMMUuBokwq6hKzdprRLqY4UlUhP6CEOTdYaISx2xHauW9fFiOCNGDyDgCnyagxNfVg2ZA/UEML4YGpJb6Nt6KA9ifQFd+7yxUEX6ECfzDd5MJysZJL5g1J+akQ/UedutK5HcV4lkP8lAzyaOyEqVm6qFmoVfpCCo/lWlPLofgec5gQUXOib4WnqvHvcGplBPchdOd+aUeugk0NHrIgnykzbQt7HJD0zPWRY5bJqMEEcMTOCR/ZbgsBxC1yZIcyri/l506TWvzV4uya3ddGPm79WqC0zsZWe96e5hJi6DyfjHXMmYyqCw6WbJSBwkA840TRtCY5zdBIlDHYpacb5ZytOVuawitD0jMiaCoOONKcg9PjwVw9QikrcdrPTtvIG9nJzKk8yiI/932941HageGW0BOd3qIZLPzVn2e+3ncDi2KxdE16IHO2KRnOFqvxBBU/HTV3nzGToCrHbg+asT2OVIK1No6FAXqquTNtK2nPtVFw5DZupIoC7xFKYcitQJ8KhB+kO61M1vw0tH7r9zgMlM1EDodmE0PMFBapOxR4R9l191AQEdkAzDlJV+2tiu/0mtiaj1QB/dsJ8rmowbJ8d2+p9vb968eeuB/QJw4e2Ng7xQnQAAAABJRU5ErkJggg==");
        map.put(26, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACAElEQVR42mNgGAWjYBSMglFAGAi3a5sKd+rmCHfozBXt0Fko0qkzG8QX7dI2oJsjRLt0woEW3wDi/1D8BYhfQ2mwmHCnziUgDqKqxQoNChwMDQ4sYEc0aPOIdGlvgFioe064UzseJIasnr9dV1C0UzcRqOYCSB0wxNahqyEbiHRq+4EMBkWJaKfOcSD7FxBnEKdXJwOIfwDxSZAjqRAluqFI0fEH6DhHkjzTpWsP1PcNSO+lQsjoRiM5BoQPC/XqyJKRxv4TG6K4DYLEP7JjHgNzTADJnurQ2Q3Sy9DAwER+yHTolEAd8Q7EZmjQZiOrGOjWdQGZI9Sl40aBY7QbQZjiHAEMEWDuuw/MBNWjJfTwBkLdupag7E0Ns3jbNISFu7XMKS5nRNu1VMguHkDVSKduLbTumk22Y0DFOLQK6CE9B2mzQYuG1/AKtENnAmVNhQ6dSWAHtemrkVFg/kEuNEFiFMc10KCXQHyN1AoPWLd5oZTgXdqRFCc+sS5ta3CF16l7hdi6CaQO1K4B6vsExKug7RzqtHFANTa4WujU+SDSoVsEbuvgSiud2gVQta9BORIWSoLdejrUy+pA3wIt2AIN9l8iXTqbgBbPBFo0BcieBkxfa6BtGKC89jZSa3jyQqld1xiUM0AtPoTlIBrYAgQleKD8aCk9CkbBKBgFBAAAVBfgESM3OQoAAAAASUVORK5CYII=");
        map.put(27, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACqElEQVR42u1WMYjUUBA9RETERkRExMZCRMRGxELERkSsRBARERFBLEQsLC75WVwQGysRGws3+X89hUW2ELG5W5L8IIcgh4g21xxiIcuBHIuIyML5XjanMZvkNriKxR8Yls3/2XnzZt7MTkwYM2bMmDFjo5vlu7uFlrdFKDvwzyJUS/h8ZYfe/VqkDv4TEHW/tRFBH8L78LYI1HknVCfo+H5GBJ6Lz2/wF6Ijt/89NnRjiwjkO/gbMlN0z9bNbWDqOQB1Lf1oz/gZWa6vwY/PCq18svNb4MA7S1Ymo6lN6XfIoBPKD0yC9+qvH2wYCxgRejfsUH5MB8Szcwj4Hb48cLVkaXUkA2ju13nsPfaVPfN465+w0nUC72ImUA8+b/tqr6W9Q/F3lDB9pxa4B9hDZIeJoMdOo/EjPFu0gubh6r2Cl8gAQaWfO4G844TesZ/gtJwmoCFW0WfZRMDyTd61IrmrWomgGEq4uGHlPjtUIilDO3sOpUn6cOmhSvRgNTCDedIu7ifZTYB0WI4hsOgRMPMkX3WyX6bMHGa8a2jWZyVgequApaqmCs5eUggjg3F08yRe+lISbIHDruS8g1LWCs7aKOGl0dWE+cAGdnx5NH8q+2vp+cEaO1iKWuTtL2iBafZkpb5BZvc4M3LPqIyCH0zWw2yuSmfkZiZJAVQCAypP4cWvWXknVH9Chq3hrNUVzhjOoXzW1C0u18qzBtnfXWlSAkqDqvvu+myZOLGpMCZRMtUvF7G9yjqIx/pcMj25AuaR+fW0LAf9wQDqbSL1Be6sNPDJqLGTUo8XLmYM72V32ghgGEA9ZcbxRNbyKkd/Zu/EANhDDEAFxSUcgF9MRkA/2egXKPeVdTKebf6+tY7LkUorypDB4v88vns8vfGNGTNmzNj/aj8AjG0Gts46WNUAAAAASUVORK5CYII=");
        map.put(28, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACbklEQVR42mNgGAWjYBSMglGAAK+ytHlep2lKUmLG/wYHFqo45nWy9oaXydoPX6boiJOj/3mioeirZO0LQNxBWaikaCUCDfkPdNAVUAiRY8aHTF1BoBl3QeYAzbMlM2gZmEAhAjLkRbKmDtyByVpzkfnYwMskTZdXKZpeMP6bVG1TkDlA806SFz1J2o5g3yRrb4FbkqxTAhWbjTdEk7VvAPG7J3EawnDzUnR2g/WmahuQHkXJ2s3QoE2EhRSQ//pVivY3FEuStP1epehMQrYELAYJiUaMKE/SLiDZMUCDloINTNJxA/FfJGqZQ0JFZxWSgz2gIQXCP4BRqILk8D9AfA5DbYr2QnJCZg3EMZouEJ9peqFHEdC3rUiOAfnaD0n/FyD+hJKOIOrWkJGTtBdCfAJJiG/i9KWh0bYOYYGu0qsk7ZdQH1+C5TgQDbX4AnrIgEKc9AScop0GMVCrEslAUHnx622ijixKoZioaw+KGiwJvQPhcJ0McOilaNeS7JhnyZry6L6DBfXrFK0ufKUtUM0HUG5CLiiBae0guJgApj3yCr1k7W1Q30Qi+dANFgogi4H8HmBUTUEJQWDhBkv4aOnlAtkl8NtEbS1orngHSh9YHIucm/68jVbhw4huYL0GlHsO9hQwOimqEqBxve1/qDYbluoCJTe9TNYMwFbRAuUOk5VWSItGSDqAY2B00bTWJpBQ/6A4Bpi9B6adgygEUTColh4Ax6CmF3i6SdEJor9jgIkS6gBgTtGaAIuyl0naM+nqEKT0sgZWg4PaOKA0A2qI0dUxIItfJ2lFY2uQAZsT1TTPPaNgFIyCUTAcAACpLMHH5RvbzQAAAABJRU5ErkJggg==");
        map.put(29, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACFUlEQVR42u1WzStEURSfrCQbSbJSkpWkxtxzx0eGe9+M72RjIUl2Fha2FpS95D+wlSxkJwsLSfHefeMj2czKQkqSNEmNc94MDU0z7z1vSN1fnaZpzj3nd74nFNLQ0NDQ+Kc4F9BmSdhUEh5R3lBebAn7yoDpXyWiBF9E5xmUbSX5hCm5tAwYwu+rKA9KwEFyuLumLM6zjtiGJfmSLdkyOny2RXSgkK452FOHvx9bAg4DJZGKxSqd1KNzzMYORUwZsQSfKvbuRLBa1LtFQvPBlUPyNTR6c5oIN3xGLljUdSkFqADJwBManfTb4JTFzEqo4kckknEIY3muaEosg3f5soENnJuyG1uwHp/NGmmnjGC916n2pXQvY7Hq4r3DNlDSdpyD99IYcEG94q6MLI3EZ932niciphHtxUevxaL9TgZLMFdK73Q0XEV2saH7vDTsLI2ve313ZAi0IizBZryRwYVVDjLKYEeeTgXtEJoAHMv6IMnktvKb2x2Vt6xA2ZJvBUmG7KGu6XmazhLRZoziTgm2i9JSYNrihciY/Z2N3/Xpu2MH7SVlpMnXriHDuZuUce4SbWIJ95aIRLK3CdbzydjxjlYnAAl72b3i6NO7DNnxTeTLSOJNwshGcArGbYOPOSkXfOGDEJHJflImIUX6tAhJn97l37Sy4YNQnlz/iuNShOiG0bT8+V9P2qhu14CGhoaGRg7vj4AykH+FC+cAAAAASUVORK5CYII=");
        map.put(30, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABdElEQVR42u2XMUvDQBTHi4OIdHUQBzdnwcHJQXAQcfUriKO45S7FLEI/gAgdNHlXsmQWyVIudxlcHFx0cxCHbqU4ilDflSq5iAUH31W4PzwSsrzfvXd3759Gw8vLy+ufKpSwwxXkXIkhxhPXcBbJrEkOwlVyiCCjSgyYEjy66yzSgvTSVUz+/gkSKmg7qcgYpoCTalXqIKTVYRouqjBBCWtfoFoc4bc+XWW0OK7tF2yZuMbn46RtzyQg0UM2j226r8FYwXQS0IAouJkGEioBrkBesSWpCXy/ZAVsuwIZtMpkg/QYzxpI7h5ExgszDcJkvP73yUfRXFB0t/BY7oUy3sXEygmISc4UvEy5O2hAWqXYxGRvP4OIIQnIZMZIe758g+kQGqQxwK1ZfaCvlrBdp9aMUck5oS8RB/Ypypr2nIG2M09r7hALBj0uvXMzNrJI4tqeyclBmO4uGzNUa0/qzNOaS8+M/7CEfd6DFf8T5uXl9Ut9AM+81jsfnG7dAAAAAElFTkSuQmCC");
        map.put(31, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACBElEQVR42mNgGAWjYBSMglEwRMCrZK3QV8k6q14lae94lay9DUhPeZOmq0FXR9xPUOAAWr4JiP8D8R+gI44C6ccw/uskrWi6OeZlkvZMqMVnXibpKsHFk3ViX6VofwPJAcUtae6QZ8ma8lCHvHsSpyGM6VCdDJD86xSd3bRPJyk64WDHpGgvxCb/v8GBBRx1ydo/aO4YUHqAhsxs3Alb+xfIQXQIGS1bsGOAiRab/NtEbS2oY29gRGGyTglQ3IPKWVr7GjhdJGkXIIt/yNQVfJmsfRKcgIEWY9H3Glf0kg3epGqbgtIEJAR0VoGzeqq2AVL23v+/gYEJHiIpOkHgnJas/QmID4PYIDOoVdhVQi29BnIEWjT8AEbhS1iWh5ZJUIcj4RStdZSXMUBfwtLMqyxtHowEnqhrDy1rboAcAsth/0O12UDR9DpZazGIjRxyZAFQuQKO92Ttp88TDUVx5rgU7UhoCDSjpZn7wFCdS52SN1m7D5pw/YhI5MtBWRy5hH6dqqGGraAkN1RA5cdhEkrqP1TPPdBEm0NsqMBDApg+QA4CpjNxapctoFr6AykJD1TAQeop7UhqOwaUcDeRVKmmGXNhS8jUcMwWUE0NalC9TNYMIAYDy5JWUqOWuPgH5gRQYYZReBHGa2hSSYKbB6CKkkj8IllTZ7RxPgpGwSgYBUQAABoTgA5FMgLGAAAAAElFTkSuQmCC");
        map.put(32, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAAAxklEQVR42mNgGAWjYBSMglEwCEGqZ9PCVK+mLVTDQPMoccyPVM/GCSkejcmUYpA5IPMockyKR7MXNUIZZM6oY0YdM+qYUccMBccEZTk08FCKQeZQ7Bgg/k9FPGwc03gYaMBrKH4JxE+h+BawFt6NF3s23UdS/zTNs+kckF5DsyYGKB2keDaGwzGQP5DtnR9UiwZKQKJnmyi2dJHh0yJN/1CBpAtsiXRvQ0MDE90d1ODQwJLm28AFKkdA9GhDfRSMglEwCkgAAN6sYgyANgSbAAAAAElFTkSuQmCC");
        map.put(33, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABvUlEQVR42u1WsUoDQRBNIWIhdhZiZ2GhIIKICLnbjViJlZ3kS8TGbxAVvLu9EDQI1iJ2QSxsJMS7i41FsBIRQpAgIoLO22wkwiHJ7V23D4a5nZ2ZvN2dnU0uZ2BgYGBgEI/qHh+5d5mVlSD/wGQC194IPfadlSB/MjIuCzDWFeTRIhN5rCQTCPuqccjHkxw54ijPpSIiEpPB+QY+X6fvVuCxqF5emx6GCPzVjrSQB/m0yMjV+dYcra4ZCvYSOWx5kBzwgz/leao7+VnYUiED1Hxrkmw3tNL30LW3/ovHvPQjf8T17KmRkTt0Pj9KO1TpFra9G0vEYzuqPk7g3z+XKpm+H7xVN63c6xnQvwVP83FxqZMJBD9QRPZJd0iuURPQcty1g9BRpmTIdiaTCbvY9Sss0fiZ5AsaY1m8LttWraGSOplmiY+Fnn1Bts/Q4Zv9vg/H1hTqA/oPcfIj+wfiEJ8KmcfTlQn6ruII0CuG6TORYAWKe8MRovlpkcEVpWZXk01LsNUkHRhxiCe5k1de421qo3E1HL6o8y8gdK0F1QDbug8lmtdrCtJJ9lD6+Rlc4ayk9zwYGBgYGBjE4AdOoZZEItMCzQAAAABJRU5ErkJggg==");
        map.put(34, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABUElEQVR42mNgGAWjYBSMgkEKLrlZalxwseg772q+7YKL+VMIbdEHEqerQy44mzcCHfAHiP9jwSDxZro45Lyz+QSEpaCQsbC+6uDAA6JBfJgjzzubzaapQy46W3pAHfIFZDlWNW4W5kD5d2B1zhbhtIseF/PDIEsuOlvk4VdnlgN19CWaOORqqDYbLHrO+BpzEan2/zlPW1HqRxEk+EEWfCIyFL+A1buau1HdMedcLFxIdMwncEJ2NfcadczIcswlbxtBoKHHYYZD8WsiMEztJ2AiPgkyh/ISF+gzHMU+SZgqITSUHPPngqtFObiaANJ4Kk96OMasA60a6Bgwx1x0NYtEKaWB/IFzjIv5BhTHAPkDmoDPO1tEEwoVujnmorNZMqStY5Y8CBxjkQdqMoDokVXOXHQz0aGGY0DmUKk3YKYGqijJxXTvvoyCUTAKBhMAAMi0i5XkrhQvAAAAAElFTkSuQmCC");
        map.put(35, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABZklEQVR42u2WP0rEQBjFFxGxsrewtfACIiIiWImFjQcQDyHJRAjIggew1nyTFcHS1iIzSWN6PYWNbLUEYf1ezFqJTDKzZIV58Egz7/HLJPNnMPDy8vJaAMXZ3apQ8jTS8rytkUPeGYzQVLKnFi6dgASKdlAYqeSsSx455IM82bWG4ak+qmH42Ufew/wPGKFvN5oV9M4eNyuiYk86uGry46avRL85TE5DDn2GOrlxbfRGmq6NYZrQZB4bKHrR3wvMZSG3wzxd7x0mnsZL3z8v3S/EzEQZHQYFbTqDiV9Ga4FK97oaeWcweDubgxL5OcDIqyhPT0yN8XODabuL/uy+DmAqlMChpgsbGORnXehtBRPkcv/Xb98R5q9/yBBotIUyONRS2M2MFLMu9FrvFTVMQcetcjy+hlF04PBCni3Xp66iV75GPpga43lFfcRvjytODzicMUInT3yiPxubxzu5+3p5eXk50hccW8x8Lf8J7wAAAABJRU5ErkJggg==");
        map.put(36, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABmElEQVR42mNgGAWjYBSMglEwhMHb6Fy+QeGQT7ElyR9jSv9/iikpGhQOgeEBcxDMIR9iy9IgDiltBdK/BsRBQIvvAnHkq9AGHqhjbIG0BxA//9/QwERVy/4nNHB8iCtxQcFRFYLo6pAdgy4HUo9uBshckh3zIaZ0NnJ6AOPo0vmkOAaknhgziImGhVADbn2LK5T+H9rAhi348TkGpB6kD6QfGq0g8xaS6ZiyLR9jSg4DE+WFz4mVotjU4XMMCID0AUP5EsgciHnkO2Y5xDKIg0hNM5/iKoVB+oD6j0LUlS0nyzHQNLMQycLjQMPOoTsIlCDBWTqyWAM98UIcUnocVkKDzAM6eibpuQkU3w4NLMiGQxxUehxbCKE75GNs6Ul0tSDzkM2kCCAcVHIUHhWg8iW2LPZ9VJkjIopLjgLFzhByNFUcBCovsGf/si1gcRxlEu2qg+hSa4wyBJSQo8vi6V8dAKMGq2PISaCUAlAaweYYUMU5IDU30PJNqI4pOUq13EJudIESMqhJASr6R9u9o2AUjIJRMBQBAD0Bjo+Gpks1AAAAAElFTkSuQmCC");
        map.put(37, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACyUlEQVR42u1XPWgUQRQ+LMRKEBEREUQOyc6bU0TEwsJOgogEIYhIcu7uXFCQIDYWIiiSRiRYpBE5RMQmhZWdWIiFCKksbURQLnubkxBEJByc75udvcQz2Z293VjIDgyzs/vem/f7zdtKpRzlKEc51kbvbmVboOSRsCHPBb4zplfe4/0/UyJ0a6fbvpxvK/rZ9qn319Tv5TzotkyJwKsd4sPe4cDApy88Z9kTF3g99XVyZDdWs5/Fd6Mc04tqoYqw0FGeKzxbgS8nLHnqoNd8yjlbjCIsiAV22fVvW+6xPXY8Yoa9c6/jygPgg5dCj87nUqTjkkAOBB69+Xzl4A6rnJpy9vHhv3h+hzIwAPyQs+g7ModX6CPiv3yttss+t+TD2BOhojv8/An5pvOI5Q2bJ3WThKPWldb3injE6624wkJfPGclz5h9fRhlFjje7zNVHFcSeNYr0ldI1Y6bbwvZsCSysMfWXE2jXWrQibaSFxddcRKgx8+3N8Qfn55AHp6XJo/ut7eQ8QJMaQnH4Wj+eaBoRhWkE3hQmRbkaSNZfoYQietgSoJ2JGjkfprqjdP22Gq853C92Mg7oItQWk7bK+PRHKxLrhp6jPIdyLNlvNd3lZKvByfgQXuN5dvnTFSS3UQaj24wzWocf6zYh564mVIYDKB0P0NVyAm4E3fOZjT4xjTfeIb64vQowN6CB6G9ZK2MrhB9ITpjKYm+14T0FVbsrQqDKy9TrxJZTE8LvXAVPYMHs/ctSjxYnxO5+6AIu1ZxXQzLvIJ8KKYN4bzy6UdaKJMuPYMdyRWSHh45bYvoFRuUBbjlMQhyimk5+4gqmrbtROdydWdsCPiLbcQ5VEhAoG7UxZHYrCHDd9AB4PKGOClkVfQmBkX1nwAf/EHjDNqDtT+GLujCxsjhLf9dQahYsfEI8PDbIl4aFJ7D+yydYTnKUY7/fvwGuW8xkQfdg60AAAAASUVORK5CYII=");
        map.put(38, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAACFElEQVR42u1WQSgEYRTeHCS5OUhujjiovdr//Us5SJKSpM3BRY5SDhJyk5NQu/PPbpKU5OQu7UFKYnYXF22Sq5MkqfXeP2tazM4aOzN7+V+9pnn/e+//5r3vf/OHQkqUKFGi5G+S0fpaMgJOUN9Q0/ReOzCCHSOI56wOcXrSe02AGBobQACFrIAZCUzn0/Se0Vl/oEAKy6E63Pguo4HxvW1goP2G1gNsD5+jKhjJKJTarzWISLsOs4EAud3pay7y49Ce1HBE6+QXQFVgG/XdSPa0Wy1Dnny1huxyXeebvgLJJSMdRdKulFRizSQuX7fILdgq2j7I38+qnBoCnnJbvKnEti/B4NMCjevkR/7+HGXBh4ubxn4A/AWGJCvYJNlzOhvytj0HnfWY+B6/9tKmWrZgzA+AS4qjeA/HPluQR1aLhl2BQX8ZJ9i8J0Bu4pFWTPiCuluGR2XBmO2CPYqnPFWDwWQpSna109tmyyUccE6DjuIonvJUx5UE7zbbA4tOfvkUb3Bss86WJJkxXzVH+Ry/KO9EwKwG4zhrXulZ4QA8oJ79rz20iSQfjDqTGzbMNjlPXDwEY6Yfm3AF5CIebsTAR7owVWwlDjjcaKR0EDpUOk3DsFJbQ3YD61rwLm/vQOZRRw5NueFKTAZhaenv65VSy12DoTIWp2fBB71w1SbrapDgg/RP8kopX6C3QCVKlCj5IZ+ak+VLOAPYywAAAABJRU5ErkJggg==");
        map.put(39, "iVBORw0KGgoAAAANSUhEUgAAACMAAAAnCAYAAACFSPFPAAABTUlEQVR42mNgGAWjYBSMAlSQ6tFkmubZHIAPp3g3GdPHMZ5ND4H4P17s0exHc4ckezZZE3SIV/MquoRKmkfjFAKOeZnt3CZMc4c0ODSwAC37gNcx7s0u9AqVUHwOSfNsaqVfLvJs2oE7wTYepZtDEt1aZPGEygeQPN0cAyw7anE5JsWrMZG+BR3usuVPqlfTFnSc4NDAQRuHAHMIwbKFXuUM0II1xDuk6UKWQwMPbRKuZ5soOCqIc8zTFL9WcZqFSopnUwGRDnmX7tmgRdOEC6p90WtkoMU/0BzyI8W9yZb+zQfPJnvMkrc5YGDaMl5N81HKGGA0DohDQLkE6IBfiJzT2DdgLTxgRZhD9zYLnii6AHFM4+HQ0Aa2gQsVryZzaDPhBl0aT0Qk3Jd0rZ3xlMKfQL2CAe+apHg01w9YWYLFMUGjvcVRMApGAYkAAChEgagJ7TL6AAAAAElFTkSuQmCC");
        return map;
    }

    public Option<String> getBase64EncodedIcon(int iconId) {
        String value = this.requestTypeIdToBase64EncodingMap.get(iconId);
        return value == null ? Option.none() : Option.some((Object)value);
    }
}

