/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import io.atlassian.fugue.Either;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeFieldValidator {
    private final CommonErrors commonErrors;

    @Autowired
    public RequestTypeFieldValidator(CommonErrors commonErrors) {
        this.commonErrors = commonErrors;
    }

    public Either<AnError, RequestType> isRequestTypeValidForEmailChannel(RequestType requestType, List<RequestTypeFieldInternal> requestTypeFields) {
        if (this.noVisibleSummary(requestTypeFields)) {
            return Either.left((Object)this.commonErrors.EMAIL_CHANNEL_SUMMARY_NOT_VISIBLE());
        }
        if (this.noVisibleDescription(requestTypeFields)) {
            return Either.left((Object)this.commonErrors.EMAIL_CHANNEL_DESCRIPTION_NOT_VISIBLE());
        }
        if (this.hasVisibleRequiredFieldsExceptSummaryAndDescription(requestTypeFields)) {
            return Either.left((Object)this.commonErrors.EMAIL_CHANNEL_INVALID_REQUIRED_FIELDS());
        }
        return Either.right((Object)requestType);
    }

    public boolean isSummaryOrDescriptionField(RequestTypeFieldInternal field) {
        return "summary".equals(field.getFieldId()) || "description".equals(field.getFieldId());
    }

    private boolean noVisibleSummary(List<RequestTypeFieldInternal> fieldList) {
        return fieldList.stream().noneMatch(field -> "summary".equals(field.getFieldId()) && field.isDisplayed());
    }

    private boolean noVisibleDescription(List<RequestTypeFieldInternal> fieldList) {
        return fieldList.stream().noneMatch(field -> "description".equals(field.getFieldId()) && field.isDisplayed());
    }

    private boolean hasVisibleRequiredFieldsExceptSummaryAndDescription(List<RequestTypeFieldInternal> fieldList) {
        return fieldList.stream().filter(f -> !this.isSummaryOrDescriptionField((RequestTypeFieldInternal)f)).anyMatch(f -> f.isDisplayed() && f.isRequired());
    }
}

