/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldHelper;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldValueMapper;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.value.RequestTypeFieldValue;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeFieldQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public RequestTypeFieldQStore(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    public List<RequestTypeFieldInternal> getAllRequestTypeFieldsForPortalWithoutFieldValues(Portal portal) {
        return (List)this.databaseAccessor.runInTransaction(conn -> {
            List viewports = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.REQUEST_TYPE_FIELD.all()).from((Expression)Tables.REQUEST_TYPE_FIELD)).join((EntityPath)Tables.REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE_FIELD.FORM_ID.eq(Tables.REQUEST_TYPE.ID))).where((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq((Object)portal.getId()))).fetch();
            return this.getRequestTypeFields(viewports, (Multimap<Integer, RequestTypeFieldValue>)ArrayListMultimap.create());
        });
    }

    public List<RequestTypeFieldInternal> getFieldsForRequestType(int requestTypeId) {
        Multimap requestTypeIdToValuesMap = (Multimap)this.databaseAccessor.runInTransaction(conn -> {
            List viewPortFieldValues = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.REQUEST_TYPE_FIELD_VALUE.all()).from((Expression)Tables.REQUEST_TYPE_FIELD_VALUE)).join((EntityPath)Tables.REQUEST_TYPE_FIELD)).on((Predicate)Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_ID.eq(Tables.REQUEST_TYPE_FIELD.ID))).where((Predicate)Tables.REQUEST_TYPE_FIELD.FORM_ID.eq((Object)requestTypeId))).fetch();
            ArrayListMultimap multiMap = ArrayListMultimap.create();
            for (Tuple tuple : viewPortFieldValues) {
                RequestTypeFieldValue value = this.createRequestTypeFieldValueFromTuple(tuple);
                multiMap.put((Object)value.getFieldId(), (Object)value);
            }
            return multiMap;
        });
        return (List)this.databaseAccessor.runInTransaction(conn -> {
            List viewPortField = ((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.REQUEST_TYPE_FIELD.all()).from((Expression)Tables.REQUEST_TYPE_FIELD)).where((Predicate)Tables.REQUEST_TYPE_FIELD.FORM_ID.eq((Object)requestTypeId))).fetch();
            return this.getRequestTypeFields(viewPortField, (Multimap<Integer, RequestTypeFieldValue>)requestTypeIdToValuesMap);
        });
    }

    public void deleteField(RequestTypeFieldInternal requestTypeFieldInternal) {
        BooleanExpression where = Tables.REQUEST_TYPE_FIELD.ID.eq((Object)requestTypeFieldInternal.getId());
        this.deleteFields(where);
    }

    public void deleteFieldsForRequestType(RequestType requestType) {
        BooleanExpression where = Tables.REQUEST_TYPE_FIELD.FORM_ID.eq((Object)requestType.getId());
        this.deleteFields(where);
    }

    private void deleteFields(BooleanExpression where) {
        this.databaseAccessor.runInTransaction(conn -> {
            List fieldValueIds = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(Tables.REQUEST_TYPE_FIELD_VALUE.ID).from((Expression)Tables.REQUEST_TYPE_FIELD_VALUE)).join((EntityPath)Tables.REQUEST_TYPE_FIELD)).on((Predicate)Tables.REQUEST_TYPE_FIELD.ID.eq(Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_ID))).where((Predicate)where)).fetch();
            conn.delete((RelationalPath)Tables.REQUEST_TYPE_FIELD_VALUE).where((Predicate)Tables.REQUEST_TYPE_FIELD_VALUE.ID.in((Collection)fieldValueIds)).execute();
            return conn.delete((RelationalPath)Tables.REQUEST_TYPE_FIELD).where((Predicate)where).execute();
        });
    }

    public Option<RequestTypeFieldInternal> updateField(RequestTypeFieldInternal field) {
        this.databaseAccessor.runInTransaction(conn -> conn.update((RelationalPath)Tables.REQUEST_TYPE_FIELD).set((Path)Tables.REQUEST_TYPE_FIELD.DESCRIPTION, (Object)field.getDescription()).set((Path)Tables.REQUEST_TYPE_FIELD.DISPLAYED, (Object)field.isDisplayed()).set((Path)Tables.REQUEST_TYPE_FIELD.LABEL, (Object)field.getLabel()).set((Path)Tables.REQUEST_TYPE_FIELD.REQUIRED, (Object)field.isRequired()).set(Tables.REQUEST_TYPE_FIELD.FIELD_ORDER, (Object)field.getOrder()).where((Predicate)Tables.REQUEST_TYPE_FIELD.ID.eq((Object)field.getId())).execute());
        return this.getField(field.getId());
    }

    public Option<RequestTypeFieldInternal> getField(int id) {
        BooleanExpression where = Tables.REQUEST_TYPE_FIELD.ID.eq((Object)id);
        List<RequestTypeFieldInternal> requestTypeFieldInternals = this.getRequestTypeFieldInternals(where);
        return Iterables.first(requestTypeFieldInternals);
    }

    private List<RequestTypeFieldInternal> getRequestTypeFieldInternals(BooleanExpression where) {
        Map mapping = (Map)this.databaseAccessor.runInTransaction(conn -> (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(RequestTypeFieldHelper.RequestTypeFieldInternalMapper()).from((Expression)Tables.REQUEST_TYPE_FIELD)).leftJoin((EntityPath)Tables.REQUEST_TYPE_FIELD_VALUE)).on((Predicate)Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_ID.eq(Tables.REQUEST_TYPE_FIELD.ID))).where((Predicate)where)).transform(GroupBy.groupBy(RequestTypeFieldHelper.RequestTypeFieldInternalMapper()).as((Expression)GroupBy.list((Expression)new RequestTypeFieldValueMapper()))));
        return RequestTypeFieldHelper.mapToValueList(mapping);
    }

    public long getHiddenFieldCount(int requestTypeId) {
        return this.getAmountOfFields(requestTypeId, false);
    }

    public long getVisibleFieldCount(int requestTypeId) {
        return this.getAmountOfFields(requestTypeId, true);
    }

    private Long getAmountOfFields(int requestTypeId, boolean visible) {
        return (Long)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select(Tables.REQUEST_TYPE_FIELD.ID).from((Expression)Tables.REQUEST_TYPE_FIELD)).where((Predicate)Tables.REQUEST_TYPE_FIELD.DISPLAYED.eq(Boolean.valueOf(visible)).and((Predicate)Tables.REQUEST_TYPE_FIELD.FORM_ID.eq((Object)requestTypeId)))).fetchCount());
    }

    public Integer createRequestTypeField(RequestType requestType, RequestTypeFieldInternal requestTypeFieldInternal) {
        Integer createdAmount = (Integer)this.databaseAccessor.runInTransaction(conn -> (Integer)conn.insert((RelationalPath)Tables.REQUEST_TYPE_FIELD).set(Tables.REQUEST_TYPE_FIELD.FORM_ID, (Object)requestType.getId()).set((Path)Tables.REQUEST_TYPE_FIELD.FIELD_ID, (Object)requestTypeFieldInternal.getFieldId()).set((Path)Tables.REQUEST_TYPE_FIELD.FIELD_TYPE, (Object)requestTypeFieldInternal.getServiceDeskFieldType()).set((Path)Tables.REQUEST_TYPE_FIELD.LABEL, (Object)requestTypeFieldInternal.getLabel()).set((Path)Tables.REQUEST_TYPE_FIELD.DESCRIPTION, (Object)requestTypeFieldInternal.getDescription()).set((Path)Tables.REQUEST_TYPE_FIELD.REQUIRED, (Object)requestTypeFieldInternal.isRequired()).set((Path)Tables.REQUEST_TYPE_FIELD.DISPLAYED, (Object)requestTypeFieldInternal.isDisplayed()).set(Tables.REQUEST_TYPE_FIELD.FIELD_ORDER, (Object)requestTypeFieldInternal.getOrder()).executeWithKey(Tables.REQUEST_TYPE_FIELD.ID));
        if (createdAmount == null) {
            throw new RuntimeException("field not created");
        }
        return createdAmount;
    }

    private RequestTypeFieldValue createRequestTypeFieldValueFromTuple(Tuple tuple) {
        return new RequestTypeFieldValue((Integer)tuple.get(Tables.REQUEST_TYPE_FIELD_VALUE.ID), (Integer)tuple.get(Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_ID), StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_NAME))), StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.REQUEST_TYPE_FIELD_VALUE.VALUE))), (Integer)tuple.get(Tables.REQUEST_TYPE_FIELD_VALUE.VALUE_ORDER));
    }

    private List<RequestTypeFieldInternal> getRequestTypeFields(List<Tuple> tuples, Multimap<Integer, RequestTypeFieldValue> requestTypeFieldIdToValuesMap) {
        return FpKit.map(tuples, tuple -> {
            Integer fieldId = (Integer)tuple.get(Tables.REQUEST_TYPE_FIELD.ID);
            List<RequestTypeFieldValue> fieldValues = requestTypeFieldIdToValuesMap.get((Object)fieldId).stream().collect(Collectors.toList());
            return new RequestTypeFieldInternal(fieldId, StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.REQUEST_TYPE_FIELD.FIELD_ID))), StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.REQUEST_TYPE_FIELD.FIELD_TYPE))), StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.REQUEST_TYPE_FIELD.LABEL))), StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.REQUEST_TYPE_FIELD.DESCRIPTION))), (Boolean)tuple.get((Expression)Tables.REQUEST_TYPE_FIELD.REQUIRED), (Boolean)tuple.get((Expression)Tables.REQUEST_TYPE_FIELD.DISPLAYED), (Integer)tuple.get(Tables.REQUEST_TYPE_FIELD.FIELD_ORDER), fieldValues, (Integer)tuple.get(Tables.REQUEST_TYPE_FIELD.FORM_ID));
        });
    }
}

