/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.listener;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.request.listener.LastRequestActivityPropertyValidator;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.issueproperty.ServiceDeskIssuePropertyNames;
import com.atlassian.servicedesk.internal.util.IssueEventTypeHelper;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestActivityIssueListener {
    private static final Logger LOG = LoggerFactory.getLogger(RequestActivityIssueListener.class);
    private final UserFactory userFactory;
    private final IssuePropertyService issuePropertyService;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final VpOriginManager vpOriginManager;
    private final LastRequestActivityPropertyValidator lastRequestActivityPropertyValidator;
    private final IssueEventTypeHelper issueEventTypeHelper;

    @Autowired
    public RequestActivityIssueListener(UserFactory userFactory, IssuePropertyService issuePropertyService, ServiceDeskInternalManager serviceDeskManager, VpOriginManager vpOriginManager, LastRequestActivityPropertyValidator lastRequestActivityPropertyValidator, IssueEventTypeHelper issueEventTypeHelper) {
        this.userFactory = userFactory;
        this.issuePropertyService = issuePropertyService;
        this.serviceDeskManager = serviceDeskManager;
        this.vpOriginManager = vpOriginManager;
        this.lastRequestActivityPropertyValidator = lastRequestActivityPropertyValidator;
        this.issueEventTypeHelper = issueEventTypeHelper;
    }

    public void onIssueActivityUpdate(IssueEvent issueEvent) {
        if (this.issueEventTypeHelper.isEventOfType(issueEvent, EventType.ISSUE_DELETED_ID)) {
            return;
        }
        this.internalOnIssueActivityUpdate(issueEvent.getUser(), issueEvent.getIssue());
    }

    public void onIssueChangedEvent(IssueChangedEvent issueChangedEvent) {
        this.internalOnIssueActivityUpdate(issueChangedEvent.getAuthor().orElse(null), issueChangedEvent.getIssue());
    }

    public void onCommentCreatedEvent(CommentCreatedEvent commentCreatedEvent) {
        this.internalOnIssueActivityUpdate(commentCreatedEvent.getComment().getAuthorApplicationUser(), commentCreatedEvent.getComment().getIssue());
    }

    public void onCommentUpdatedEvent(CommentUpdatedEvent commentUpdatedEvent) {
        this.internalOnIssueActivityUpdate(commentUpdatedEvent.getComment().getUpdateAuthorApplicationUser(), commentUpdatedEvent.getComment().getIssue());
    }

    public void onCommentDeletedEvent(CommentDeletedEvent commentDeletedEvent) {
        if (CoreTransactionUtil.inTransaction()) {
            if (LOG.isDebugEnabled()) {
                Long issueId = (Long)Option.option((Object)commentDeletedEvent.getComment().getIssue()).map(Issue::getId).getOrNull();
                LOG.debug("Not updating last public activity for issue {}, as we are currently inside another transaction acting on a CommentDeletedEvent. Will only update on events fired from outside transactions", (Object)issueId);
            }
            return;
        }
        this.internalOnIssueActivityUpdate(this.userFactory.getUncheckedUser().forJIRA(), commentDeletedEvent.getComment().getIssue());
    }

    private void internalOnIssueActivityUpdate(ApplicationUser user, Issue issue) {
        if (issue != null && issue.getProjectObject() != null && this.serviceDeskManager.hasServiceDesk(issue.getProjectObject(), false) && this.vpOriginManager.lookup(issue) != null) {
            this.getEventAuthor(user).forEach(checkedUser -> this.updateLastPublicActivityIssueProperty((CheckedUser)checkedUser, issue));
        }
    }

    private Option<CheckedUser> getEventAuthor(ApplicationUser creator) {
        Option checkedUserOption = StepsConverters.newerEither((Either)this.userFactory.wrap(creator)).toOption();
        if (checkedUserOption.isEmpty()) {
            LOG.error("Failed to get event initiating user to set issue property '{}'", (Object)ServiceDeskIssuePropertyNames.SD_REQUEST_LAST_PUBLIC_ACTIVITY_KEY());
        }
        return checkedUserOption;
    }

    private void updateLastPublicActivityIssueProperty(CheckedUser user, Issue issue) {
        Option<EntityPropertyService.SetPropertyValidationResult> setPropertyValidationResult = this.lastRequestActivityPropertyValidator.validatePropertyInput(user, issue);
        Option errorStringOption = (Option)setPropertyValidationResult.fold(() -> Option.some((Object)"validateSetProperty() function of IssuePropertyService returned empty/null result"), validationResult -> this.handleValidationResult(user, (EntityPropertyService.SetPropertyValidationResult)validationResult));
        errorStringOption.forEach(errorString -> LOG.warn("Potential failure to store issue property '{}', errors: [{}]", (Object)ServiceDeskIssuePropertyNames.SD_REQUEST_LAST_PUBLIC_ACTIVITY_KEY(), errorString));
    }

    private Option<String> handleValidationResult(CheckedUser user, EntityPropertyService.SetPropertyValidationResult validationResult) {
        if (validationResult.isValid()) {
            this.issuePropertyService.setProperty(user.forJIRA(), validationResult);
            return Option.none();
        }
        return Option.some((Object)this.join(validationResult.getErrorCollection()));
    }

    private String join(ErrorCollection errorCollection) {
        Collection errorMessages2 = errorCollection.getErrorMessages();
        Map errors = errorCollection.getErrors();
        StringBuilder sb = new StringBuilder();
        if (!errorMessages2.isEmpty()) {
            sb.append("Error Messages:").append("\n");
            errorMessages2.forEach(msg -> sb.append("\t").append((String)msg).append("\n"));
        }
        if (!errors.isEmpty()) {
            sb.append("Errors:").append("\n");
            errors.forEach((key, value) -> sb.append("\t").append((String)key).append(": ").append((String)value).append("\n"));
        }
        return sb.toString();
    }
}

