/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.list.security;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.list.AllVisiblePortals;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestTypeFilter;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalRequestTypeSecurityClauseBuilder {
    private final VpOriginManager vpOriginManager;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final InternalPortalService internalPortalService;

    @Autowired
    public PortalRequestTypeSecurityClauseBuilder(VpOriginManager vpOriginManager, VpOriginCustomFieldService vpOriginCustomFieldService, InternalPortalService internalPortalService) {
        this.vpOriginManager = vpOriginManager;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.internalPortalService = internalPortalService;
    }

    public void addPortalRequestTypeSecurity(JqlClauseBuilder builder, AllVisiblePortals allVisiblePortals, PortalRequestTypeFilter portalFilter) {
        this.addPortalFilterSecurityRelevant(builder, allVisiblePortals, portalFilter);
        this.addRequestTypeClauseSecurityRelevant(builder, portalFilter);
    }

    private void addRequestTypeClauseSecurityRelevant(JqlClauseBuilder builder, PortalRequestTypeFilter portalAndRequestTypeFilter) {
        Option vpOrigin = Option.none();
        if (portalAndRequestTypeFilter.hasPortalAndRequest()) {
            Portal portal = (Portal)portalAndRequestTypeFilter.getPortal().get();
            RequestType requestType = (RequestType)portalAndRequestTypeFilter.getRequestType().get();
            vpOrigin = Option.some((Object)this.vpOriginManager.getVpOriginForRequestType(portal, requestType));
        }
        CustomField vpOriginCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        Long vpOriginCustomFieldId = vpOriginCustomField.getIdAsLong();
        if (vpOrigin.isEmpty()) {
            builder.customField(vpOriginCustomFieldId).isNotEmpty();
        } else {
            builder.customField(vpOriginCustomFieldId).eq(((VpOrigin)vpOrigin.get()).toString());
        }
    }

    private void addPortalFilterSecurityRelevant(JqlClauseBuilder builder, AllVisiblePortals allVisiblePortals, PortalRequestTypeFilter portalFilter) {
        Option<Portal> singlePortalFilterOpt = portalFilter.getPortal();
        List<Portal> portalsToFilterBy = this.getPortalsToFilterBy(allVisiblePortals, singlePortalFilterOpt);
        List<Long> projectIds = portalsToFilterBy.stream().map(this.internalPortalService::getProjectIdForPortal).collect(Collectors.toList());
        Long[] projectIdArr = projectIds.toArray(new Long[projectIds.size()]);
        builder.project(projectIdArr);
    }

    private List<Portal> getPortalsToFilterBy(AllVisiblePortals allVisiblePortals, Option<Portal> portal) {
        List<Portal> allPortals = allVisiblePortals.getAllVisiblePortals();
        List portalsToFilterBy = Collections.emptyList();
        if (portal.isDefined()) {
            int portalId = ((Portal)portal.get()).getId();
            portalsToFilterBy = allPortals.stream().filter(p -> p.getId() == portalId).collect(Collectors.toList());
        }
        return portalsToFilterBy.isEmpty() ? allPortals : portalsToFilterBy;
    }
}

