/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.list;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Property;
import com.atlassian.query.operator.Operator;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFManager;
import com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalCustomFieldHelper;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalListSearchQueryFactory;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalPluginInfo;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.list.AllVisiblePortals;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalListFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalQueryType;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListSearchQueryFactory;
import com.atlassian.servicedesk.internal.feature.customer.request.list.TextSearchFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.security.PortalRequestTypeSecurityClauseBuilder;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.organization.model.OrganizationProjectsList;
import com.atlassian.servicedesk.internal.feature.organization.project.CustomerOrganizationProjectManager;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestListSearchQueryFactoryImpl
implements RequestListSearchQueryFactory,
ApprovalListSearchQueryFactory {
    private final InternalPortalService internalPortalService;
    private final ParticipantsCustomFieldManager participantsCustomFieldManager;
    private final PortalRequestTypeSecurityClauseBuilder portalRequestTypeSecurityClauseBuilder;
    private final ApprovalCustomFieldHelper approvalCustomFieldHelper;
    private final CustomerOrganizationsCFManager customerOrganizationsCFManager;
    private final CustomerOrganizationManager customerOrganizationManager;
    private final CustomerOrganizationMemberManager organisationMemberManager;
    private final CustomerOrganizationProjectManager organisationProjectManager;
    private final FeatureManager featureManager;

    @Autowired
    public RequestListSearchQueryFactoryImpl(InternalPortalService internalPortalService, ParticipantsCustomFieldManager participantsCustomFieldManager, PortalRequestTypeSecurityClauseBuilder portalRequestTypeSecurityClauseBuilder, ApprovalCustomFieldHelper approvalCustomFieldHelper, CustomerOrganizationsCFManager customerOrganizationsCFManager, CustomerOrganizationManager customerOrganizationManager, CustomerOrganizationMemberManager organisationMemberManager, CustomerOrganizationProjectManager organisationProjectManager, FeatureManager featureManager) {
        this.internalPortalService = internalPortalService;
        this.participantsCustomFieldManager = participantsCustomFieldManager;
        this.portalRequestTypeSecurityClauseBuilder = portalRequestTypeSecurityClauseBuilder;
        this.approvalCustomFieldHelper = approvalCustomFieldHelper;
        this.customerOrganizationsCFManager = customerOrganizationsCFManager;
        this.customerOrganizationManager = customerOrganizationManager;
        this.organisationMemberManager = organisationMemberManager;
        this.organisationProjectManager = organisationProjectManager;
        this.featureManager = featureManager;
    }

    @Override
    public AllVisiblePortals getAllVisiblePortals(CheckedUser user) {
        return new AllVisiblePortals(this.internalPortalService.getCustomerVisiblePortals(user));
    }

    @Override
    public Option<Query> getRequestListQuery(CheckedUser user, AllVisiblePortals allVisiblePortals, RequestListFilter requestListFilter) {
        if (!allVisiblePortals.hasVisiblePortals()) {
            return Option.none();
        }
        JqlQueryBuilder builder = this.getJqlQueryBuilder();
        JqlClauseBuilder whereClauseBuilder = builder.where().defaultAnd();
        this.portalRequestTypeSecurityClauseBuilder.addPortalRequestTypeSecurity(whereClauseBuilder, allVisiblePortals, requestListFilter.getPortalRequestTypeFilter());
        this.addReporterFilterSecurityRelevant(whereClauseBuilder, user, requestListFilter.getOwnership(), requestListFilter.getSharedWithOrganisationId());
        this.addStateFilter(whereClauseBuilder, requestListFilter.getStatus());
        this.addTextFilter(whereClauseBuilder, requestListFilter.getTextFilter());
        this.addOrderByLastRequestActivity(builder);
        Query query = builder.buildQuery();
        return Option.some((Object)query);
    }

    @Override
    public Option<Query> getRequestListQueryBasedOnApprovalFilter(CheckedUser user, AllVisiblePortals allVisiblePortals, ApprovalListFilter approvalListFilter) {
        if (!allVisiblePortals.hasVisiblePortals()) {
            return Option.none();
        }
        Option<CustomField> approvalCustomFieldOpt = this.getApprovalCustomField();
        if (approvalCustomFieldOpt.isEmpty()) {
            return Option.none();
        }
        JqlQueryBuilder builder = this.getJqlQueryBuilder();
        JqlClauseBuilder whereClauseBuilder = builder.where().defaultAnd();
        this.portalRequestTypeSecurityClauseBuilder.addPortalRequestTypeSecurity(whereClauseBuilder, allVisiblePortals, approvalListFilter.getPortalRequestTypeFilter());
        this.addApproverTypeFilter(user, whereClauseBuilder, approvalListFilter.getApprovalQueryType(), (CustomField)approvalCustomFieldOpt.get());
        this.addTextFilter(whereClauseBuilder, approvalListFilter.getTextFilter());
        this.addOrderByLastRequestActivity(builder);
        Query query = builder.buildQuery();
        return Option.some((Object)query);
    }

    protected JqlQueryBuilder getJqlQueryBuilder() {
        return JqlQueryBuilder.newBuilder();
    }

    private JqlQueryBuilder addOrderByLastRequestActivity(JqlQueryBuilder builder) {
        Property issueProperty = new Property((List)Lists.newArrayList((Object[])new String[]{"request.public-activity.lastupdated"}), Collections.emptyList());
        SearchSort issuePropSearchSort = new SearchSort("issue.property", StepsConverters.olderOption((Option)Option.some((Object)issueProperty)), SortOrder.DESC);
        SearchSort issueCreatedSearchSort = new SearchSort("created", SortOrder.DESC);
        builder.orderBy().setSorts((Collection)Lists.newArrayList((Object[])new SearchSort[]{issuePropSearchSort, issueCreatedSearchSort})).endOrderBy();
        return builder;
    }

    private void addTextFilter(JqlClauseBuilder builder, Option<TextSearchFilter> textFilterOpt) {
        if (textFilterOpt.isEmpty()) {
            return;
        }
        TextSearchFilter textFilter = (TextSearchFilter)textFilterOpt.get();
        if (textFilter.isLegacy()) {
            this.addLegacyTextFilter(builder, textFilter.getFilter());
        } else {
            this.addTextFilter(builder, textFilter.getFilter());
        }
    }

    private void addLegacyTextFilter(JqlClauseBuilder builder, String filter2) {
        String[] parts;
        if (StringUtils.isNotBlank((String)filter2) && (parts = filter2.split("\\s+")).length > 0) {
            builder.sub().summary().like(filter2).or().issue(parts).endsub();
        }
    }

    private void addTextFilter(JqlClauseBuilder builder, String textFilter) {
        if (StringUtils.isNotBlank((String)textFilter)) {
            builder.field("text").like(textFilter);
        }
    }

    private void addStateFilter(JqlClauseBuilder builder, CustomerRequestQuery.REQUEST_STATUS status) {
        switch (status) {
            case OPEN_REQUESTS: {
                builder.resolution().isEmpty();
                break;
            }
            case CLOSED_REQUESTS: {
                builder.resolution().isNotEmpty();
                break;
            }
        }
    }

    private void addReporterFilterSecurityRelevant(JqlClauseBuilder builder, CheckedUser user, CustomerRequestQuery.REQUEST_OWNERSHIP requestOwnership, Option<Integer> sharedWithOrganisationId) {
        CustomField participantsCustomField = this.participantsCustomFieldManager.getParticipantsCustomField();
        switch (requestOwnership) {
            case OWNED_REQUESTS: {
                builder.defaultAnd().reporterUser(user.getName());
                break;
            }
            case PARTICIPATED_REQUESTS: {
                builder.defaultAnd();
                builder.customField(participantsCustomField.getIdAsLong()).eq(user.getName());
                builder.sub();
                builder.reporter().eqEmpty().or().reporter().notEq(user.getName());
                builder.endsub();
                break;
            }
            case ALL_REQUESTS: {
                JqlClauseBuilder originalClauses = builder.defaultAnd().sub().reporterUser(user.getName()).or().customField(participantsCustomField.getIdAsLong()).eq(user.getName());
                if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
                    originalClauses = this.addOrganisationsInClause(user, originalClauses, true);
                }
                originalClauses.endsub();
                break;
            }
            case ALL_ORGANIZATIONS: {
                this.addOrganisationsInClause(user, builder, false);
                break;
            }
            case ORGANIZATION: {
                if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS) && this.userIsInOrganisation(user, sharedWithOrganisationId)) {
                    Steps.begin(sharedWithOrganisationId).then(this::getOrganisationName).yield((id, name) -> this.buildOrganisationCustomFieldClause(builder, this.getOrganisationCustomFieldId(), (String)name, this.organisationProjectManager.getProjectsForOrganization((int)id))).getOr(() -> this.shortCircuitBuilder(builder));
                    break;
                }
                this.shortCircuitBuilder(builder);
            }
        }
    }

    private JqlClauseBuilder buildOrganisationCustomFieldClause(JqlClauseBuilder builder, Long customFieldId, String name, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return this.shortCircuitBuilder(builder);
        }
        return builder.sub().customField(customFieldId).eq(name).and().project(ids.toArray(new Long[ids.size()])).endsub();
    }

    private JqlClauseBuilder addOrganisationsInClause(CheckedUser user, JqlClauseBuilder builder, boolean addOrClause) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.shortCircuitBuilder(builder);
        }
        List organizationProjectsLists = this.organisationMemberManager.getOrganizationProjectLists(user).stream().filter(orgProject -> !orgProject.getProjectIds().isEmpty()).collect(Collectors.toList());
        if (organizationProjectsLists.isEmpty()) {
            if (addOrClause) {
                return builder;
            }
            return this.shortCircuitBuilder(builder);
        }
        CustomField organisationCustomField = this.getCustomField();
        if (addOrClause) {
            builder.or();
        } else {
            builder.defaultAnd();
        }
        for (int i = 0; i < organizationProjectsLists.size(); ++i) {
            OrganizationProjectsList item = (OrganizationProjectsList)organizationProjectsLists.get(i);
            this.buildOrganisationCustomFieldClause(builder, organisationCustomField.getIdAsLong(), item.getOrganizationName(), item.getProjectIds());
            if (i >= organizationProjectsLists.size() - 1) continue;
            builder.or();
        }
        return builder;
    }

    private JqlClauseBuilder shortCircuitBuilder(JqlClauseBuilder builder) {
        return builder.sub().summary().isEmpty().and().summary().isNotEmpty().endsub();
    }

    private boolean userIsInOrganisation(CheckedUser user, Option<Integer> sharedWithOrganisationId) {
        return (Boolean)sharedWithOrganisationId.map(id -> this.organisationMemberManager.getOrganizationsForUser(user).stream().anyMatch(customerOrganisation -> id.intValue() == customerOrganisation.getId())).getOrElse((Object)false);
    }

    private Option<String> getOrganisationName(int sharedWithOrganisationId) {
        return this.customerOrganizationManager.getOrganizationById(sharedWithOrganisationId).toOption().map(CustomerOrganization::getName);
    }

    private Long getOrganisationCustomFieldId() {
        return this.getCustomField().getIdAsLong();
    }

    private CustomField getCustomField() {
        return (CustomField)this.customerOrganizationsCFManager.getOrCreateOrganizationsCF().get();
    }

    private void addApproverTypeFilter(CheckedUser user, JqlClauseBuilder whereClauseBuilder, ApprovalQueryType approvalQueryType, CustomField approvalCustomField) {
        String username = user.forJIRA().getUsername();
        String approvalFunctionName = this.getApprovalFunctionNameBasedOnQueryType(approvalQueryType);
        whereClauseBuilder.addFunctionCondition(approvalCustomField.getClauseNames().getPrimaryName(), Operator.EQUALS, approvalFunctionName, new String[]{username});
    }

    private Option<CustomField> getApprovalCustomField() {
        return this.approvalCustomFieldHelper.getApprovalCustomField();
    }

    private String getApprovalFunctionNameBasedOnQueryType(ApprovalQueryType approvalQueryType) {
        switch (approvalQueryType) {
            case MY_HISTORY_APPROVAL: {
                return ApprovalPluginInfo.MY_APPROVAL_SEARCH_FUNCTION_NAME;
            }
            case MY_PENDING_APPROVAL: {
                return ApprovalPluginInfo.MY_PENDING_APPROVAL_SEARCH_FUNCTION_NAME;
            }
        }
        throw new IllegalArgumentException("Unknown approval query type");
    }
}

