/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.list;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.pocketknife.api.search.issue.service.IssueDataService;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalListProvider;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalListSearchQueryFactory;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerOrganisationWithOpenRequestCount;
import com.atlassian.servicedesk.internal.feature.customer.request.MultiPortalSearchResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.AllVisiblePortals;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalListFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalQueryType;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalsAndRequestTypesResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListSearchQueryFactory;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListSearchResultsFactory;
import com.atlassian.servicedesk.internal.feature.customer.request.list.TextSearchFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.VpOriginAndProjectIdDataCallback;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestListProviderImpl
implements RequestListProvider,
ApprovalListProvider {
    private static final Logger logger = LoggerFactory.getLogger(RequestListProviderImpl.class);
    private final SearchService searchService;
    private final RequestListSearchResultsFactory requestListSearchResultsFactory;
    private final RequestListSearchQueryFactory requestListSearchQueryHelper;
    private final IssueDataService issueDataService;
    private final VpOriginManager vpOriginManager;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final RequestTypeInternalManager requestTypeInternalManager;
    private final InternalPortalService internalPortalService;
    private final ApprovalListSearchQueryFactory approvalListSearchQueryFactory;
    private final CustomerOrganizationMemberService customerOrganizationMemberService;

    @Autowired
    public RequestListProviderImpl(SearchService searchService, RequestListSearchResultsFactory requestListSearchResultsFactory, RequestListSearchQueryFactory requestListSearchQueryHelper, IssueDataService issueDataService, VpOriginManager vpOriginManager, VpOriginCustomFieldService vpOriginCustomFieldService, RequestTypeInternalManager requestTypeInternalManager, InternalPortalService internalPortalService, ApprovalListSearchQueryFactory approvalListSearchQueryFactory, CustomerOrganizationMemberService customerOrganizationMemberService) {
        this.searchService = searchService;
        this.requestListSearchResultsFactory = requestListSearchResultsFactory;
        this.requestListSearchQueryHelper = requestListSearchQueryHelper;
        this.issueDataService = issueDataService;
        this.vpOriginManager = vpOriginManager;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.requestTypeInternalManager = requestTypeInternalManager;
        this.internalPortalService = internalPortalService;
        this.approvalListSearchQueryFactory = approvalListSearchQueryFactory;
        this.customerOrganizationMemberService = customerOrganizationMemberService;
    }

    @Override
    public List<Issue> searchForCustomerRequestsAPI(CheckedUser user, CustomerRequestQuery.REQUEST_OWNERSHIP requestOwnership, CustomerRequestQuery.REQUEST_STATUS status, Option<Portal> portal, Option<RequestType> requestType, Option<String> searchFilter, Option<PagerFilter> pagerFilterOption) {
        RequestListFilter requestListFilter;
        AllVisiblePortals allVisiblePortals = this.requestListSearchQueryHelper.getAllVisiblePortals(user);
        Option<Query> queryOption = this.requestListSearchQueryHelper.getRequestListQuery(user, allVisiblePortals, requestListFilter = RequestListFilter.getBuilder().status(status).ownership(requestOwnership).text(TextSearchFilter.summaryAndIssueKeyFilter((String)searchFilter.getOrElse((Object)""))).portal((Portal)portal.getOrNull()).requestType((RequestType)requestType.getOrNull()).build());
        if (queryOption.isEmpty()) {
            return Collections.emptyList();
        }
        PagerFilter pagerFilter = (PagerFilter)pagerFilterOption.getOrElse((Object)PagerFilter.getUnlimitedFilter());
        try {
            SearchResults searchResults = this.searchService.search(user.forJIRA(), (Query)queryOption.get(), pagerFilter);
            return searchResults.getIssues();
        }
        catch (SearchException e) {
            logger.error("Error search for customer requests");
            return Collections.emptyList();
        }
    }

    @Override
    public long getOpenRequestsCountForUser(CheckedUser user) throws SearchException {
        return this.getOpenRequestsCountForUser(user, (Option<Portal>)Option.none());
    }

    @Override
    public long getOpenRequestsCountForUser(CheckedUser user, Option<Portal> portalOption) throws SearchException {
        return this.getOpenRequestsCountForUserOverrideSecurity(user, portalOption);
    }

    @Override
    public List<CustomerOrganisationWithOpenRequestCount> getCustomerOrganisationsOpenRequestsCountForUser(CheckedUser user) {
        Collection organisations = (Collection)this.customerOrganizationMemberService.getMyOrganizations(user).getOrElse(Collections.emptyList());
        AllVisiblePortals allVisiblePortals = this.getAllVisiblePortals(user);
        ImmutableList.Builder result = ImmutableList.builder();
        try {
            for (CustomerOrganization org : organisations) {
                CustomerOrganisationWithOpenRequestCount organisationOpenRequestsCount = this.getOrganisationOpenRequestsCount(user, org, allVisiblePortals);
                result.add((Object)organisationOpenRequestsCount);
            }
        }
        catch (SearchException e) {
            logger.error("Error searching for customer requests", (Throwable)e);
            return Collections.emptyList();
        }
        return result.build();
    }

    @Override
    public AllVisiblePortals getAllVisiblePortals(CheckedUser user) {
        return this.requestListSearchQueryHelper.getAllVisiblePortals(user);
    }

    @Override
    @Nonnull
    public MultiPortalSearchResult getCustomerRequests(CheckedUser user, RequestListFilter filter2, PagerFilter pager) {
        AllVisiblePortals portals = this.getAllVisiblePortals(user);
        return this.getCustomerRequests(user, portals, filter2, pager);
    }

    @Override
    @Nonnull
    public MultiPortalSearchResult getCustomerRequests(CheckedUser user, AllVisiblePortals allVisiblePortals, RequestListFilter filter2, PagerFilter pager) {
        Option<Query> queryOption = this.requestListSearchQueryHelper.getRequestListQuery(user, allVisiblePortals, filter2);
        return this.getCustomerRequestsBasedOnQuery(user, queryOption, pager);
    }

    @Override
    @Nonnull
    public MultiPortalSearchResult getCustomerRequests(CheckedUser user, AllVisiblePortals allVisiblePortals, ApprovalListFilter approvalListFilter, PagerFilter pager) {
        Option<Query> query = this.approvalListSearchQueryFactory.getRequestListQueryBasedOnApprovalFilter(user, allVisiblePortals, approvalListFilter);
        return this.getCustomerRequestsBasedOnQuery(user, query, pager);
    }

    @Override
    public PortalsAndRequestTypesResult getPortalsAndRequestTypes(CheckedUser user, AllVisiblePortals allVisiblePortals, ApprovalListFilter filter2) {
        Option<Query> queryOption = this.approvalListSearchQueryFactory.getRequestListQueryBasedOnApprovalFilter(user, allVisiblePortals, filter2);
        PortalsAndRequestTypesResult result = (PortalsAndRequestTypesResult)queryOption.fold(() -> new PortalsAndRequestTypesResult(Collections.emptySet()), query -> this.searchPortalAndRequestTypes(user, allVisiblePortals, (Query)query));
        return result;
    }

    @Override
    @Nonnull
    public long getApprovalCount(CheckedUser user, ApprovalQueryType type) {
        ApprovalListFilter approvalListFilter;
        AllVisiblePortals allVisiblePortals = this.getAllVisiblePortals(user);
        Option<Query> queryOpt = this.approvalListSearchQueryFactory.getRequestListQueryBasedOnApprovalFilter(user, allVisiblePortals, approvalListFilter = ApprovalListFilter.getBuilder().approvalQueryType(type).build());
        if (queryOpt.isEmpty()) {
            return 0L;
        }
        try {
            return this.searchService.searchCount(user.forJIRA(), (Query)queryOpt.get());
        }
        catch (SearchException e) {
            logger.error("Error searching for customer requests", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public PortalsAndRequestTypesResult getPortalsAndRequestTypes(CheckedUser user, AllVisiblePortals allVisiblePortals, RequestListFilter filter2) {
        Option<Query> queryOpt = this.requestListSearchQueryHelper.getRequestListQuery(user, allVisiblePortals, filter2);
        PortalsAndRequestTypesResult result = (PortalsAndRequestTypesResult)queryOpt.fold(() -> new PortalsAndRequestTypesResult(Collections.emptySet()), query -> this.searchPortalAndRequestTypes(user, allVisiblePortals, (Query)query));
        return result;
    }

    private CustomerOrganisationWithOpenRequestCount getOrganisationOpenRequestsCount(CheckedUser user, CustomerOrganization org, AllVisiblePortals allVisiblePortals) throws SearchException {
        RequestListFilter organisationOpenRequestFilter = RequestListFilter.getBuilder().ownership(CustomerRequestQuery.REQUEST_OWNERSHIP.ORGANIZATION).status(CustomerRequestQuery.REQUEST_STATUS.OPEN_REQUESTS).sharedWithOrganisation(org.getId()).build();
        Option<Query> queryOption = this.requestListSearchQueryHelper.getRequestListQuery(user, allVisiblePortals, organisationOpenRequestFilter);
        if (queryOption.isEmpty()) {
            return new CustomerOrganisationWithOpenRequestCount(org, 0L);
        }
        long count = this.doCountSearchOverrideSecurity(user, (Query)queryOption.get());
        return new CustomerOrganisationWithOpenRequestCount(org, count);
    }

    private MultiPortalSearchResult getCustomerRequestsBasedOnQuery(CheckedUser user, Option<Query> queryOption, PagerFilter pager) {
        if (queryOption.isEmpty()) {
            return new MultiPortalSearchResult(Collections.emptyList(), 0);
        }
        try {
            Query query = (Query)queryOption.get();
            SearchResults searchResults = this.searchService.search(user.forJIRA(), query, pager);
            return this.requestListSearchResultsFactory.buildSearchResult(user, searchResults);
        }
        catch (SearchException e) {
            logger.error("Error searching for customer requests", (Throwable)e);
            return new MultiPortalSearchResult(Collections.emptyList(), 0);
        }
    }

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
    private PortalsAndRequestTypesResult searchPortalAndRequestTypes(CheckedUser checkedUser, AllVisiblePortals allVisiblePortals, Query query) {
        CustomField vpOriginCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        VpOriginAndProjectIdDataCallback callback = new VpOriginAndProjectIdDataCallback(vpOriginCustomField);
        this.issueDataService.find(checkedUser.forJIRA(), query, (DataCallback)callback);
        return this.getPortalsAndRequestTypes(allVisiblePortals, callback.getVpOriginValues(), callback.getProjectIds());
    }

    private PortalsAndRequestTypesResult getPortalsAndRequestTypes(AllVisiblePortals portals, Set<String> vpOriginValues, Set<Long> projectIds) {
        List<RequestType> requestTypes = this.requestTypeInternalManager.getRequestTypesByPortalIds(portals.getPortalIds());
        Map<VpOrigin, PortalAndRequestType> validOriginLookup = this.buildVpOriginLookupForRequestTypes(portals, requestTypes);
        Set<Portal> portalsWithIssues = this.getPortalsByProjectIds(portals, projectIds);
        Set<VpOrigin> vpOrigins = this.toVpOrigin(vpOriginValues);
        return this.getPortalsAndRequestTypes(portalsWithIssues, vpOrigins, validOriginLookup);
    }

    private Map<VpOrigin, PortalAndRequestType> buildVpOriginLookupForRequestTypes(AllVisiblePortals portals, List<RequestType> requestTypes) {
        HashMap portalById = new HashMap();
        portals.getAllVisiblePortals().forEach(portal -> portalById.put(portal.getId(), portal));
        HashMap<VpOrigin, PortalAndRequestType> originLookup = new HashMap<VpOrigin, PortalAndRequestType>();
        for (RequestType requestType : requestTypes) {
            VpOrigin vpOrigin;
            long portalId = requestType.getPortalId();
            int portalIdInt = (int)portalId;
            Portal portal2 = (Portal)portalById.get(portalIdInt);
            if (portal2 == null || (vpOrigin = this.vpOriginManager.getVpOriginForRequestType(portal2, requestType)) == null) continue;
            originLookup.put(vpOrigin, new PortalAndRequestType(portal2, requestType));
        }
        return originLookup;
    }

    private Set<VpOrigin> toVpOrigin(Set<String> vpOriginValues) {
        HashSet<VpOrigin> vpOrigins = new HashSet<VpOrigin>();
        for (String vpOriginString : vpOriginValues) {
            VpOrigin vpOrigin = this.vpOriginManager.fromDbFormatUnchecked(vpOriginString);
            if (vpOrigin == null) continue;
            vpOrigins.add(vpOrigin);
        }
        return vpOrigins;
    }

    private Set<Portal> getPortalsByProjectIds(AllVisiblePortals allVisiblePortals, Set<Long> projectIds) {
        HashSet<Portal> portals = new HashSet<Portal>();
        allVisiblePortals.getAllVisiblePortals().forEach(portal -> {
            PortalInternal portalInternal = this.internalPortalService.toPortalInternal((Portal)portal);
            if (projectIds.contains(portalInternal.getProjectId())) {
                portals.add((Portal)portal);
            }
        });
        return portals;
    }

    private PortalsAndRequestTypesResult getPortalsAndRequestTypes(Set<Portal> portals, Set<VpOrigin> vpOrigins, Map<VpOrigin, PortalAndRequestType> originLookup) {
        HashMap<Portal, HashSet<RequestType>> portalToRequestTypes = new HashMap<Portal, HashSet<RequestType>>();
        portals.forEach(portal -> {
            Set cfr_ignored_0 = portalToRequestTypes.put((Portal)portal, new HashSet());
        });
        for (VpOrigin vpOrigin : vpOrigins) {
            PortalAndRequestType portalAndRequestType = originLookup.get(vpOrigin);
            if (portalAndRequestType == null) continue;
            Portal portal2 = portalAndRequestType.getPortal();
            HashSet<RequestType> requestTypesForPortal = (HashSet<RequestType>)portalToRequestTypes.get(portal2);
            if (requestTypesForPortal == null) {
                requestTypesForPortal = new HashSet<RequestType>();
                portalToRequestTypes.put(portal2, requestTypesForPortal);
            }
            requestTypesForPortal.add(portalAndRequestType.getRequestType());
        }
        HashSet<PortalsAndRequestTypesResult.PortalWithRequestTypes> portalWithRequestTypes = new HashSet<PortalsAndRequestTypesResult.PortalWithRequestTypes>();
        for (Map.Entry entries : portalToRequestTypes.entrySet()) {
            portalWithRequestTypes.add(new PortalsAndRequestTypesResult.PortalWithRequestTypes((Portal)entries.getKey(), (Set)entries.getValue()));
        }
        return new PortalsAndRequestTypesResult(portalWithRequestTypes);
    }

    private long getOpenRequestsCountForUserOverrideSecurity(CheckedUser user, Option<Portal> portalOption) throws SearchException {
        RequestListFilter requestListFilter;
        AllVisiblePortals allVisiblePortals = this.requestListSearchQueryHelper.getAllVisiblePortals(user);
        Option<Query> queryOption = this.requestListSearchQueryHelper.getRequestListQuery(user, allVisiblePortals, requestListFilter = RequestListFilter.getBuilder().ownership(CustomerRequestQuery.REQUEST_OWNERSHIP.OWNED_REQUESTS).status(CustomerRequestQuery.REQUEST_STATUS.OPEN_REQUESTS).portal((Portal)portalOption.getOrNull()).build());
        if (queryOption.isEmpty()) {
            return 0L;
        }
        return this.doCountSearchOverrideSecurity(user, (Query)queryOption.get());
    }

    private long doCountSearchOverrideSecurity(CheckedUser user, Query query) throws SearchException {
        return this.searchService.searchCountOverrideSecurity(user.forJIRA(), query);
    }

    private class PortalAndRequestType {
        Portal portal;
        RequestType requestType;

        public PortalAndRequestType(Portal portal, RequestType requestType) {
            this.portal = portal;
            this.requestType = requestType;
        }

        public Portal getPortal() {
            return this.portal;
        }

        public RequestType getRequestType() {
            return this.requestType;
        }
    }
}

