/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.list;

import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.TextSearchFilter;
import io.atlassian.fugue.Option;

public class RequestListFilter {
    private CustomerRequestQuery.REQUEST_STATUS status;
    private CustomerRequestQuery.REQUEST_OWNERSHIP ownership;
    private final PortalRequestTypeFilter portalRequestTypeFilter;
    private final Option<TextSearchFilter> textFilter;
    private final Option<Integer> sharedWithOrganisationId;

    public RequestListFilter(Option<TextSearchFilter> textFilter, CustomerRequestQuery.REQUEST_STATUS status, CustomerRequestQuery.REQUEST_OWNERSHIP ownership, PortalRequestTypeFilter portalRequestTypeFilter, Option<Integer> sharedWithOrganisationId) {
        this.textFilter = textFilter;
        this.status = status;
        this.ownership = ownership;
        this.portalRequestTypeFilter = portalRequestTypeFilter;
        this.sharedWithOrganisationId = sharedWithOrganisationId;
    }

    public CustomerRequestQuery.REQUEST_STATUS getStatus() {
        return this.status;
    }

    public CustomerRequestQuery.REQUEST_OWNERSHIP getOwnership() {
        return this.ownership;
    }

    public PortalRequestTypeFilter getPortalRequestTypeFilter() {
        return this.portalRequestTypeFilter;
    }

    public Option<TextSearchFilter> getTextFilter() {
        return this.textFilter;
    }

    public Option<Integer> getSharedWithOrganisationId() {
        return this.sharedWithOrganisationId;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TextSearchFilter text;
        private CustomerRequestQuery.REQUEST_STATUS status;
        private CustomerRequestQuery.REQUEST_OWNERSHIP ownership;
        private Portal portal;
        private RequestType requestType;
        private Integer sharedWithOrganisationId;

        public RequestListFilter build() {
            if (this.status == null) {
                throw new RuntimeException("request status filter must be specified");
            }
            if (this.ownership == null) {
                throw new RuntimeException("ownership filter must be specified");
            }
            return new RequestListFilter((Option<TextSearchFilter>)Option.option((Object)this.text), this.status, this.ownership, new PortalRequestTypeFilter(this.portal, this.requestType), (Option<Integer>)Option.option((Object)this.sharedWithOrganisationId));
        }

        public Builder text(TextSearchFilter text) {
            this.text = text;
            return this;
        }

        public Builder ownership(CustomerRequestQuery.REQUEST_OWNERSHIP ownership) {
            this.ownership = ownership;
            return this;
        }

        public Builder status(CustomerRequestQuery.REQUEST_STATUS status) {
            this.status = status;
            return this;
        }

        public Builder portal(Portal portal) {
            this.portal = portal;
            return this;
        }

        public Builder requestType(RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder portalRequestType(PortalRequestTypeFilter filter2) {
            this.portal = (Portal)filter2.getPortal().getOrNull();
            this.requestType = (RequestType)filter2.getRequestType().getOrNull();
            return this;
        }

        public Builder sharedWithOrganisation(Integer organisationId) {
            this.sharedWithOrganisationId = organisationId;
            return this;
        }
    }
}

