/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.list;

import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.MultiPortalSearchResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalsAndRequestTypesResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListItem;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListPageResponse;
import com.atlassian.servicedesk.internal.rest.responses.PortalRequestTypes;
import com.atlassian.servicedesk.internal.rest.responses.RequestListItemResponse;
import com.atlassian.servicedesk.internal.rest.responses.RequestTypeSelectItem;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalRequestListUtil {
    private CustomerUrlUtil customerUrlUtil;

    @Autowired
    public PortalRequestListUtil(CustomerUrlUtil customerUrlUtil) {
        this.customerUrlUtil = customerUrlUtil;
    }

    public PortalRequestTypeFilter validateSelectedPortalAndRequestType(List<PortalRequestTypes> portalRequestTypes, Option<Portal> portalOpt, Option<RequestType> requestTypeOpt) {
        if (portalOpt.isEmpty()) {
            return new PortalRequestTypeFilter();
        }
        Portal portal = (Portal)portalOpt.get();
        String portalId = String.valueOf(portal.getId());
        for (PortalRequestTypes prt : portalRequestTypes) {
            if (!prt.getId().equals(portalId)) continue;
            if (requestTypeOpt.isEmpty()) {
                return new PortalRequestTypeFilter(portal);
            }
            RequestType requestType = (RequestType)requestTypeOpt.get();
            String requestTypeId = String.valueOf(requestType.getId());
            for (RequestTypeSelectItem rt : prt.getRequestTypes()) {
                if (!rt.getValue().equals(requestTypeId)) continue;
                return new PortalRequestTypeFilter(portal, requestType);
            }
            return new PortalRequestTypeFilter(portal);
        }
        return new PortalRequestTypeFilter();
    }

    public List<PortalRequestTypes> toPortalRequestTypesResponse(PortalsAndRequestTypesResult portalsAndRequestTypes) {
        ArrayList<PortalRequestTypes> portals = new ArrayList<PortalRequestTypes>();
        for (PortalsAndRequestTypesResult.PortalWithRequestTypes portalWithRequestsTypes : portalsAndRequestTypes.getPortalWithRequestTypes()) {
            Portal portal = portalWithRequestsTypes.getPortal();
            Set<RequestType> requestTypes = portalWithRequestsTypes.getRequestTypes();
            PortalRequestTypes prt = new PortalRequestTypes(String.valueOf(portal.getId()), portal.getName());
            for (RequestType requestType : requestTypes) {
                prt.addRequestType(String.valueOf(requestType.getId()), requestType.getName(), requestType.getIconId());
            }
            portals.add(prt);
        }
        return portals;
    }

    public List<RequestListItemResponse> buildRequestListItemResponses(MultiPortalSearchResult multiPortalSearchResult) {
        List<MultiPortalSearchResult.PortalRequestListItemView> itemViewsWithPortals = multiPortalSearchResult.getResultList();
        ArrayList result = Lists.newArrayList();
        for (MultiPortalSearchResult.PortalRequestListItemView item : itemViewsWithPortals) {
            result.add(this.buildRequestListItemResponse(item));
        }
        return result;
    }

    private RequestListItemResponse buildRequestListItemResponse(MultiPortalSearchResult.PortalRequestListItemView item) {
        Portal portal = item.getPortal();
        RequestListItem requestListItemView = item.getRequestListItem();
        return new RequestListItemResponse(requestListItemView, portal.getName(), this.customerUrlUtil.getPortalUrlSimple(portal));
    }

    public RequestListPageResponse getRequestListPageResponse(MultiPortalSearchResult multiPortalSearchResult, int resultsPerPage) {
        List<RequestListItemResponse> requests = this.buildRequestListItemResponses(multiPortalSearchResult);
        int pageCount = (int)Math.ceil((double)multiPortalSearchResult.getTotalIssueCount() / (double)resultsPerPage);
        pageCount = Math.max(pageCount, 1);
        int totalIssueCount = multiPortalSearchResult.getTotalIssueCount();
        return new RequestListPageResponse(resultsPerPage, totalIssueCount, pageCount, requests);
    }

    public PagerFilter createPager(int selectedPage, int resultsPerPage) {
        int sanitizedPage = selectedPage > 0 ? selectedPage : 1;
        int startIndex = (sanitizedPage - 1) * resultsPerPage;
        return PagerFilter.newPageAlignedFilter((int)startIndex, (int)resultsPerPage);
    }

    public String getPortalId(PortalRequestTypeFilter portalRequestTypeFilter) {
        Option<Portal> portalOption = portalRequestTypeFilter.getPortal();
        return (String)portalOption.map(Portal::getId).map(String::valueOf).getOrElse((Object)"");
    }

    public String getRequestTypeId(PortalRequestTypeFilter portalRequestTypeFilter) {
        Option<RequestType> requestTypeOption = portalRequestTypeFilter.getRequestType();
        return (String)requestTypeOption.map(RequestType::getId).map(String::valueOf).getOrElse((Object)"");
    }
}

