/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.list;

import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalQueryType;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.TextSearchFilter;
import io.atlassian.fugue.Option;

public class ApprovalListFilter {
    private final ApprovalQueryType approvalQueryType;
    private final PortalRequestTypeFilter portalRequestTypeFilter;
    private final Option<TextSearchFilter> textFilter;

    public ApprovalListFilter(ApprovalQueryType approvalQueryType, PortalRequestTypeFilter portalRequestTypeFilter, Option<TextSearchFilter> textFilter) {
        this.approvalQueryType = approvalQueryType;
        this.portalRequestTypeFilter = portalRequestTypeFilter;
        this.textFilter = textFilter;
    }

    public ApprovalQueryType getApprovalQueryType() {
        return this.approvalQueryType;
    }

    public PortalRequestTypeFilter getPortalRequestTypeFilter() {
        return this.portalRequestTypeFilter;
    }

    public Option<TextSearchFilter> getTextFilter() {
        return this.textFilter;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TextSearchFilter text;
        private Portal portal;
        private RequestType requestType;
        private ApprovalQueryType approvalQueryType;

        public ApprovalListFilter build() {
            if (this.approvalQueryType == null) {
                throw new RuntimeException("Approval Query Type must be specified");
            }
            return new ApprovalListFilter(this.approvalQueryType, new PortalRequestTypeFilter(this.portal, this.requestType), (Option<TextSearchFilter>)Option.option((Object)this.text));
        }

        public Builder text(TextSearchFilter text) {
            this.text = text;
            return this;
        }

        public Builder portal(Portal portal) {
            this.portal = portal;
            return this;
        }

        public Builder requestType(RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder portalRequestType(PortalRequestTypeFilter filter2) {
            this.portal = (Portal)filter2.getPortal().getOrNull();
            this.requestType = (RequestType)filter2.getRequestType().getOrNull();
            return this;
        }

        public Builder approvalQueryType(ApprovalQueryType approvalQueryType) {
            this.approvalQueryType = approvalQueryType;
            return this;
        }
    }
}

