/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.request.avatar.SDAgentAvatarManager;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDAgentAvatarManagerImpl
implements SDAgentAvatarManager {
    private static final Logger log = LoggerFactory.getLogger(SDAgentAvatarManager.class);
    private static final String AVATAR_RESOURCE_LINK = "/servicedesk/customer/avatar/";
    private static final String URL_ENCODED = "UTF-8";
    private static final String AVATAR_KEY = "avatarId";
    private static final String SIZE_KEY = "size";
    private static final String FORMAT_KEY = "format";
    private final CustomerUrlUtil customerUrlUtil;
    private final UserFactory userFactory;
    private final AvatarService avatarService;
    private final AvatarManager avatarManager;

    @Autowired
    public SDAgentAvatarManagerImpl(CustomerUrlUtil customerUrlUtil, AvatarService avatarService, AvatarManager avatarManager, UserFactory userFactory) {
        this.customerUrlUtil = customerUrlUtil;
        this.avatarService = avatarService;
        this.avatarManager = avatarManager;
        this.userFactory = userFactory;
    }

    @Override
    public Option<Avatar> getAvatar(Long avatarId) {
        return Option.option((Object)this.avatarManager.getById(avatarId));
    }

    @Override
    public Option<Avatar> getDefaultAvatar() {
        return Option.option((Object)this.avatarManager.getDefaultAvatar(IconType.USER_ICON_TYPE));
    }

    @Override
    public String processAvatarRequest(ApplicationUser avatarUser, Avatar.Size size) {
        return this.doProcessAvatarRequest((Option<ApplicationUser>)Option.option((Object)avatarUser), size, (Option<Long>)Option.none());
    }

    @Override
    public String processDefaultAvatarRequest(Avatar.Size size) {
        return this.doProcessAvatarRequest((Option<ApplicationUser>)Option.none(), size, (Option<Long>)Option.option((Object)this.avatarManager.getDefaultAvatarId(IconType.USER_ICON_TYPE)));
    }

    private String doProcessAvatarRequest(Option<ApplicationUser> avatarUserOpt, Avatar.Size size, Option<Long> overrideAvatarId) {
        Option<String> convertedLink;
        ApplicationUser avatarUser = (ApplicationUser)avatarUserOpt.getOrNull();
        String absoluteAvatarUrl = this.avatarService.getAvatarUrlNoPermCheck(avatarUser, size).toString();
        if (!this.avatarService.isUsingExternalAvatar(avatarUser, avatarUser) && (convertedLink = this.replaceJiraAvatarUrlsWithPortalAvatarUrls(absoluteAvatarUrl, overrideAvatarId)).isDefined()) {
            absoluteAvatarUrl = (String)convertedLink.get();
        }
        return absoluteAvatarUrl;
    }

    @VisibleForTesting
    Option<String> replaceJiraAvatarUrlsWithPortalAvatarUrls(String link, Option<Long> overrideAvatarId) {
        try {
            if (this.userFactory.getUncheckedUser().isAnonymous()) {
                return Option.none();
            }
            String avatarId = null;
            HashMap queryParams = Maps.newHashMap();
            List params = URLEncodedUtils.parse((URI)new URI(link), (String)URL_ENCODED);
            for (NameValuePair pair : params) {
                String queryParamName = pair.getName();
                String queryParamValue = pair.getValue();
                if (StringUtils.isBlank((String)queryParamName) || StringUtils.isBlank((String)queryParamValue)) continue;
                switch (queryParamName) {
                    case "avatarId": {
                        avatarId = queryParamValue;
                        break;
                    }
                    case "size": {
                        queryParams.put(SIZE_KEY, queryParamValue);
                        break;
                    }
                    case "format": {
                        queryParams.put(FORMAT_KEY, queryParamValue);
                    }
                }
            }
            if (StringUtils.isBlank(avatarId)) {
                return Option.none();
            }
            UriBuilder convertedUrBuilder = UriBuilder.fromUri((String)this.customerUrlUtil.getRestUrl(false)).path(AVATAR_RESOURCE_LINK);
            if (overrideAvatarId.isDefined()) {
                convertedUrBuilder.path(((Long)overrideAvatarId.get()).toString());
            } else {
                convertedUrBuilder.path(avatarId);
            }
            queryParams.forEach((x$0, xva$1) -> convertedUrBuilder.queryParam(x$0, new Object[]{xva$1}));
            return Option.some((Object)convertedUrBuilder.build(new Object[0]).toString());
        }
        catch (URISyntaxException e) {
            log.error("Invalid base URL syntax", (Throwable)e);
            return Option.none();
        }
    }
}

