/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses;

import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.request.activitystream.items.ActivityItem;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerTextInternalRenderer;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.ActivityItemResponse;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.ActivityResponseManager;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.ApprovalCreatedItem;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.ApproverDecisionItem;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.RequesterCommentItem;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.ResolutionUpdateItem;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.StatusUpdateItem;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.WorkerCommentItem;
import com.atlassian.servicedesk.internal.feature.customer.request.avatar.SDAgentAvatarManager;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ApprovalCreatedActivityItem;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ApproverDecisionActivityItem;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.CommentActivityItem;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ResolutionUpdateActivityItem;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.StatusUpdateActivityItem;
import com.atlassian.servicedesk.internal.utils.DateFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityResponseManagerImpl
implements ActivityResponseManager {
    private static final String REPORTER_COMMENT_ACTIVITY_ITEM_TEMPLATE = "requester-comment";
    private static final String AGENT_COMMENT_ACTIVITY_ITEM_TEMPLATE = "worker-comment";
    private static final String STATUS_ACTIVITY_ITEM_TEMPLATE = "status-update";
    private static final String RESOLUTION_ACTIVITY_ITEM_TEMPLATE = "resolution-update";
    private static final String APPROVAL_CREATED_ACTIVITY_ITEM_TEMPLATE = "approval-created";
    private static final String APPROVER_DECISION_ACTIVITY_ITEM_TEMPLATE = "approver-decision";
    private final SDAgentAvatarManager sdAgentAvatarManager;
    private final CustomerTextInternalRenderer requestCommentRenderer;
    private final I18nHelper i18nHelper;
    private final UserFactory userFactory;

    @Autowired
    public ActivityResponseManagerImpl(SDAgentAvatarManager sdAgentAvatarManager, CustomerTextInternalRenderer requestCommentRenderer, I18nHelper i18nHelper, UserFactory userFactory) {
        this.sdAgentAvatarManager = sdAgentAvatarManager;
        this.requestCommentRenderer = requestCommentRenderer;
        this.i18nHelper = i18nHelper;
        this.userFactory = userFactory;
    }

    @Override
    public List<ActivityItemResponse> getResponses(ApplicationUser user, List<ActivityItem> items, DateFormatter dateFormatter) {
        ArrayList<ActivityItemResponse> responses = new ArrayList<ActivityItemResponse>();
        for (ActivityItem item : items) {
            ActivityItemResponse response = this.getResponse(user, item, dateFormatter);
            responses.add(response);
        }
        return responses;
    }

    @Override
    public ActivityItemResponse getResponse(ApplicationUser user, ActivityItem item, DateFormatter dateFormatter) {
        if (item instanceof CommentActivityItem) {
            return this.buildCommentResponse(user, (CommentActivityItem)item, dateFormatter);
        }
        if (item instanceof StatusUpdateActivityItem) {
            return this.buildStatusUpdateResponse((StatusUpdateActivityItem)item, dateFormatter);
        }
        if (item instanceof ResolutionUpdateActivityItem) {
            return this.buildResolutionUpdateResponse((ResolutionUpdateActivityItem)item, dateFormatter);
        }
        if (item instanceof ApprovalCreatedActivityItem) {
            return this.buildApprovalCreatedResponse((ApprovalCreatedActivityItem)item, dateFormatter);
        }
        if (item instanceof ApproverDecisionActivityItem) {
            return this.buildApproverDecisionResponse((ApproverDecisionActivityItem)item, dateFormatter);
        }
        throw new IllegalArgumentException("unsupported activity type");
    }

    private ActivityItemResponse buildCommentResponse(ApplicationUser user, CommentActivityItem activity, DateFormatter dateFormatter) {
        Comment comment = activity.getComment();
        String longDate = this.getTimeAsString(dateFormatter, comment.getCreated());
        String prettyDate = this.getTimeRelativeAsString(dateFormatter, comment.getCreated());
        String avatarUrl = this.sdAgentAvatarManager.processAvatarRequest(comment.getAuthorApplicationUser(), Avatar.Size.LARGE);
        io.atlassian.fugue.Option checkedUser = StepsConverters.newerOption((Option)this.userFactory.wrap(user).toOption());
        String renderedComment = this.requestCommentRenderer.renderComment(comment, (io.atlassian.fugue.Option<CheckedUser>)checkedUser);
        String author = this.getCommentAuthor(activity);
        if (activity.isReporterComment()) {
            return new RequesterCommentItem(activity.getActivityInstant(), REPORTER_COMMENT_ACTIVITY_ITEM_TEMPLATE, "", longDate, prettyDate, author, avatarUrl, renderedComment, comment.getBody());
        }
        return new WorkerCommentItem(activity.getActivityInstant(), AGENT_COMMENT_ACTIVITY_ITEM_TEMPLATE, "", longDate, prettyDate, author, avatarUrl, comment.getId(), renderedComment, comment.getBody(), activity.isInvisibleToReporter(), activity.isOutsiderComment(), this.getCommentAuthorUserKey(activity), this.getCommentAuthorUsername(activity), activity.canAddAuthorAsParticipant());
    }

    private ActivityItemResponse buildStatusUpdateResponse(StatusUpdateActivityItem activity, DateFormatter dateFormatter) {
        String longDate = this.getTimeAsString(dateFormatter, Date.from(activity.getActivityInstant()));
        String friendlyDate = this.getTimeRelativeAsString(dateFormatter, Date.from(activity.getActivityInstant()));
        return new StatusUpdateItem(activity.getActivityInstant(), STATUS_ACTIVITY_ITEM_TEMPLATE, longDate, friendlyDate, activity.getNewStatusName());
    }

    private ActivityItemResponse buildResolutionUpdateResponse(ResolutionUpdateActivityItem activity, DateFormatter dateFormatter) {
        String longDate = this.getTimeAsString(dateFormatter, Date.from(activity.getActivityInstant()));
        String friendlyDate = this.getTimeRelativeAsString(dateFormatter, Date.from(activity.getActivityInstant()));
        return new ResolutionUpdateItem(activity.getActivityInstant(), RESOLUTION_ACTIVITY_ITEM_TEMPLATE, longDate, friendlyDate, activity.getResolutionName(), (String)activity.getNewStatusName().getOrNull());
    }

    private ActivityItemResponse buildApprovalCreatedResponse(ApprovalCreatedActivityItem activity, DateFormatter dateFormatter) {
        String longDate = this.getTimeAsString(dateFormatter, Date.from(activity.getActivityInstant()));
        String friendlyDate = this.getTimeRelativeAsString(dateFormatter, Date.from(activity.getActivityInstant()));
        return new ApprovalCreatedItem(activity.getActivityInstant(), APPROVAL_CREATED_ACTIVITY_ITEM_TEMPLATE, longDate, friendlyDate, (Integer)activity.getPendingCount().getOrNull());
    }

    private ActivityItemResponse buildApproverDecisionResponse(ApproverDecisionActivityItem activity, DateFormatter dateFormatter) {
        String longDate = this.getTimeAsString(dateFormatter, Date.from(activity.getActivityInstant()));
        String friendlyDate = this.getTimeRelativeAsString(dateFormatter, Date.from(activity.getActivityInstant()));
        String avatarUrl = activity.getApprover().isDefined() ? this.sdAgentAvatarManager.processAvatarRequest((ApplicationUser)activity.getApprover().get(), Avatar.Size.LARGE) : this.sdAgentAvatarManager.processDefaultAvatarRequest(Avatar.Size.LARGE);
        String approverName = activity.getApprover().isDefined() ? ((ApplicationUser)activity.getApprover().get()).getDisplayName() : activity.getApproverUserKey();
        return new ApproverDecisionItem(activity.getActivityInstant(), APPROVER_DECISION_ACTIVITY_ITEM_TEMPLATE, longDate, friendlyDate, approverName, activity.getDecision(), avatarUrl, (Integer)activity.getPendingApproversCount().getOrNull());
    }

    private String getCommentAuthor(CommentActivityItem activity) {
        if (activity.isAnonymousComment()) {
            return this.i18nHelper.getText("sd.common.words.anonymous");
        }
        return activity.getComment().getAuthorApplicationUser().getDisplayName();
    }

    private String getCommentAuthorUserKey(CommentActivityItem activity) {
        if (activity.isAnonymousComment()) {
            return null;
        }
        return activity.getComment().getAuthorApplicationUser().getKey();
    }

    private String getCommentAuthorUsername(CommentActivityItem activity) {
        if (activity.isAnonymousComment()) {
            return null;
        }
        return activity.getComment().getAuthorApplicationUser().getUsername();
    }

    private String getTimeAsString(DateFormatter formatter, Date date) {
        return formatter.getTimeLong(date);
    }

    private String getTimeRelativeAsString(DateFormatter formatter, Date date) {
        return formatter.getTimeRelative(date);
    }
}

