/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.request.activitystream.items.ActivityItem;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusMapper;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.errors.ServiceDeskHttpError;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestStatusImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers.StatusAndResolutionActivityProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalServiceScala;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ActivityItemComparator;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ResolutionUpdateActivityItem;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.StatusUpdateActivityItem;
import com.atlassian.servicedesk.internal.utils.Convert;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import io.atlassian.fugue.Either;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@Component
class StatusAndResolutionActivityProviderImpl
implements StatusAndResolutionActivityProvider {
    private static final String REQUEST_STATUS_MAPPER_CACHE_KEY = StatusAndResolutionActivityProviderImpl.class.getName() + ".requestStatusMapperCacheKey";
    private static final String ACTIVITY_ITEMS_CACHE_KEY = StatusAndResolutionActivityProviderImpl.class.getName() + ".activityItemsCacheKey";
    private final ChangeHistoryManager changeHistoryManager;
    private final RequestTypeInternalServiceScala requestTypeService;
    private final RequestTypeInternalService requestTypeInternalService;
    private final RequestStatusService requestStatusService;
    private final VpOriginManager vpOriginManager;
    private final UserFactory userFactory;
    private final StatusManager statusManager;
    private final RequestCache<String, RequestStatusMapper> requestStatusMapperCache;
    private final RequestCache<String, List<ActivityItem>> activityItemsCache;

    @Autowired
    public StatusAndResolutionActivityProviderImpl(ChangeHistoryManager changeHistoryManager, RequestTypeInternalServiceScala requestTypeService, RequestTypeInternalService requestTypeInternalService, RequestStatusService requestStatusService, VpOriginManager vpOriginManager, UserFactory userFactory, StatusManager statusManager, VCacheFactory vCacheFactory) {
        this.changeHistoryManager = changeHistoryManager;
        this.requestTypeInternalService = requestTypeInternalService;
        this.requestStatusService = requestStatusService;
        this.vpOriginManager = vpOriginManager;
        this.requestTypeService = requestTypeService;
        this.userFactory = userFactory;
        this.statusManager = statusManager;
        this.requestStatusMapperCache = vCacheFactory.getRequestCache(REQUEST_STATUS_MAPPER_CACHE_KEY);
        this.activityItemsCache = vCacheFactory.getRequestCache(ACTIVITY_ITEMS_CACHE_KEY);
    }

    public List<ActivityItem> getActivityStream(ApplicationUser user, Issue issue) {
        return (List)this.activityItemsCache.get((Object)StatusAndResolutionActivityProviderImpl.buildCacheKey(user, issue), () -> {
            RequestStatusMapper statusMapper = this.getRequestStatusMapper(user, issue);
            List<ActivityItem> items = this.buildStatusAndResolutionActivityItems(issue, statusMapper);
            items.sort((Comparator<ActivityItem>)new ActivityItemComparator());
            return items;
        });
    }

    @Override
    public boolean hasVisibleStatusChangedForCustomer(CheckedUser user, Issue issue, Collection<ChangeItemBean> changeItemBeans, Portal portal) {
        io.atlassian.fugue.Option vpOrigin = io.atlassian.fugue.Option.option((Object)this.vpOriginManager.lookup(issue));
        if (vpOrigin.isEmpty()) {
            return false;
        }
        Either<ServiceDeskHttpError, RequestType> requestTypeForIssueWithVpOrigin = Convert.toJavaEither(this.requestTypeService.getRequestTypeByKey(user, ((VpOrigin)vpOrigin.get()).getRequestTypeKey(), issue.getProjectObject(), portal));
        if (requestTypeForIssueWithVpOrigin.isLeft()) {
            return false;
        }
        RequestStatusMapper statusMapper = this.requestStatusService.getStatusMapper((RequestType)requestTypeForIssueWithVpOrigin.right().get());
        CustomerResolutionChange customerResolutionChange = this.extractCustomerResolutionChange(changeItemBeans, statusMapper);
        return customerResolutionChange.newStatusName.isDefined();
    }

    @Override
    public boolean isIssueNew(ApplicationUser user, Issue issue) {
        return this.getActivityStream(user, issue).isEmpty();
    }

    @Override
    public CustomerRequest.CustomerRequestStatus getInitialStatusForIssue(ApplicationUser user, Issue issue) {
        List<ActivityItem> activityStream = this.getActivityStream(user, issue);
        Optional<ActivityItem> firstOldStatusesOnly = activityStream.stream().filter(item -> item instanceof StatusUpdateActivityItem || ((ResolutionUpdateActivityItem)item).getOldStatusName().isDefined()).findFirst();
        return (CustomerRequest.CustomerRequestStatus)io.atlassian.fugue.Option.fromOptional(firstOldStatusesOnly).flatMap(item -> {
            if (item instanceof StatusUpdateActivityItem) {
                return io.atlassian.fugue.Option.some((Object)((StatusUpdateActivityItem)item).getOldStatusName());
            }
            return ((ResolutionUpdateActivityItem)item).getOldStatusName();
        }).map(translatedStatusName -> new CustomerRequestStatusImpl((String)translatedStatusName, issue.getCreated().toInstant())).getOr(() -> this.getCurrentStatusForIssue(user, issue));
    }

    @Override
    public CustomerRequest.CustomerRequestStatus getCurrentStatusForIssue(ApplicationUser user, Issue issue) {
        RequestStatusMapper statusMapper = this.getRequestStatusMapper(user, issue);
        return new CustomerRequestStatusImpl(statusMapper.translateToCustomerStatus(issue.getStatus()), issue.getCreated().toInstant());
    }

    private List<ActivityItem> buildStatusAndResolutionActivityItems(Issue issue, RequestStatusMapper statusMapper) {
        ArrayList<ActivityItem> items = new ArrayList<ActivityItem>();
        for (ChangeHistory change : this.changeHistoryManager.getChangeHistories(issue)) {
            this.extractItem(change, statusMapper).forEach(items::add);
        }
        return items;
    }

    @VisibleForTesting
    io.atlassian.fugue.Option<ActivityItem> extractItem(ChangeHistory change, RequestStatusMapper statusMapper) {
        io.atlassian.fugue.Option<StatusResolutionChange> statusResolutionChangeOpt = this.extractStatusResolutionChange(change, statusMapper);
        if (statusResolutionChangeOpt.isEmpty()) {
            return io.atlassian.fugue.Option.none();
        }
        StatusResolutionChange statusResolutionChange = (StatusResolutionChange)statusResolutionChangeOpt.get();
        if (statusResolutionChange.getResolution().isDefined()) {
            return io.atlassian.fugue.Option.some((Object)new ResolutionUpdateActivityItem(statusResolutionChange.getChangeDate(), (String)statusResolutionChange.getResolution().get(), statusResolutionChange.getNewTranslatedStatusName(), statusResolutionChange.getOldTranslatedStatusName()));
        }
        if (statusResolutionChange.getNewTranslatedStatusName().isDefined()) {
            return io.atlassian.fugue.Option.some((Object)new StatusUpdateActivityItem(statusResolutionChange.getChangeDate(), (String)statusResolutionChange.getNewTranslatedStatusName().get(), (String)statusResolutionChange.getOldTranslatedStatusName().get()));
        }
        return io.atlassian.fugue.Option.none();
    }

    @VisibleForTesting
    io.atlassian.fugue.Option<StatusResolutionChange> extractStatusResolutionChange(ChangeHistory change, RequestStatusMapper statusMapper) {
        if (change.getChangeItemBeans() == null) {
            return io.atlassian.fugue.Option.none();
        }
        CustomerResolutionChange customerResolutionChange = this.extractCustomerResolutionChange(change.getChangeItemBeans(), statusMapper);
        if (customerResolutionChange.newStatusName.isDefined() || customerResolutionChange.resolution.isDefined()) {
            Instant changeDate = change.getTimePerformed() != null ? change.getTimePerformed().toInstant() : null;
            return io.atlassian.fugue.Option.some((Object)new StatusResolutionChange(changeDate, customerResolutionChange));
        }
        return io.atlassian.fugue.Option.none();
    }

    private CustomerResolutionChange extractCustomerResolutionChange(Collection<ChangeItemBean> changeItems, RequestStatusMapper statusMapper) {
        io.atlassian.fugue.Option newStatusName = io.atlassian.fugue.Option.none();
        io.atlassian.fugue.Option oldStatusName = io.atlassian.fugue.Option.none();
        io.atlassian.fugue.Option resolution = io.atlassian.fugue.Option.none();
        for (ChangeItemBean bean : changeItems) {
            if (bean == null) continue;
            String field = bean.getField();
            if (field.equals("status") && this.isStatusChangeVisibleInCustomerPortal(bean, statusMapper)) {
                newStatusName = io.atlassian.fugue.Option.some((Object)this.getStatusNameForCustomer(bean.getTo(), bean.getToString(), statusMapper));
                oldStatusName = io.atlassian.fugue.Option.some((Object)this.getStatusNameForCustomer(bean.getFrom(), bean.getFromString(), statusMapper));
                continue;
            }
            if (!field.equals("resolution") || bean.getTo() == null) continue;
            resolution = io.atlassian.fugue.Option.some((Object)bean.getToString());
        }
        return new CustomerResolutionChange(resolution, oldStatusName, newStatusName);
    }

    private boolean isStatusChangeVisibleInCustomerPortal(ChangeItemBean changeItemBean, RequestStatusMapper statusMapper) {
        String to = statusMapper.translateToCustomerStatus(changeItemBean.getTo(), changeItemBean.getToString());
        String from = statusMapper.translateToCustomerStatus(changeItemBean.getFrom(), changeItemBean.getFromString());
        return !from.equals(to);
    }

    private String getStatusNameForCustomer(String changedItem, String changedItemToString, RequestStatusMapper statusMapper) {
        Status status = this.statusManager.getStatus(changedItem);
        if (status != null) {
            return statusMapper.translateToCustomerStatus(status);
        }
        return statusMapper.translateToCustomerStatus(changedItem, changedItemToString);
    }

    private RequestStatusMapper getRequestStatusMapper(ApplicationUser user, Issue issue) {
        return (RequestStatusMapper)this.requestStatusMapperCache.get((Object)StatusAndResolutionActivityProviderImpl.buildCacheKey(user, issue), () -> {
            io.atlassian.fugue.Option checkedUser = StepsConverters.newerOption((Option)this.userFactory.wrap(user).toOption());
            if (checkedUser.isEmpty()) {
                return this.requestStatusService.getStatusMapperForMissingRequestType();
            }
            Either requestTypeForIssueWithVpOrigin = this.requestTypeInternalService.getRequestTypeForIssue((CheckedUser)checkedUser.get(), issue);
            if (requestTypeForIssueWithVpOrigin.isLeft()) {
                return this.requestStatusService.getStatusMapperForMissingRequestType();
            }
            return this.requestStatusService.getStatusMapper((RequestType)requestTypeForIssueWithVpOrigin.right().get());
        });
    }

    private static String buildCacheKey(ApplicationUser user, Issue issue) {
        return (String)io.atlassian.fugue.Option.option((Object)user).map(ApplicationUser::getKey).getOrElse((Object)"anonymous") + "_" + io.atlassian.fugue.Option.option((Object)issue).map(Issue::getId).getOrElse((Object)-1L);
    }

    private static class CustomerResolutionChange {
        private final io.atlassian.fugue.Option<String> newStatusName;
        private final io.atlassian.fugue.Option<String> oldStatusName;
        private final io.atlassian.fugue.Option<String> resolution;

        private CustomerResolutionChange(io.atlassian.fugue.Option<String> resolution, io.atlassian.fugue.Option<String> oldStatusName, io.atlassian.fugue.Option<String> newStatusName) {
            this.resolution = resolution;
            this.oldStatusName = oldStatusName;
            this.newStatusName = newStatusName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomerResolutionChange that = (CustomerResolutionChange)o;
            return Objects.equal(this.newStatusName, that.newStatusName) && Objects.equal(this.oldStatusName, that.oldStatusName) && Objects.equal(this.resolution, that.resolution);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.newStatusName, this.oldStatusName, this.resolution});
        }
    }

    @VisibleForTesting
    static class StatusResolutionChange {
        private final Instant changeDate;
        private final CustomerResolutionChange customerResolutionChange;

        private StatusResolutionChange(Instant changeDate, CustomerResolutionChange customerResolutionChange) {
            this.changeDate = changeDate;
            this.customerResolutionChange = customerResolutionChange;
        }

        Instant getChangeDate() {
            return this.changeDate;
        }

        io.atlassian.fugue.Option<String> getOldTranslatedStatusName() {
            return this.customerResolutionChange.oldStatusName;
        }

        io.atlassian.fugue.Option<String> getNewTranslatedStatusName() {
            return this.customerResolutionChange.newStatusName;
        }

        public io.atlassian.fugue.Option<String> getResolution() {
            return this.customerResolutionChange.resolution;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatusResolutionChange that = (StatusResolutionChange)o;
            return Objects.equal((Object)this.changeDate, (Object)that.changeDate) && Objects.equal((Object)this.customerResolutionChange, (Object)that.customerResolutionChange);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.changeDate, this.customerResolutionChange});
        }
    }
}

