/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.field.FieldId;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestCreateParameters;
import com.atlassian.servicedesk.api.request.CustomerRequestUpdateParameters;
import com.atlassian.servicedesk.api.request.RequestTypeUpdateParameters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.CreateIssueResponse;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestManager;
import com.atlassian.servicedesk.internal.feature.customer.request.InternalCustomerRequestService;
import com.atlassian.servicedesk.internal.feature.customer.request.InternalCustomerRequestServiceScala;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeWithFields;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternalManager;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueManager;
import com.atlassian.servicedesk.internal.feature.jira.issuetype.ServiceDeskIssueTypeManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.utils.ErrorConverterHelper;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalCustomerRequestServiceImpl
implements InternalCustomerRequestService {
    private final InternalCustomerRequestServiceScala internalCustomerRequestService;
    private final InternalPortalService internalPortalService;
    private final RequestTypeInternalService requestTypeInternalService;
    private final ServiceDeskIssueManager sdIssueManager;
    private final ServiceDeskIssueTypeManager issueTypeInternalManager;
    private final UserFactory userFactory;
    private final ErrorConverterHelper errorConverterHelper;
    private final ServiceDeskInternalManager internalServiceDeskManager;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final CustomerRequestManager customerRequestManager;
    private final RequestTypeFieldInternalManager requestTypeFieldInternalManager;
    private final ParticipantsCustomFieldManager participantsCustomFieldManager;
    private final CustomerRequestInternalManager customerRequestInternalManager;

    @Autowired
    public InternalCustomerRequestServiceImpl(InternalCustomerRequestServiceScala internalCustomerRequestService, CustomerRequestInternalManager customerRequestInternalManager, InternalPortalService internalPortalService, RequestTypeInternalService requestTypeInternalService, ServiceDeskIssueManager sdIssueManager, ServiceDeskIssueTypeManager issueTypeInternalManager, UserFactory userFactory, ErrorConverterHelper errorConverterHelper, ServiceDeskInternalManager internalServiceDeskManager, InternalServiceDeskProjectManager internalServiceDeskProjectManager, CustomerRequestManager customerRequestManager, RequestTypeFieldInternalManager requestTypeFieldInternalManager, ParticipantsCustomFieldManager participantsCustomFieldManager) {
        this.internalCustomerRequestService = internalCustomerRequestService;
        this.customerRequestInternalManager = customerRequestInternalManager;
        this.internalPortalService = internalPortalService;
        this.requestTypeInternalService = requestTypeInternalService;
        this.sdIssueManager = sdIssueManager;
        this.issueTypeInternalManager = issueTypeInternalManager;
        this.userFactory = userFactory;
        this.errorConverterHelper = errorConverterHelper;
        this.internalServiceDeskManager = internalServiceDeskManager;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.customerRequestManager = customerRequestManager;
        this.requestTypeFieldInternalManager = requestTypeFieldInternalManager;
        this.participantsCustomFieldManager = participantsCustomFieldManager;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Issue> getRequestForId(@Nonnull ApplicationUser user, @Nonnull Long issueId) {
        return Steps.begin(this.sdIssueManager.getIssueById(issueId)).then(issue -> this.getRequestForIssue(user, (Issue)issue)).yield((issue, request) -> request);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Issue> getRequestForIssue(@Nonnull ApplicationUser user, @Nonnull Issue issue) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(cu -> this.isValidRequest((CheckedUser)cu, issue)).yield((cu, valid) -> issue);
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> isValidRequest(CheckedUser checkedUser, Issue issue) {
        return this.errorConverterHelper.toJavaErrorEither(this.internalCustomerRequestService.isValidRequest(checkedUser, issue));
    }

    @Override
    @Deprecated
    public io.atlassian.fugue.Either<AnError, Issue> updateRequestType(@Nonnull ApplicationUser user, RequestTypeUpdateParameters requestTypeUpdateParameters) {
        return this.updateRequestType(user, requestTypeUpdateParameters.issue(), requestTypeUpdateParameters.issue().getProjectObject().getId(), requestTypeUpdateParameters.requestType().getId());
    }

    private io.atlassian.fugue.Either<AnError, Issue> updateRequestType(ApplicationUser user, Issue issue, long projectId, long requestTypeId) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(cu -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId))).then(this.internalPortalService::getPortalByProject).then((cu, project, portal) -> this.getValidRequestTypeByPortal((CheckedUser)cu, (Project)project, (Portal)portal, requestTypeId)).then((cu, project, portal, requestType) -> this.updateRequestType((CheckedUser)cu, (Project)project, (Portal)portal, issue, (RequestType)requestType)).yield((cu, project, portal, requestType, updatedIssue) -> issue);
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getValidRequestTypeByPortal(CheckedUser user, Project project, Portal portal, Long requestTypeId) {
        return this.requestTypeInternalService.getValidRequestTypeByPortal(user, project, portal, Integer.valueOf(requestTypeId.intValue()));
    }

    private io.atlassian.fugue.Either<AnError, Issue> updateRequestType(CheckedUser checkedUser, Project project, Portal portal, Issue issue, RequestType requestType) {
        return Steps.begin(this.issueTypeInternalManager.getIssueTypeForProject(requestType.getIssueTypeId(), project)).then(issueType -> this.updateRequestType(checkedUser, project, portal, issue, requestType, (IssueType)issueType)).yield((issueType, updatedIssue) -> updatedIssue);
    }

    private io.atlassian.fugue.Either<AnError, Issue> updateRequestType(CheckedUser checkedUser, Project project, Portal portal, Issue issue, RequestType requestType, IssueType issueType) {
        return this.errorConverterHelper.toJavaErrorEither(this.internalCustomerRequestService.updateRequestType(checkedUser, project, portal, issue, requestType, issueType));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Issue> getRequestForIssueOverrideSecurity(@Nonnull Issue issue) {
        return Steps.begin(this.isValidRequest(issue)).yield(valid -> issue);
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> isValidRequest(Issue issue) {
        return this.errorConverterHelper.toJavaErrorEither(this.customerRequestManager.issueIsServiceDeskRequest(issue));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Issue> updateRequestType(@Nonnull ApplicationUser user, @Nonnull CustomerRequestUpdateParameters customerRequestUpdateParameters) {
        return this.updateRequestType(user, customerRequestUpdateParameters.issue(), customerRequestUpdateParameters.serviceDesk().getProjectId(), customerRequestUpdateParameters.requestType().getId());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Issue> createCustomerRequest(@Nonnull ApplicationUser user, @Nonnull CustomerRequestCreateParameters createParams) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(cu -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(createParams.serviceDesk().getProjectId()))).then(this.internalPortalService::getPortalByProject).then((cu, project, portal) -> this.getValidRequestTypeByPortal((CheckedUser)cu, (Project)project, (Portal)portal, Long.valueOf(createParams.requestType().getId()))).then((cu, project, portal, requestType) -> this.createCustomerRequest((CheckedUser)cu, (Project)project, (Portal)portal, (RequestType)requestType, createParams)).yield((cu, project, portal, requestType, issue) -> issue);
        return result.leftMap(error -> {
            int httpErrorCode = error.getHttpStatusCode() == 404 ? 400 : error.getHttpStatusCode();
            return new AnError(error.getMessage(), httpErrorCode, error.getErrorCode());
        });
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CustomerRequest> asCustomerRequest(ApplicationUser user, Issue issue) {
        return this.customerRequestInternalManager.asCustomerRequest(user, issue);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<CustomerRequest.CustomerRequestStatus>> getCustomerRequestStatus(ApplicationUser user, Issue issue) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(cu -> this.customerRequestInternalManager.getCustomerRequestStatus(user, issue)).yield((cu, status) -> status);
    }

    private io.atlassian.fugue.Either<AnError, Issue> createCustomerRequest(CheckedUser checkedUser, Project project, Portal portal, RequestType requestType, CustomerRequestCreateParameters createParams) {
        return Steps.begin(this.issueTypeInternalManager.getIssueTypeForProject(requestType.getIssueTypeId(), project)).then(issueType -> this.requestTypeFieldInternalManager.getRequestTypeFields(checkedUser, project, requestType)).then((issueType, rtFields) -> this.internalServiceDeskManager.getServiceDesk(project, false)).then((issueType, rtFields, serviceDesk) -> this.createCustomerRequest(checkedUser, project, (ServiceDesk)serviceDesk, portal, (RequestTypeWithFields)rtFields, (IssueType)issueType, createParams)).yield((issueType, rtFields, serviceDesk, issue) -> issue.getIssue());
    }

    private io.atlassian.fugue.Either<AnError, CreateIssueResponse> createCustomerRequest(CheckedUser checkedUser, Project project, ServiceDesk serviceDesk, Portal portal, RequestTypeWithFields requestTypeWithFields, IssueType issueType, CustomerRequestCreateParameters createParameters) {
        Map<String, String[]> formParams = this.toFormParams(checkedUser, createParameters);
        Option optionalCreateParameters = Option.option((Object)createParameters);
        InternalCustomerRequestServiceScala.CreateRequestProjectParameters projectParameters = new InternalCustomerRequestServiceScala.CreateRequestProjectParameters(project, issueType, serviceDesk, portal, requestTypeWithFields);
        InternalCustomerRequestServiceScala.CreateRequestFieldParameters fieldParameters = new InternalCustomerRequestServiceScala.CreateRequestFieldParameters(createParameters.customerRequestChannelSource(), formParams, (Option<CustomerRequestCreateParameters>)optionalCreateParameters);
        return this.internalCustomerRequestService.createRequest(checkedUser, projectParameters, fieldParameters);
    }

    private Map<String, String[]> toFormParams(CheckedUser checkedUser, CustomerRequestCreateParameters createParams) {
        HashMap<String, String[]> resultMap = new HashMap<String, String[]>();
        this.populateRaiseOnBehalfOf(checkedUser.forJIRA(), createParams, resultMap);
        this.populateRequestParticipant(createParams, resultMap);
        return resultMap;
    }

    /*
     * Exception decompiling
     */
    private void populateRaiseOnBehalfOf(ApplicationUser currentUser, CustomerRequestCreateParameters createParams, Map<String, String[]> resultMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void populateRequestParticipant(CustomerRequestCreateParameters createParams, Map<String, String[]> resultMap) {
        Option reqPartOpt = Option.some((Object)this.participantsCustomFieldManager.getParticipantsCustomField()).map(RenderableField::getId).map(FieldId::withId);
        Optional<String[]> requestParticipants = createParams.requestParticipants().map(reqParts -> (String[])reqParts.stream().toArray(String[]::new));
        if (requestParticipants.isPresent() && reqPartOpt.isDefined()) {
            resultMap.put(((FieldId)reqPartOpt.get()).value(), requestParticipants.get());
        } else if (reqPartOpt.isDefined()) {
            resultMap.remove(((FieldId)reqPartOpt.get()).value());
        }
    }
}

