/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.IssueViewProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.InternalCustomerRequestService;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.ActivityCommentItem;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.FieldAndValue;
import com.atlassian.servicedesk.internal.rest.responses.CustomerRequestView;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang.math.NumberUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerViewableAttachmentService {
    private final CommonErrors commonErrors;
    private final InternalCustomerRequestService internalCustomerRequestService;
    private final IssueViewProvider issueViewProvider;
    private final PortalService portalService;
    private final UserFactory userFactory;
    private static final Pattern ATTACHMENT_ID_PATTERN = Pattern.compile("attachment/(.*?)/");

    @Autowired
    public CustomerViewableAttachmentService(CommonErrors commonErrors, InternalCustomerRequestService internalCustomerRequestService, IssueViewProvider issueViewProvider, PortalService portalService, UserFactory userFactory) {
        this.commonErrors = commonErrors;
        this.internalCustomerRequestService = internalCustomerRequestService;
        this.issueViewProvider = issueViewProvider;
        this.portalService = portalService;
        this.userFactory = userFactory;
    }

    public io.atlassian.fugue.Either<AnError, LongStream> getViewableAttachments(long issueId) {
        io.atlassian.fugue.Either customerRequestViewEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalCustomerRequestService.getRequestForId(user.forJIRA(), issueId)).then((user, issue) -> Option.option((Object)issue.getProjectObject()).toRight(() -> ((CommonErrors)this.commonErrors).PROJECT_NOT_FOUND())).then((user, issue, project) -> StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user.forJIRA(), project))).then(this.issueViewProvider::getIssueViewOrDefault).yield((user, issue, project, portal, issueView) -> issueView);
        return customerRequestViewEither.map(customerRequestView -> LongStream.concat(this.getAttachmentsFromComments((CustomerRequestView)customerRequestView), this.getAttachmentsFromDescription((CustomerRequestView)customerRequestView)));
    }

    private LongStream getAttachmentsFromComments(CustomerRequestView customerRequestView) {
        return this.getAttachmentIds(this.getCommentItems(customerRequestView));
    }

    private LongStream getAttachmentsFromDescription(CustomerRequestView customerRequestView) {
        return customerRequestView.getFields().stream().filter(field -> Objects.equals(field.getId(), "description")).map(FieldAndValue::getValue).flatMapToLong(fieldValue -> this.getAttachmentIdsFromHtml(fieldValue.toString()));
    }

    @VisibleForTesting
    LongStream getAttachmentIds(Stream<ActivityCommentItem> comments) {
        return comments.flatMapToLong(comment -> this.getAttachmentIdsFromHtml(comment.getComment()));
    }

    @VisibleForTesting
    Stream<ActivityCommentItem> getCommentItems(CustomerRequestView customerRequestView) {
        return customerRequestView.getActivityStream().stream().filter(ActivityCommentItem.class::isInstance).map(activityItemResponse -> (ActivityCommentItem)activityItemResponse);
    }

    private LongStream getAttachmentIdsFromHtml(String html) {
        Document document = Jsoup.parse((String)html);
        return LongStream.concat(this.getAnchorAttachments(document), this.getImageAttachments(document));
    }

    private LongStream getImageAttachments(Document document) {
        return document.select("img").stream().map(link -> link.attr("src")).map(ATTACHMENT_ID_PATTERN::matcher).filter(Matcher::find).mapToLong(m -> NumberUtils.toLong((String)m.group(1), (long)-1L));
    }

    private LongStream getAnchorAttachments(Document document) {
        return document.select("a[href]").stream().map(link -> link.attr("href")).map(ATTACHMENT_ID_PATTERN::matcher).filter(Matcher::find).mapToLong(m -> NumberUtils.toLong((String)m.group(1), (long)-1L));
    }
}

