/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.Issue;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.request.CustomerRequestUpdateParameters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

@Internal
public class CustomerRequestUpdateParametersImpl
implements CustomerRequestUpdateParameters {
    private final Issue issue;
    private final ServiceDesk serviceDesk;
    private final RequestType requestType;

    private CustomerRequestUpdateParametersImpl(Issue issue, ServiceDesk serviceDesk, RequestType requestType) {
        this.issue = (Issue)Preconditions.checkNotNull((Object)issue);
        this.serviceDesk = (ServiceDesk)Preconditions.checkNotNull((Object)serviceDesk);
        this.requestType = (RequestType)Preconditions.checkNotNull((Object)requestType);
    }

    public Issue issue() {
        return this.issue;
    }

    public ServiceDesk serviceDesk() {
        return this.serviceDesk;
    }

    public RequestType requestType() {
        return this.requestType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerRequestUpdateParametersImpl that = (CustomerRequestUpdateParametersImpl)o;
        return Objects.equal((Object)this.issue, (Object)that.issue) && Objects.equal((Object)this.serviceDesk, (Object)that.serviceDesk) && Objects.equal((Object)this.requestType, (Object)that.requestType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.issue, this.serviceDesk, this.requestType});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issue", (Object)this.issue).add("serviceDesk", (Object)this.serviceDesk).add("requestType", (Object)this.requestType).toString();
    }

    public static final class Builder
    implements CustomerRequestUpdateParameters.Builder {
        private Issue issue;
        private ServiceDesk serviceDesk;
        private RequestType requestType;

        private Builder() {
        }

        public Builder issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public Builder serviceDesk(ServiceDesk serviceDesk) {
            this.serviceDesk = serviceDesk;
            return this;
        }

        public Builder requestType(RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public CustomerRequestUpdateParametersImpl build() {
            return new CustomerRequestUpdateParametersImpl(this.issue, this.serviceDesk, this.requestType);
        }
    }
}

