/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.annotations.Internal;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;

@Internal
public class CustomerRequestQueryImpl
implements CustomerRequestQuery {
    private final Optional<String> searchTerm;
    private final Optional<CustomerRequestQuery.REQUEST_OWNERSHIP> requestOwnership;
    private final Optional<CustomerRequestQuery.REQUEST_STATUS> requestStatus;
    private final Optional<Integer> serviceDesk;
    private final Optional<Integer> requestType;
    private final Optional<Long> issue;
    private final Optional<Boolean> requestOverrideSecurity;
    private final LimitedPagedRequest pagedRequest;

    private CustomerRequestQueryImpl(Optional<String> searchTerm, Optional<CustomerRequestQuery.REQUEST_OWNERSHIP> requestOwnership, Optional<CustomerRequestQuery.REQUEST_STATUS> requestStatus, Optional<Integer> serviceDesk, Optional<Integer> requestType, Optional<Long> issue, Optional<Boolean> requestOverrideSecurity, LimitedPagedRequest pagedRequest) {
        this.searchTerm = searchTerm;
        this.requestOwnership = requestOwnership;
        this.requestStatus = requestStatus;
        this.serviceDesk = serviceDesk;
        this.requestType = requestType;
        this.issue = issue;
        this.requestOverrideSecurity = requestOverrideSecurity;
        this.pagedRequest = pagedRequest;
    }

    public Optional<String> searchTerm() {
        return this.searchTerm;
    }

    public Optional<CustomerRequestQuery.REQUEST_OWNERSHIP> requestOwnership() {
        return this.requestOwnership;
    }

    public Optional<CustomerRequestQuery.REQUEST_STATUS> requestStatus() {
        return this.requestStatus;
    }

    public Optional<Integer> serviceDesk() {
        return this.serviceDesk;
    }

    public Optional<Integer> requestType() {
        return this.requestType;
    }

    public Optional<Long> issue() {
        return this.issue;
    }

    public Optional<Boolean> requestOverrideSecurity() {
        return this.requestOverrideSecurity;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerRequestQueryImpl that = (CustomerRequestQueryImpl)o;
        return Objects.equal(this.serviceDesk, that.serviceDesk) && Objects.equal(this.requestType, that.requestType) && Objects.equal(this.issue, that.issue) && Objects.equal(this.requestOverrideSecurity, that.requestOverrideSecurity) && Objects.equal((Object)this.pagedRequest, (Object)that.pagedRequest);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.serviceDesk, this.requestType, this.issue, this.requestOverrideSecurity, this.pagedRequest});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceDesk", this.serviceDesk).add("requestType", this.requestType).add("issue", this.issue).add("requestOverrideSecurity", this.requestOverrideSecurity).add("pagedRequest", (Object)this.pagedRequest).toString();
    }

    public static final class Builder
    implements CustomerRequestQuery.Builder {
        private Optional<String> searchTerm = Optional.empty();
        private Optional<CustomerRequestQuery.REQUEST_OWNERSHIP> requestOwnership = Optional.empty();
        private Optional<CustomerRequestQuery.REQUEST_STATUS> requestStatus = Optional.empty();
        private Optional<Integer> serviceDesk = Optional.empty();
        private Optional<Integer> requestType = Optional.empty();
        private Optional<Long> issue = Optional.empty();
        private Optional<Boolean> requestOverrideSecurity = Optional.empty();
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)100);

        private Builder() {
        }

        public CustomerRequestQuery.Builder searchTerm(String searchTerm) {
            this.searchTerm = Optional.ofNullable(searchTerm);
            return this;
        }

        public CustomerRequestQuery.Builder requestOwnership(CustomerRequestQuery.REQUEST_OWNERSHIP requestOwnership) {
            this.requestOwnership = Optional.of(requestOwnership);
            return this;
        }

        public CustomerRequestQuery.Builder requestStatus(CustomerRequestQuery.REQUEST_STATUS requestStatus) {
            this.requestStatus = Optional.of(requestStatus);
            return this;
        }

        public Builder serviceDesk(Integer serviceDesk) {
            this.serviceDesk = Optional.ofNullable(serviceDesk);
            return this;
        }

        public Builder requestType(Integer requestType) {
            this.requestType = Optional.ofNullable(requestType);
            return this;
        }

        public Builder issue(Long issue) {
            this.issue = Optional.ofNullable(issue);
            return this;
        }

        public Builder requestOverrideSecurity(Boolean requestOverrideSecurity) {
            this.requestOverrideSecurity = Optional.ofNullable(requestOverrideSecurity);
            return this;
        }

        public Builder pagedRequest(PagedRequest pagedRequest) {
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)100);
            return this;
        }

        public CustomerRequestQueryImpl build() {
            return new CustomerRequestQueryImpl(this.searchTerm, this.requestOwnership, this.requestStatus, this.serviceDesk, this.requestType, this.issue, this.requestOverrideSecurity, this.pagedRequest);
        }
    }
}

