/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.field.FieldId;
import com.atlassian.servicedesk.api.field.FieldInputValue;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequestChannelSource;
import com.atlassian.servicedesk.api.request.CustomerRequestCreateParameters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestIssueInputParametersBuilder;
import com.atlassian.servicedesk.internal.issueproperty.ServiceDeskIssuePropertyNames;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerRequestIssueInputParametersBuilderImpl
implements CustomerRequestIssueInputParametersBuilder {
    private final IssueService issueService;
    private final FieldManager fieldManager;
    private final VpOriginManager vpOriginManager;
    private final ErrorResultHelper errorHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public CustomerRequestIssueInputParametersBuilderImpl(IssueService issueService, VpOriginManager vpOriginManager, ErrorResultHelper errorHelper, I18nHelper i18nHelper, FieldManager fieldManager) {
        this.issueService = issueService;
        this.vpOriginManager = vpOriginManager;
        this.errorHelper = errorHelper;
        this.i18nHelper = i18nHelper;
        this.fieldManager = fieldManager;
    }

    @Override
    public Either<AnError, IssueInputParameters> buildCreateParameters(Project project, IssueType issueType, Portal portal, RequestType requestType, CustomerRequestChannelSource channel, List<String> requestTypeValidFieldIds, Map<String, String[]> defaultedFormValues, Option<CustomerRequestCreateParameters> createParameters) {
        IssueInputParameters inputParameters = this.issueService.newIssueInputParameters(defaultedFormValues);
        inputParameters.setProjectId(project.getId());
        inputParameters.setIssueTypeId(issueType.getId());
        inputParameters.setSkipScreenCheck(true);
        inputParameters.setApplyDefaultValuesWhenParameterNotProvided(true);
        inputParameters.setProvidedFields(defaultedFormValues.keySet());
        IssueContextImpl issueCtx = new IssueContextImpl(project.getId(), issueType.getId());
        return Steps.begin(this.normaliseApiFieldValues((IssueContext)issueCtx, requestTypeValidFieldIds, inputParameters, createParameters)).then(standardParams -> this.vpOriginSetValues(portal, project, requestType, issueType, (IssueInputParameters)standardParams)).yield((standardParams, withRtParams) -> this.populateRequestChannelSource((IssueInputParameters)withRtParams, channel));
    }

    private Either<AnError, IssueInputParameters> vpOriginSetValues(Portal portal, Project project, RequestType requestType, IssueType issueType, IssueInputParameters inputParameters) {
        Option<Pair<CustomField, VpOrigin>> vpOriginOpt = this.vpOriginManager.getCustomerRequestTypeFieldInFieldLayout(portal, project, requestType, issueType);
        if (vpOriginOpt.isDefined()) {
            CustomField customField = (CustomField)((Pair)vpOriginOpt.get()).left();
            VpOrigin vpOrigin = (VpOrigin)((Pair)vpOriginOpt.get()).right();
            inputParameters.addCustomFieldValue(customField.getIdAsLong(), new String[]{vpOrigin.toString()});
            ArrayList providedFields = Lists.newArrayList((Iterable)inputParameters.getProvidedFields());
            providedFields.add(customField.getId());
            inputParameters.setProvidedFields((Collection)providedFields);
            return Either.right((Object)inputParameters);
        }
        return Either.left((Object)this.badRequest400("sd.origin.customfield.not.on.screen", new Object[0]));
    }

    private IssueInputParameters populateRequestChannelSource(IssueInputParameters issueInputParameters, CustomerRequestChannelSource chanelSource) {
        ObjectNode jsonNode = JsonNodeFactory.instance.objectNode();
        jsonNode.put(ServiceDeskIssuePropertyNames.PROPERTY_PATH_KEY(), chanelSource.value());
        issueInputParameters.addProperty(ServiceDeskIssuePropertyNames.SD_REQUEST_CHANNEL_KEY(), (JsonNode)jsonNode);
        return issueInputParameters;
    }

    @VisibleForTesting
    Either<AnError, IssueInputParameters> normaliseApiFieldValues(IssueContext issueCtx, List<String> requestTypeValidFieldIds, IssueInputParameters issueInputParameters, Option<CustomerRequestCreateParameters> createParameters) {
        if (createParameters.isEmpty()) {
            return Either.right((Object)issueInputParameters);
        }
        String operationName = StandardOperation.SET.getName();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        CustomerRequestCreateParameters requestCreateParameters = (CustomerRequestCreateParameters)createParameters.get();
        Map fieldValues = requestCreateParameters.fieldValues();
        ArrayList<String> initialProvidedFields = new ArrayList<String>(issueInputParameters.getProvidedFields());
        ArrayList<String> providedFields = new ArrayList<String>(initialProvidedFields);
        HashMap<String, ErrorCollection> fieldErrors = new HashMap<String, ErrorCollection>();
        for (Map.Entry entry : fieldValues.entrySet()) {
            String fieldId = ((FieldId)entry.getKey()).value();
            Field field = this.getField(fieldId);
            if (field == null) {
                errorCollection.addErrorMessage(this.getText("sd.admin.requestfield.named.notfound", fieldId));
                continue;
            }
            if (this.notAllowedFields(fieldId, requestTypeValidFieldIds, initialProvidedFields)) {
                errorCollection.addErrorMessage(this.getText("sd.admin.requestfield.named.notalllowed", fieldId, requestCreateParameters.requestType().getName()));
                continue;
            }
            Object fieldValue = ((FieldInputValue)entry.getValue()).value();
            if (!(field instanceof RestFieldOperations)) continue;
            RestFieldOperationsHandler operationsHandler = ((RestFieldOperations)field).getRestFieldOperation();
            Set supportedOperations = operationsHandler.getSupportedOperations();
            ArrayList<FieldOperationHolder> operationsHolders = new ArrayList<FieldOperationHolder>();
            if (!supportedOperations.contains(operationName)) {
                String supportedOperationsMsg = Joiner.on((String)", \n").join((Iterable)supportedOperations);
                errorCollection.addErrorMessage(this.getText("sd.admin.requestfield.operation.not.supported", fieldId, field.getName(), operationName, supportedOperationsMsg));
            } else {
                JsonData data = new JsonData(fieldValue);
                FieldOperationHolder fieldOperationHolder = new FieldOperationHolder(operationName, data);
                operationsHolders.add(fieldOperationHolder);
            }
            if (operationsHolders.isEmpty()) continue;
            ErrorCollection ec = operationsHandler.updateIssueInputParameters(issueCtx, null, fieldId, issueInputParameters, operationsHolders);
            if (ec.hasAnyErrors()) {
                fieldErrors.put(fieldId, ec);
                continue;
            }
            providedFields.add(fieldId);
        }
        issueInputParameters.setProvidedFields(providedFields);
        boolean houstonWeHaveAProblem = errorCollection.hasAnyErrors() || fieldErrors.size() > 0;
        return Eithers.cond((!houstonWeHaveAProblem ? 1 : 0) != 0, (Object)this.makeAnError((ErrorCollection)errorCollection, fieldErrors), (Object)issueInputParameters);
    }

    private boolean notAllowedFields(String fieldId, List<String> requestTypeValidFieldIds, List<String> initialProvidedFields) {
        return "reporter".equals(fieldId) || "project".equals(fieldId) || "issuetype".equals(fieldId) || !requestTypeValidFieldIds.contains(fieldId) || initialProvidedFields.contains(fieldId);
    }

    private AnError makeAnError(ErrorCollection errorCollection, Map<String, ErrorCollection> fieldErrors) {
        ArrayList messages = new ArrayList();
        for (String fieldId : fieldErrors.keySet()) {
            ErrorCollection ec = fieldErrors.get(fieldId);
            ec.getErrors().entrySet().forEach(entry -> {
                Field field = this.getField(fieldId);
                messages.add(this.getText("sd.request.create.error.failed.field.operation", fieldId, field.getName(), entry.getValue()));
            });
            ec.getErrorMessages().forEach(messages::add);
        }
        errorCollection.getErrorMessages().forEach(messages::add);
        String joinedMessages = Joiner.on((String)", \n").join(messages);
        return this.badRequest400("sd.request.create.error.failed.msg", joinedMessages);
    }

    @VisibleForTesting
    Field getField(String fieldId) {
        return this.fieldManager.getField(fieldId);
    }

    @VisibleForTesting
    String getText(String key, Object ... params) {
        return this.i18nHelper.getText(key, (Object)params);
    }

    @VisibleForTesting
    AnError badRequest400(String key, Object ... params) {
        return this.errorHelper.badRequest400(key, params).build();
    }
}

