/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.internal.api.request.activitystream.items.ActivityItem;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusMapper;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestStatusImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers.StatusAndResolutionActivityProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ResolutionUpdateActivityItem;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.StatusUpdateActivityItem;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Iterables;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerRequestInternalManagerImpl
implements CustomerRequestInternalManager {
    private static final Logger log = LoggerFactory.getLogger(CustomerRequestInternalManagerImpl.class);
    private final RequestTypeInternalManager requestTypeManager;
    private final VpOriginManager vpOriginManager;
    private final PortalInternalManager portalManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final RequestStatusService requestStatusService;
    private final StatusAndResolutionActivityProvider statusAndResolutionActivityProvider;
    private final RequestTypeInternalManager requestTypeInternalManager;

    @Autowired
    public CustomerRequestInternalManagerImpl(RequestTypeInternalManager requestTypeManager, VpOriginManager vpOriginManager, PortalInternalManager portalManager, ServiceDeskInternalManager serviceDeskManager, RequestStatusService requestStatusService, StatusAndResolutionActivityProvider statusAndResolutionActivityProvider, RequestTypeInternalManager requestTypeInternalManager) {
        this.requestTypeManager = requestTypeManager;
        this.vpOriginManager = vpOriginManager;
        this.portalManager = portalManager;
        this.serviceDeskManager = serviceDeskManager;
        this.requestStatusService = requestStatusService;
        this.statusAndResolutionActivityProvider = statusAndResolutionActivityProvider;
        this.requestTypeInternalManager = requestTypeInternalManager;
    }

    @Override
    public Either<AnError, CustomerRequest> asCustomerRequest(ApplicationUser user, Issue issue) {
        Project project = issue.getProjectObject();
        return Steps.begin(this.vpOriginManager.lookupOrError(issue)).then(() -> this.portalManager.getPortalByProject(project)).then(() -> this.serviceDeskManager.getServiceDesk(project, false)).then((vp, portal, sd) -> this.getRequestTypeByVpOrigin((Portal)portal, (VpOrigin)vp)).then((vp, portal, sd, rt) -> this.getCurrentStatus(user, issue, (RequestType)rt)).yield((vp, portal, sd, rt, status) -> new CustomerRequestImpl(issue, rt.getId(), sd.getId(), (CustomerRequest.CustomerRequestStatus)status));
    }

    @Override
    public Either<AnError, List<CustomerRequest.CustomerRequestStatus>> getCustomerRequestStatus(ApplicationUser user, Issue issue) {
        return Steps.begin(this.portalManager.getPortalByProjectId(issue.getProjectId())).then(portal -> this.vpOriginManager.lookupOrError(issue)).then((portal, vpOrigin) -> this.requestTypeInternalManager.getRequestTypeByKey((Portal)portal, vpOrigin.getRequestTypeKey())).yield((portal, vpOrigin, rt) -> this.getRequestStatusSortedByDate(user, issue, (RequestType)rt));
    }

    private List<CustomerRequest.CustomerRequestStatus> getRequestStatusSortedByDate(ApplicationUser user, Issue issue, RequestType requestType) {
        CustomerRequest.CustomerRequestStatus first;
        List statusChangeActivities = this.statusAndResolutionActivityProvider.getActivityStreamMostRecentFirst(user, issue);
        CustomerRequest.CustomerRequestStatus currentStatusForIssue = this.statusAndResolutionActivityProvider.getCurrentStatusForIssue(user, issue);
        if (statusChangeActivities.isEmpty()) {
            return Lists.newArrayList((Object[])new CustomerRequest.CustomerRequestStatus[]{currentStatusForIssue});
        }
        List<CustomerRequest.CustomerRequestStatus> results = this.getCustomerRequestStatusResult(user, issue, statusChangeActivities);
        if (results.isEmpty()) {
            return Lists.newArrayList((Object[])new CustomerRequest.CustomerRequestStatus[]{currentStatusForIssue});
        }
        String currentTranslatedStatus = currentStatusForIssue.status();
        if (Objects.equals(currentTranslatedStatus, (first = (CustomerRequest.CustomerRequestStatus)Iterables.first(results).get()).status())) {
            return results;
        }
        log.warn("The first customer request status found, does not appear to match the actual issues current customer request status. Attempt a re-sort operation before return results");
        ArrayList<CustomerRequest.CustomerRequestStatus> sortingResults = new ArrayList<CustomerRequest.CustomerRequestStatus>(results);
        Instant instant = first.statusInstant();
        Collections.sort(sortingResults, (o1, o2) -> {
            if (Objects.equals(instant, o1.statusInstant()) && Objects.equals(instant, o2.statusInstant()) && !Objects.equals(o1.status(), o2.status())) {
                if (Objects.equals(currentTranslatedStatus, o1.status())) {
                    return -1;
                }
                if (Objects.equals(currentTranslatedStatus, o2.status())) {
                    return 1;
                }
            }
            return 0;
        });
        return sortingResults;
    }

    private List<CustomerRequest.CustomerRequestStatus> getCustomerRequestStatusResult(ApplicationUser user, Issue issue, List<ActivityItem> statusChangeActivitiesWithMostRecentItemFirst) {
        Stream statusStream = Stream.concat(FpKit.flatMap(statusChangeActivitiesWithMostRecentItemFirst, s -> {
            Instant activityInstant = s.getActivityInstant();
            if (s instanceof StatusUpdateActivityItem) {
                return Collections.singletonList(new CustomerRequestStatusImpl(((StatusUpdateActivityItem)s).getNewStatusName(), activityInstant));
            }
            return (List)((ResolutionUpdateActivityItem)s).getNewStatusName().map(statusName -> Collections.singletonList(new CustomerRequestStatusImpl((String)statusName, activityInstant))).getOrElse(Collections.emptyList());
        }).stream(), Collections.singletonList(this.statusAndResolutionActivityProvider.getInitialStatusForIssue(user, issue)).stream());
        return new ArrayList<CustomerRequest.CustomerRequestStatus>(statusStream.sorted((o1, o2) -> o2.statusInstant().compareTo(o1.statusInstant())).collect(Collectors.toList()));
    }

    private Either<AnError, CustomerRequest.CustomerRequestStatus> getCurrentStatus(ApplicationUser user, Issue issue, RequestType requestType) {
        CustomerRequest.CustomerRequestStatus currentStatus = this.getRequestStatusSortedByDate(user, issue, requestType).stream().findFirst().orElseGet(() -> {
            RequestStatusMapper mapper = this.requestStatusService.getStatusMapper(requestType);
            String status = mapper.translateToCustomerStatus(issue.getStatus());
            return new CustomerRequestStatusImpl(status, issue.getCreated().toInstant());
        });
        return Either.right((Object)currentStatus);
    }

    private Either<AnError, RequestType> getRequestTypeByVpOrigin(Portal portal, VpOrigin vpOrigin) {
        return this.requestTypeManager.getRequestTypeByKey(portal, vpOrigin.getRequestTypeKey());
    }
}

