/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.field.FieldId;
import com.atlassian.servicedesk.api.field.FieldInputValue;
import com.atlassian.servicedesk.api.request.CustomerRequestChannelSource;
import com.atlassian.servicedesk.api.request.CustomerRequestCreateParameters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.util.concurrent.Assertions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CustomerRequestCreateParametersImpl
implements CustomerRequestCreateParameters {
    private final ServiceDesk serviceDesk;
    private final RequestType requestType;
    @TenantAware(value=TenancyScope.TENANTED)
    private final Map<FieldId, FieldInputValue> fieldValues;
    private final Optional<String> raiseOnBehalfOf;
    private final Optional<Set<String>> requestParticipants;
    private final CustomerRequestChannelSource customerRequestChannelSource;

    private CustomerRequestCreateParametersImpl(ServiceDesk serviceDesk, RequestType requestType, Map<FieldId, FieldInputValue> fieldValues, Optional<String> raiseOnBehalfOf, Optional<Set<String>> requestParticipants, CustomerRequestChannelSource customerRequestChannelSource) {
        this.serviceDesk = serviceDesk;
        this.requestType = requestType;
        this.fieldValues = fieldValues;
        this.raiseOnBehalfOf = raiseOnBehalfOf;
        this.requestParticipants = requestParticipants;
        this.customerRequestChannelSource = customerRequestChannelSource;
    }

    public ServiceDesk serviceDesk() {
        return this.serviceDesk;
    }

    public RequestType requestType() {
        return this.requestType;
    }

    public Map<FieldId, FieldInputValue> fieldValues() {
        return this.fieldValues;
    }

    public Optional<String> raiseOnBehalfOf() {
        return this.raiseOnBehalfOf;
    }

    public Optional<Set<String>> requestParticipants() {
        return this.requestParticipants;
    }

    public CustomerRequestChannelSource customerRequestChannelSource() {
        return this.customerRequestChannelSource;
    }

    public static CustomerRequestCreateParameters.Builder builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl
    implements CustomerRequestCreateParameters.Builder {
        private ServiceDesk serviceDesk;
        private RequestType requestType;
        @TenantAware(value=TenancyScope.TENANTED)
        private Map<FieldId, FieldInputValue> fieldValues = new HashMap<FieldId, FieldInputValue>();
        private Optional<String> raiseOnBehalfOf = Optional.empty();
        private Optional<Set<String>> requestParticipants = Optional.empty();
        private CustomerRequestChannelSource customerRequestChannelSource = CustomerRequestChannelSource.API;

        private BuilderImpl() {
        }

        public CustomerRequestCreateParameters.Builder serviceDesk(ServiceDesk serviceDesk) {
            Assertions.notNull((String)"serviceDesk", (Object)serviceDesk);
            this.serviceDesk = serviceDesk;
            return this;
        }

        public CustomerRequestCreateParameters.Builder requestType(RequestType requestType) {
            Assertions.notNull((String)"requestType", (Object)requestType);
            this.requestType = requestType;
            return this;
        }

        public CustomerRequestCreateParameters.Builder fieldValue(FieldId fieldId, FieldInputValue fieldValue) {
            Assertions.notNull((String)"fieldId", (Object)fieldId);
            Assertions.notNull((String)"values", (Object)fieldValue);
            this.fieldValues.put(fieldId, fieldValue);
            return this;
        }

        public CustomerRequestCreateParameters.Builder fieldValues(Map<FieldId, FieldInputValue> fieldValues) {
            Assertions.notNull((String)"fieldValues", fieldValues);
            this.fieldValues = fieldValues;
            return this;
        }

        public CustomerRequestCreateParameters.Builder raiseOnBehalfOf(String userName) {
            this.raiseOnBehalfOf = Optional.ofNullable(userName);
            return this;
        }

        public CustomerRequestCreateParameters.Builder raiseOnBehalfOf(Optional<String> userName) {
            this.raiseOnBehalfOf = userName;
            return this;
        }

        public CustomerRequestCreateParameters.Builder requestParticipant(String userName) {
            Set updated = this.requestParticipants.orElse(Collections.emptySet());
            Optional.ofNullable(userName).map(updated::add);
            this.requestParticipants = Optional.ofNullable(updated);
            return this;
        }

        public CustomerRequestCreateParameters.Builder requestParticipants(Set<String> userNames) {
            this.requestParticipants = Optional.ofNullable(userNames);
            return this;
        }

        public CustomerRequestCreateParameters.Builder requestParticipants(Optional<Set<String>> userNames) {
            this.requestParticipants = userNames;
            return this;
        }

        public CustomerRequestCreateParameters.Builder customerRequestChannelSource(CustomerRequestChannelSource customerRequestChannelSource) {
            Assertions.notNull((String)"customerRequestChannelSource", (Object)customerRequestChannelSource);
            this.customerRequestChannelSource = customerRequestChannelSource;
            return this;
        }

        public CustomerRequestCreateParameters build() {
            return new CustomerRequestCreateParametersImpl(this.serviceDesk, this.requestType, this.fieldValues, this.raiseOnBehalfOf, this.requestParticipants, this.customerRequestChannelSource);
        }
    }
}

