/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.user;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.user.UserResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.user.UserResponseProviderDataHelper;
import com.atlassian.servicedesk.internal.feature.customer.user.UserLanguageHelper;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.CustomerLanguageResponse;
import com.atlassian.servicedesk.internal.rest.responses.UserResponse;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserResponseProviderImpl
implements UserResponseProvider {
    private final UserFactory userFactory;
    private final UserResponseProviderDataHelper dataHelper;
    private final LocaleManager localeManager;
    private final UserLanguageHelper userLanguageHelper;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public UserResponseProviderImpl(UserFactory userFactory, UserResponseProviderDataHelper dataHelper, LocaleManager localeManager, UserLanguageHelper userLanguageHelper, ApplicationProperties applicationProperties) {
        this.userFactory = userFactory;
        this.dataHelper = dataHelper;
        this.localeManager = localeManager;
        this.userLanguageHelper = userLanguageHelper;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, UserResponse> getResponse(ModelsRequest ctx) {
        return StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).map(user -> this.toUserResponse((CheckedUser)user, this.dataHelper.isAgentForPortal((CheckedUser)user, ctx.getOptions().getPortalId())));
    }

    @Override
    public UserResponse toUserResponse(CheckedUser user) {
        return this.toUserResponse(user, false);
    }

    private UserResponse toUserResponse(CheckedUser user, boolean isAgentForPortal) {
        boolean canUpdateUser = this.dataHelper.canUpdateUser(user);
        long approvalCount = this.dataHelper.getApprovalsCount(user);
        Locale userLocale = this.localeManager.getLocaleFor(user.forJIRA());
        CustomerLanguageResponse language = new CustomerLanguageResponse(userLocale.toString(), this.userLanguageHelper.getLocaleDisplayName(userLocale, this.applicationProperties.getDefaultLocale()));
        return new UserResponse(user.getKey(), user.getName(), this.dataHelper.getAvatars(user), user.getDisplayName(), user.getEmailAddress(), this.dataHelper.getTimezoneResponse(user), this.dataHelper.canUserChangePassword(user, canUpdateUser), canUpdateUser, this.dataHelper.getAllOpenRequestsCount(user), this.dataHelper.getPendingApprovalsCount(user, approvalCount), approvalCount, this.dataHelper.getCustomMenuLinks(user), this.dataHelper.getNotificationType(user), this.dataHelper.canAdministerJIRA(user), isAgentForPortal, language);
    }
}

