/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.request;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestListFilterModel;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestListFilterModelParser;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListResponseAssembler;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.RequestListResponse;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestListResponseProvider
implements CustomerResponseProvider<RequestListResponse> {
    private final UserFactory userFactory;
    private final RequestListFilterModelParser requestListFilterModelParser;
    private final RequestListResponseAssembler requestListResponseAssembler;

    @Autowired
    public RequestListResponseProvider(UserFactory userFactory, RequestListFilterModelParser requestListFilterModelParser, RequestListResponseAssembler requestListResponseAssembler) {
        this.userFactory = userFactory;
        this.requestListFilterModelParser = requestListFilterModelParser;
        this.requestListResponseAssembler = requestListResponseAssembler;
    }

    @Override
    public Either<AnError, RequestListResponse> getResponse(ModelsRequest ctx) {
        return (Either)this.userFactory.getCheckedUser().fold(Either::left, user -> {
            RequestListFilterModel filterModel = this.requestListFilterModelParser.parse((CheckedUser)user, ctx.getOptions().getAllReqFilter());
            return Either.right((Object)this.requestListResponseAssembler.getResponse((CheckedUser)user, filterModel));
        });
    }
}

