/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.request;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusMapper;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers.StatusAndResolutionActivityProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListItem;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListItemProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon.RequestTypeIconDefinition;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestListItemProviderImpl
implements RequestListItemProvider {
    private final RequestStatusService requestStatusService;
    private final StatusAndResolutionActivityProvider statusAndResolutionActivityProvider;
    private final IssueHelper issueHelper;
    private final PortalInternalManager portalInternalManager;
    private final AvatarManager avatarManager;

    @Autowired
    public RequestListItemProviderImpl(RequestStatusService requestStatusService, StatusAndResolutionActivityProvider statusAndResolutionActivityProvider, IssueHelper issueHelper, PortalInternalManager portalInternalManager, AvatarManager avatarManager) {
        this.requestStatusService = requestStatusService;
        this.statusAndResolutionActivityProvider = statusAndResolutionActivityProvider;
        this.issueHelper = issueHelper;
        this.portalInternalManager = portalInternalManager;
        this.avatarManager = avatarManager;
    }

    @Override
    public RequestListItem getRequestListItemViewForMissingRequestType(CheckedUser user, Portal portal, Issue issue, VpOrigin origin) {
        RequestStatusMapper statusMapper = this.requestStatusService.getStatusMapperForMissingRequestType();
        long defaultIconId = this.avatarManager.getDefaultAvatarId(RequestTypeIconDefinition.ICON_TYPE);
        return this.getIssueListItemViewCommon(user, issue, statusMapper, defaultIconId, portal, (Option<Integer>)Option.none(), (Option<String>)Option.none());
    }

    @Override
    public RequestListItem getRequestListItemView(CheckedUser user, Portal portal, Issue issue, RequestType requestType, RequestStatusMapper statusMapper) {
        return this.getIssueListItemViewCommon(user, issue, statusMapper, requestType.getIconId(), portal, (Option<Integer>)Option.some((Object)requestType.getId()), (Option<String>)Option.some((Object)requestType.getName()));
    }

    private RequestListItem getIssueListItemViewCommon(CheckedUser user, Issue rawIssue, RequestStatusMapper statusMapper, long requestIcon, Portal portal, Option<Integer> requestTypeId, Option<String> requestTypeName) {
        Status statusObj = rawIssue.getStatus();
        String status = statusMapper.translateToCustomerStatus(statusObj);
        String resolution = (String)Option.option((Object)rawIssue.getResolution()).map(IssueConstant::getNameTranslation).getOrNull();
        boolean isNew = this.statusAndResolutionActivityProvider.isIssueNew(user.forJIRA(), rawIssue);
        Option<CheckedUser> reporterOpt = this.issueHelper.getReporterOpt(rawIssue);
        return new RequestListItem(rawIssue.getKey(), this.portalInternalManager.toPortalInternal(portal).getKey(), (Integer)requestTypeId.getOrNull(), requestIcon, (String)reporterOpt.map(CheckedUser::getDisplayName).getOrNull(), (String)requestTypeName.getOrNull(), rawIssue.getSummary(), isNew, resolution, status);
    }
}

