/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.request;

import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalAndRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalAndRequestTypeFilterCreator;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestListFilterModel;
import com.atlassian.servicedesk.internal.rest.requests.RequestListFilterOptions;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestListFilterModelParser {
    private static final String ORG_PREFIX = "org-";
    private static final String REQUEST_STATUS_FILTER_VALUE_OPEN = "open";
    private static final String REQUEST_STATUS_FILTER_VALUE_CLOSED = "closed";
    private static final String REQUEST_STATUS_FILTER_VALUE_ALL = "";
    private static final String REQUEST_OWNERSHIP_FILTER_VALUE_MINE = "";
    private static final String REQUEST_OWNERSHIP_FILTER_VALUE_OTHERS = "others";
    private static final String REQUEST_OWNERSHIP_FILTER_ALL_ORGANISATIONS = "all-orgs";
    private static final String REQUEST_OWNERSHIP_FILTER_VALUE_ALL = "all";
    private PortalAndRequestTypeFilterCreator portalAndRequestTypeFilterCreator;

    @Autowired
    public RequestListFilterModelParser(PortalAndRequestTypeFilterCreator portalAndRequestTypeFilterCreator) {
        this.portalAndRequestTypeFilterCreator = portalAndRequestTypeFilterCreator;
    }

    public RequestListFilterModel parse(CheckedUser user, RequestListFilterOptions options) {
        String queryReporter = StringUtils.defaultString((String)options.getReporter());
        String queryStatus = StringUtils.defaultString((String)options.getStatus());
        Integer queryPortalId = options.getPortalId();
        Integer queryRequestTypeId = options.getRequestTypeId();
        String queryFilter = options.getFilter();
        PortalAndRequestTypeFilter portalAndRequestTypeFilter = this.portalAndRequestTypeFilterCreator.getPortalAndRequestType(user, queryPortalId, queryRequestTypeId);
        Option filter2 = Option.option((Object)queryFilter);
        Option organisationId = Option.none();
        CustomerRequestQuery.REQUEST_OWNERSHIP reporter = this.getReporter(queryReporter);
        if (CustomerRequestQuery.REQUEST_OWNERSHIP.ORGANIZATION.equals((Object)reporter)) {
            organisationId = Option.option((Object)Integer.valueOf(queryReporter.substring(ORG_PREFIX.length())));
        }
        return new RequestListFilterModel(this.getStatus(queryStatus), reporter, portalAndRequestTypeFilter.getPortal(), portalAndRequestTypeFilter.getRequestType(), (Option<String>)filter2, options.getSelectedPage(), (Option<Integer>)organisationId);
    }

    private CustomerRequestQuery.REQUEST_OWNERSHIP getReporter(String reporter) {
        if (StringUtils.equalsIgnoreCase((String)reporter, (String)REQUEST_OWNERSHIP_FILTER_VALUE_ALL)) {
            return CustomerRequestQuery.REQUEST_OWNERSHIP.ALL_REQUESTS;
        }
        if (StringUtils.equalsIgnoreCase((String)reporter, (String)REQUEST_OWNERSHIP_FILTER_VALUE_OTHERS)) {
            return CustomerRequestQuery.REQUEST_OWNERSHIP.PARTICIPATED_REQUESTS;
        }
        if (StringUtils.equalsIgnoreCase((String)reporter, (String)REQUEST_OWNERSHIP_FILTER_ALL_ORGANISATIONS)) {
            return CustomerRequestQuery.REQUEST_OWNERSHIP.ALL_ORGANIZATIONS;
        }
        if (reporter.startsWith(ORG_PREFIX)) {
            return CustomerRequestQuery.REQUEST_OWNERSHIP.ORGANIZATION;
        }
        return CustomerRequestQuery.REQUEST_OWNERSHIP.OWNED_REQUESTS;
    }

    public String getReporterFilterValue(RequestListFilterModel requestListFilterModel) {
        if (requestListFilterModel.getOrganisationId().isDefined()) {
            return ORG_PREFIX + requestListFilterModel.getOrganisationId().get();
        }
        return this.getReporterFilterValue(requestListFilterModel.getReporter());
    }

    private String getReporterFilterValue(CustomerRequestQuery.REQUEST_OWNERSHIP ownership) {
        switch (ownership) {
            case ALL_REQUESTS: {
                return REQUEST_OWNERSHIP_FILTER_VALUE_ALL;
            }
            case PARTICIPATED_REQUESTS: {
                return REQUEST_OWNERSHIP_FILTER_VALUE_OTHERS;
            }
            case ALL_ORGANIZATIONS: {
                return REQUEST_OWNERSHIP_FILTER_ALL_ORGANISATIONS;
            }
        }
        return "";
    }

    private CustomerRequestQuery.REQUEST_STATUS getStatus(String status) {
        if (StringUtils.equalsIgnoreCase((String)status, (String)REQUEST_STATUS_FILTER_VALUE_OPEN)) {
            return CustomerRequestQuery.REQUEST_STATUS.OPEN_REQUESTS;
        }
        if (StringUtils.equalsIgnoreCase((String)status, (String)REQUEST_STATUS_FILTER_VALUE_CLOSED)) {
            return CustomerRequestQuery.REQUEST_STATUS.CLOSED_REQUESTS;
        }
        return CustomerRequestQuery.REQUEST_STATUS.ALL_REQUESTS;
    }

    public String getStatusFilterValue(CustomerRequestQuery.REQUEST_STATUS status) {
        switch (status) {
            case OPEN_REQUESTS: {
                return REQUEST_STATUS_FILTER_VALUE_OPEN;
            }
            case CLOSED_REQUESTS: {
                return REQUEST_STATUS_FILTER_VALUE_CLOSED;
            }
        }
        return "";
    }
}

