/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.request;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.api.webfragments.WebPanelBean;
import com.atlassian.servicedesk.internal.api.webfragments.WebSectionBean;
import com.atlassian.servicedesk.internal.customer.request.CustomerRequestContext;
import com.atlassian.servicedesk.internal.customer.request.CustomerRequestPanelService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.IssueViewProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.RequestDetailsResponseProviderHelper;
import com.atlassian.servicedesk.internal.feature.customer.request.CreateIssueResponse;
import com.atlassian.servicedesk.internal.feature.customer.request.RequestActionsService;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.PublicAccessCustomerInviteService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.feature.usermanagement.ServiceDeskUserPickerService;
import com.atlassian.servicedesk.internal.rest.responses.CustomerRequestView;
import com.atlassian.servicedesk.internal.rest.responses.RequestDetailsResponse;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class RequestDetailsResponseProviderHelperImpl
implements RequestDetailsResponseProviderHelper {
    private final CustomerUrlUtil customerUrlUtil;
    private final RequestActionsService portalLinkService;
    private final IssueViewProvider issueViewProvider;
    private final CustomerRequestPanelService requestPanelsService;
    private final ServiceDeskLicenseAndPermissionService serviceDeskPermissions;
    private final CustomerContextService customerContextService;
    private final RequestParticipantPermissionService requestParticipantPermissionService;
    private final PublicAccessCustomerInviteService publicAccessCustomerInviteService;
    private final ServiceDeskUserPickerService serviceDeskUserPickerService;

    @Autowired
    public RequestDetailsResponseProviderHelperImpl(CustomerUrlUtil customerUrlUtil, RequestActionsService portalLinkService, IssueViewProvider issueViewProvider, CustomerRequestPanelService requestPanelsService, ServiceDeskLicenseAndPermissionService serviceDeskPermissions, CustomerContextService customerContextService, RequestParticipantPermissionService requestParticipantPermissionService, PublicAccessCustomerInviteService publicAccessCustomerInviteService, ServiceDeskUserPickerService serviceDeskUserPickerService) {
        this.customerUrlUtil = customerUrlUtil;
        this.portalLinkService = portalLinkService;
        this.issueViewProvider = issueViewProvider;
        this.requestPanelsService = requestPanelsService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.customerContextService = customerContextService;
        this.requestParticipantPermissionService = requestParticipantPermissionService;
        this.publicAccessCustomerInviteService = publicAccessCustomerInviteService;
        this.serviceDeskUserPickerService = serviceDeskUserPickerService;
    }

    @Override
    public RequestDetailsResponse toResponse(CheckedUser user, CreateIssueResponse createIssueResponse, Portal portal, Project project, ServiceDesk serviceDesk, CustomerRequestView customerRequestView) {
        Issue issue = createIssueResponse.getIssue();
        CustomerRequestContext customerRequestContext = this.getCustomerRequestContext(user, issue, portal, serviceDesk, customerRequestView);
        return new RequestDetailsResponse(customerRequestView.getReporter(), customerRequestView.getParticipants(), customerRequestView.getOrganisations(), customerRequestView.getRequestTypeName(), issue.getKey(), issue.getIssueTypeId(), this.getIssueTypeName(issue), customerRequestView, this.canCreateAttachments(user, issue), this.canCreateIssues(user, project), this.canCreateComment(user, issue), this.canViewIssueInJIRA(user, issue), this.canAddAnyParticipant(user, issue), this.canRemoveParticipants(user, issue), this.canSearchParticipants(user, issue, project, serviceDesk), this.canSignupParticipants(user, issue, project, serviceDesk), this.canSubmitWithEmailAddress(user, issue, project, serviceDesk), this.getTopPanels(customerRequestContext), this.getOptionsPanels(customerRequestContext), this.getRequestedActionSections(issue, portal, serviceDesk, customerRequestView), this.getIssueLinkUrl(user, issue, project), this.getRequestDetailsBaseUrl(portal, issue), createIssueResponse.isCustomerInvited());
    }

    private boolean canCreateAttachments(CheckedUser user, Issue issue) {
        return this.serviceDeskPermissions.canCreateAttachment((SDUser)user, issue);
    }

    private boolean canCreateIssues(CheckedUser user, Project project) {
        return this.serviceDeskPermissions.canCreateRequest((SDUser)user, project);
    }

    private boolean canCreateComment(CheckedUser user, Issue issue) {
        return this.serviceDeskPermissions.canCreateComment((SDUser)user, issue);
    }

    private boolean canViewIssueInJIRA(CheckedUser user, Issue issue) {
        NoExceptionsCallable permissionCheck = () -> this.serviceDeskPermissions.canViewIssue((SDUser)user, issue) && this.serviceDeskPermissions.canAccessJIRA((SDUser)user);
        return (Boolean)this.customerContextService.runOutOfCustomerContext(permissionCheck);
    }

    private boolean canAddAnyParticipant(CheckedUser user, Issue issue) {
        return this.requestParticipantPermissionService.canAddAnyParticipant(user, issue);
    }

    private boolean canRemoveParticipants(CheckedUser user, Issue issue) {
        return this.canAddAnyParticipant(user, issue) && this.requestParticipantPermissionService.canRemoveAnyParticipant(user, issue);
    }

    private boolean canSearchParticipants(CheckedUser user, Issue issue, Project project, ServiceDesk serviceDesk) {
        return this.requestParticipantPermissionService.canSearchForAnyParticipantForIssue(user, issue, project, serviceDesk);
    }

    private boolean canSignupParticipants(CheckedUser user, Issue issue, Project project, ServiceDesk serviceDesk) {
        return this.canAddAnyParticipant(user, issue) && this.publicAccessCustomerInviteService.isSignupAndInviteSupported(user, serviceDesk, project);
    }

    private boolean canSubmitWithEmailAddress(CheckedUser user, Issue issue, Project project, ServiceDesk serviceDesk) {
        return this.serviceDeskUserPickerService.canSubmitWithEmailAddress(user, issue, project, serviceDesk);
    }

    private String getIssueLinkUrl(CheckedUser user, Issue issue, Project project) {
        return this.issueViewProvider.getIssueLinkURL(user, issue, project);
    }

    private String getRequestDetailsBaseUrl(Portal portal, Issue issue) {
        return this.customerUrlUtil.getPortalUrl(portal, issue.getKey());
    }

    private CustomerRequestContext getCustomerRequestContext(CheckedUser user, Issue issue, Portal portal, ServiceDesk serviceDesk, CustomerRequestView customerRequestView) {
        return new CustomerRequestContext(user.forJIRA(), serviceDesk, portal, issue, Long.valueOf(customerRequestView.getRequestTypeId()));
    }

    private List<WebPanelBean> getTopPanels(CustomerRequestContext customerRequestContext) {
        return this.requestPanelsService.getTopPanels(customerRequestContext);
    }

    private List<WebPanelBean> getOptionsPanels(CustomerRequestContext customerRequestContext) {
        return this.requestPanelsService.getOptionPanels(customerRequestContext);
    }

    private List<WebSectionBean> getRequestedActionSections(Issue issue, Portal portal, ServiceDesk serviceDesk, CustomerRequestView customerRequestView) {
        return this.portalLinkService.getRequestActionSections(serviceDesk, portal, customerRequestView.getRequestTypeName(), issue, customerRequestView);
    }

    private String getIssueTypeName(Issue issue) {
        return (String)Option.option((Object)issue.getIssueType()).map(IssueConstant::getName).getOrElse((Object)"");
    }
}

