/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.request;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestCreateResponseProviderHelper;
import com.atlassian.servicedesk.internal.feature.jira.issuetype.ServiceDeskIssueTypeManager;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.RequestCreateResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestCreateResponseProvider
implements CustomerResponseProvider<RequestCreateResponse> {
    private final UserFactory userFactory;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final ServiceDeskIssueTypeManager serviceDeskIssueTypeManager;
    private final InternalServiceDeskService internalServiceDeskService;
    private final InternalPortalService internalPortalService;
    private final RequestTypeInternalService requestTypeInternalService;
    private final CommonErrors commonErrors;
    private final RequestCreateResponseProviderHelper requestCreateResponseProviderHelper;

    @Autowired
    public RequestCreateResponseProvider(UserFactory userFactory, InternalPortalService internalPortalService, ServiceDeskProjectService serviceDeskProjectService, ServiceDeskIssueTypeManager serviceDeskIssueTypeManager, InternalServiceDeskService internalServiceDeskService, RequestTypeInternalService requestTypeInternalService, CommonErrors commonErrors, RequestCreateResponseProviderHelper requestCreateResponseProviderHelper) {
        this.userFactory = userFactory;
        this.internalPortalService = internalPortalService;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.serviceDeskIssueTypeManager = serviceDeskIssueTypeManager;
        this.internalServiceDeskService = internalServiceDeskService;
        this.requestTypeInternalService = requestTypeInternalService;
        this.commonErrors = commonErrors;
        this.requestCreateResponseProviderHelper = requestCreateResponseProviderHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RequestCreateResponse> getResponse(ModelsRequest ctx) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getRequestTypeId(ctx)).then((user, requestTypeId) -> this.buildResponse((CheckedUser)user, ctx.getOptions().getPortalId(), (Integer)requestTypeId)).yield((user, requestTypeId, response) -> response);
    }

    public io.atlassian.fugue.Either<AnError, RequestCreateResponse> buildResponse(CheckedUser user, long portalIdFromContext, Integer requestTypeId) {
        return Steps.begin(this.getPortalInternal(user, portalIdFromContext)).then(portalInternal -> this.getProject(user, (PortalInternal)portalInternal)).then((portalInternal, project) -> this.getServiceDesk(user, (Project)project)).then((portalInternal, project, serviceDesk) -> this.getRequestType(user, requestTypeId, (Project)project)).then((portalInternal, project, serviceDesk, requestType) -> this.getIssueType((RequestType)requestType, (Project)project)).yield((portalInternal, project, serviceDesk, requestType, issueType) -> this.requestCreateResponseProviderHelper.buildResponse(user, (Portal)portalInternal, (Project)project, (ServiceDesk)serviceDesk, (RequestType)requestType, (IssueType)issueType));
    }

    private io.atlassian.fugue.Either<AnError, Integer> getRequestTypeId(ModelsRequest ctx) {
        try {
            return io.atlassian.fugue.Either.right((Object)Math.toIntExact(ctx.getOptions().getReqCreate().getId()));
        }
        catch (ArithmeticException ex) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.REQUEST_TYPE_INTEGRITY_ERROR());
        }
    }

    private io.atlassian.fugue.Either<AnError, PortalInternal> getPortalInternal(CheckedUser user, long portalIdFromContext) {
        return this.internalPortalService.getPortalById(user, portalIdFromContext).map(portal -> this.internalPortalService.toPortalInternal((Portal)portal));
    }

    private io.atlassian.fugue.Either<AnError, Project> getProject(CheckedUser user, PortalInternal portalInternal) {
        return this.serviceDeskProjectService.getProjectById(user, portalInternal.getProjectId());
    }

    private io.atlassian.fugue.Either<AnError, ServiceDesk> getServiceDesk(CheckedUser user, Project project) {
        return this.internalServiceDeskService.getServiceDeskForProject(user, project, false);
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestType(CheckedUser user, Integer requestTypeId, Project project) {
        return this.requestTypeInternalService.getPreviewableRequestTypeById(user, requestTypeId, project);
    }

    private io.atlassian.fugue.Either<AnError, IssueType> getIssueType(RequestType requestType, Project project) {
        return this.serviceDeskIssueTypeManager.getIssueTypeForProject(requestType.getIssueTypeId(), project);
    }
}

