/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.response.UnsubscribedConfirmResponse;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.requests.UnsubscribedConfirmationOptions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnsubscribedConfirmationResponseProvider
implements CustomerResponseProvider<UnsubscribedConfirmResponse> {
    private final PortalUrlsProvider portalUrlsProvider;
    private final CommonErrors commonErrors;
    private final FeatureManager featureManager;
    private final IssueManager issueManager;
    private final PortalInternalManager portalInternalManager;

    @Autowired
    public UnsubscribedConfirmationResponseProvider(PortalUrlsProvider portalUrlsProvider, CommonErrors commonErrors, FeatureManager featureManager, IssueManager issueManager, PortalInternalManager portalInternalManager) {
        this.portalUrlsProvider = portalUrlsProvider;
        this.commonErrors = commonErrors;
        this.featureManager = featureManager;
        this.issueManager = issueManager;
        this.portalInternalManager = portalInternalManager;
    }

    @Override
    public Either<AnError, UnsubscribedConfirmResponse> getResponse(ModelsRequest ctx) {
        UnsubscribedConfirmationOptions unsubscribeConfirmation = ctx.getOptions().getUnsubscribedConfirmation();
        Option<AnError> unsubscribeErrorOpt = unsubscribeConfirmation.getError();
        if (unsubscribeErrorOpt.isDefined()) {
            return Either.left((Object)unsubscribeErrorOpt.get());
        }
        return this.buildConfirmResponse(unsubscribeConfirmation);
    }

    private Either<AnError, UnsubscribedConfirmResponse> buildConfirmResponse(UnsubscribedConfirmationOptions unsubscribeRequestConfirm) {
        return Steps.begin(this.getIssue(unsubscribeRequestConfirm)).then(issue -> this.getPortal(unsubscribeRequestConfirm)).yield((issue, portal) -> new UnsubscribedConfirmResponse(issue.getKey(), this.getRequestUrl((Issue)issue, (Portal)portal).toString(), issue.getSummary()));
    }

    private Either<AnError, Issue> getIssue(UnsubscribedConfirmationOptions options) {
        Option<String> issueKey = options.getIssueKey();
        if (issueKey.isEmpty()) {
            return Either.left((Object)this.commonErrors.REQUEST_NOT_FOUND());
        }
        MutableIssue issue = this.issueManager.getIssueObject((String)issueKey.get());
        if (issue == null) {
            return Either.left((Object)this.commonErrors.REQUEST_NOT_FOUND());
        }
        return Either.right((Object)issue);
    }

    private Either<AnError, PortalInternal> getPortal(UnsubscribedConfirmationOptions options) {
        Option<Integer> portalId = options.getPortalId();
        if (portalId.isEmpty()) {
            return Either.left((Object)this.commonErrors.SERVICEDESK_NOT_FOUND());
        }
        return this.portalInternalManager.getPortalById((long)((Integer)portalId.get()));
    }

    private URI getRequestUrl(Issue issue, Portal portal) {
        return this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE).request(issue.getKey());
    }
}

